/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.po;

import com.centit.framework.core.dao.DictionaryMap;
import com.centit.support.algorithm.DatetimeOpt;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="F_WORK_DAY")
public class WorkDay
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="WORK_DAY")
    private String workDay;
    public static String WORK_DAY_TYPE_IGNORE = "0";
    public static String WORK_DAY_TYPE_HOLIDAY = "A";
    public static String WORK_DAY_TYPE_SHIFT = "B";
    public static String WORK_DAY_TYPE_WORKDAY = "C";
    public static String WORK_DAY_TYPE_WEEKEND = "D";
    @Column(name="DAY_TYPE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e{min}\u5927\u4e8e{max}")
    @DictionaryMap(value={"DAY_TYPE"}, fieldName={"dayTypeDesc"})
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e{min}\u5927\u4e8e{max}") String dayType;
    @Column(name="WORK_TIME_TYPE")
    @Length(max=20, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e{min}\u5927\u4e8e{max}")
    private @Length(max=20, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e{min}\u5927\u4e8e{max}") String workTimeType;
    @Column(name="WORK_DAY_DESC")
    @Length(max=255, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e{min}\u5927\u4e8e{max}")
    private @Length(max=255, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e{min}\u5927\u4e8e{max}") String workDayDesc;

    public static String toWorkDayId(String sDate) {
        return DatetimeOpt.convertDateToString((Date)DatetimeOpt.smartPraseDate((String)sDate), (String)"yyyyMMdd");
    }

    public static String toWorkDayId(Date date) {
        return DatetimeOpt.convertDateToString((Date)date, (String)"yyyyMMdd");
    }

    public static Date toWorkDayDate(String date) {
        return DatetimeOpt.convertStringToDate((String)date, (String)"yyyyMMdd");
    }

    public Date getWorkDate() {
        return WorkDay.toWorkDayDate(this.getWorkDay());
    }

    public WorkDay copy(WorkDay other) {
        this.setWorkDay(other.getWorkDay());
        this.dayType = other.getDayType();
        this.workTimeType = other.getWorkTimeType();
        this.workDayDesc = other.getWorkDayDesc();
        return this;
    }

    public WorkDay copyNotNullProperty(WorkDay other) {
        if (other.getWorkDay() != null) {
            this.setWorkDay(other.getWorkDay());
        }
        if (other.getDayType() != null) {
            this.dayType = other.getDayType();
        }
        if (other.getWorkTimeType() != null) {
            this.workTimeType = other.getWorkTimeType();
        }
        if (other.getWorkDayDesc() != null) {
            this.workDayDesc = other.getWorkDayDesc();
        }
        return this;
    }

    public WorkDay clearProperties() {
        this.dayType = null;
        this.workTimeType = null;
        this.workDayDesc = null;
        return this;
    }

    public String getWorkDay() {
        return this.workDay;
    }

    public String getDayType() {
        return this.dayType;
    }

    public String getWorkTimeType() {
        return this.workTimeType;
    }

    public String getWorkDayDesc() {
        return this.workDayDesc;
    }

    public void setWorkDay(String workDay) {
        this.workDay = workDay;
    }

    public void setDayType(String dayType) {
        this.dayType = dayType;
    }

    public void setWorkTimeType(String workTimeType) {
        this.workTimeType = workTimeType;
    }

    public void setWorkDayDesc(String workDayDesc) {
        this.workDayDesc = workDayDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkDay)) {
            return false;
        }
        WorkDay other = (WorkDay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$workDay = this.getWorkDay();
        String other$workDay = other.getWorkDay();
        if (this$workDay == null ? other$workDay != null : !this$workDay.equals(other$workDay)) {
            return false;
        }
        String this$dayType = this.getDayType();
        String other$dayType = other.getDayType();
        if (this$dayType == null ? other$dayType != null : !this$dayType.equals(other$dayType)) {
            return false;
        }
        String this$workTimeType = this.getWorkTimeType();
        String other$workTimeType = other.getWorkTimeType();
        if (this$workTimeType == null ? other$workTimeType != null : !this$workTimeType.equals(other$workTimeType)) {
            return false;
        }
        String this$workDayDesc = this.getWorkDayDesc();
        String other$workDayDesc = other.getWorkDayDesc();
        return !(this$workDayDesc == null ? other$workDayDesc != null : !this$workDayDesc.equals(other$workDayDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkDay;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $workDay = this.getWorkDay();
        result = result * 59 + ($workDay == null ? 43 : $workDay.hashCode());
        String $dayType = this.getDayType();
        result = result * 59 + ($dayType == null ? 43 : $dayType.hashCode());
        String $workTimeType = this.getWorkTimeType();
        result = result * 59 + ($workTimeType == null ? 43 : $workTimeType.hashCode());
        String $workDayDesc = this.getWorkDayDesc();
        result = result * 59 + ($workDayDesc == null ? 43 : $workDayDesc.hashCode());
        return result;
    }

    public String toString() {
        return "WorkDay(workDay=" + this.getWorkDay() + ", dayType=" + this.getDayType() + ", workTimeType=" + this.getWorkTimeType() + ", workDayDesc=" + this.getWorkDayDesc() + ")";
    }
}

