/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service;

import com.centit.framework.model.adapter.OperationLogWriter;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.system.po.ESOperationLog;
import com.centit.search.document.ESDocument;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.support.common.ObjectException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="elkOptLogManager")
public class ElkOptLogManager
implements OperationLogWriter {
    @Autowired(required=false)
    private ESIndexer esObjectIndexer;

    public void save(OperationLog operationLog) {
        ESOperationLog esOperationLog = ESOperationLog.fromOperationLog(operationLog, null);
        if (this.esObjectIndexer.saveNewDocument((ESDocument)esOperationLog) == null) {
            throw new ObjectException(500, "elasticsearch\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public void save(List<OperationLog> optLogs) {
        for (OperationLog operationLog : optLogs) {
            this.save(operationLog);
        }
    }

    public void deleteObjectById(String docId) {
        if (!this.esObjectIndexer.deleteDocument(docId)) {
            throw new ObjectException(500, "elasticsearch\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public void updateOperationLog(OperationLog operationLog, String logId) {
        ESOperationLog esOperationLog = ESOperationLog.fromOperationLog(operationLog, logId);
        if (this.esObjectIndexer.mergeDocument((ESDocument)esOperationLog) == null) {
            throw new ObjectException(500, "elasticsearch\u64cd\u4f5c\u5931\u8d25");
        }
    }
}

