/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.po;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.search.annotation.ESField;
import com.centit.search.annotation.ESType;
import com.centit.search.document.ESDocument;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.StringUtils;

@Entity
@ESType(indexName="esoperationlog")
public class ESOperationLog
implements ESDocument,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @ESField(type="text", index=true, query=true)
    private String logId;
    @ESField(type="text", index=true, query=true)
    private String logLevel;
    @ESField(type="text", index=true, query=true)
    private String userCode;
    @ESField(type="text", index=true, query=true)
    private String unitCode;
    @ESField(type="text", index=true, query=true)
    private String correlationId;
    @ESField(type="date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date optTime;
    @ESField(type="text", index=true, query=true)
    private String optId;
    @ESField(type="text", index=true)
    private String optMethod;
    @ESField(type="text", index=true)
    private String optTag;
    @ESField(type="text", index=true, query=true, highlight=true, analyzer="ik_smart")
    private String optContent;
    @ESField(type="text", index=true, query=true, highlight=true, analyzer="ik_smart")
    private String newValue;
    @ESField(type="text", index=true, query=true, highlight=true, analyzer="ik_smart")
    private String oldValue;

    public String obtainDocumentId() {
        return this.logId;
    }

    public JSONObject toJSONObject() {
        return (JSONObject)JSON.toJSON((Object)this);
    }

    public static ESOperationLog fromOperationLog(OperationLog log, String logId) {
        ESOperationLog esLog = new ESOperationLog();
        if (StringUtils.isBlank((CharSequence)logId)) {
            esLog.setLogId(UUID.randomUUID().toString().replaceAll("-", ""));
        } else {
            esLog.setLogId(logId);
        }
        esLog.setOptTime(log.getOptTime());
        esLog.setCorrelationId(log.getCorrelationId());
        esLog.setLogLevel(log.getLogLevel());
        esLog.setNewValue(log.getNewValue());
        esLog.setOldValue(log.getOldValue());
        esLog.setOptContent(log.getOptContent());
        esLog.setOptId(log.getOptId());
        esLog.setOptMethod(log.getOptMethod());
        esLog.setOptTag(log.getOptTag());
        esLog.setUnitCode(log.getUnitCode());
        esLog.setUserCode(log.getUserCode());
        return esLog;
    }

    public String getLogId() {
        return this.logId;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Date getOptTime() {
        return this.optTime;
    }

    public String getOptId() {
        return this.optId;
    }

    public String getOptMethod() {
        return this.optMethod;
    }

    public String getOptTag() {
        return this.optTag;
    }

    public String getOptContent() {
        return this.optContent;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setOptTime(Date optTime) {
        this.optTime = optTime;
    }

    public void setOptId(String optId) {
        this.optId = optId;
    }

    public void setOptMethod(String optMethod) {
        this.optMethod = optMethod;
    }

    public void setOptTag(String optTag) {
        this.optTag = optTag;
    }

    public void setOptContent(String optContent) {
        this.optContent = optContent;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESOperationLog)) {
            return false;
        }
        ESOperationLog other = (ESOperationLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$logId = this.getLogId();
        String other$logId = other.getLogId();
        if (this$logId == null ? other$logId != null : !this$logId.equals(other$logId)) {
            return false;
        }
        String this$logLevel = this.getLogLevel();
        String other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        String this$userCode = this.getUserCode();
        String other$userCode = other.getUserCode();
        if (this$userCode == null ? other$userCode != null : !this$userCode.equals(other$userCode)) {
            return false;
        }
        String this$unitCode = this.getUnitCode();
        String other$unitCode = other.getUnitCode();
        if (this$unitCode == null ? other$unitCode != null : !this$unitCode.equals(other$unitCode)) {
            return false;
        }
        String this$correlationId = this.getCorrelationId();
        String other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        Date this$optTime = this.getOptTime();
        Date other$optTime = other.getOptTime();
        if (this$optTime == null ? other$optTime != null : !((Object)this$optTime).equals(other$optTime)) {
            return false;
        }
        String this$optId = this.getOptId();
        String other$optId = other.getOptId();
        if (this$optId == null ? other$optId != null : !this$optId.equals(other$optId)) {
            return false;
        }
        String this$optMethod = this.getOptMethod();
        String other$optMethod = other.getOptMethod();
        if (this$optMethod == null ? other$optMethod != null : !this$optMethod.equals(other$optMethod)) {
            return false;
        }
        String this$optTag = this.getOptTag();
        String other$optTag = other.getOptTag();
        if (this$optTag == null ? other$optTag != null : !this$optTag.equals(other$optTag)) {
            return false;
        }
        String this$optContent = this.getOptContent();
        String other$optContent = other.getOptContent();
        if (this$optContent == null ? other$optContent != null : !this$optContent.equals(other$optContent)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        return !(this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ESOperationLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $logId = this.getLogId();
        result = result * 59 + ($logId == null ? 43 : $logId.hashCode());
        String $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        String $userCode = this.getUserCode();
        result = result * 59 + ($userCode == null ? 43 : $userCode.hashCode());
        String $unitCode = this.getUnitCode();
        result = result * 59 + ($unitCode == null ? 43 : $unitCode.hashCode());
        String $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        Date $optTime = this.getOptTime();
        result = result * 59 + ($optTime == null ? 43 : ((Object)$optTime).hashCode());
        String $optId = this.getOptId();
        result = result * 59 + ($optId == null ? 43 : $optId.hashCode());
        String $optMethod = this.getOptMethod();
        result = result * 59 + ($optMethod == null ? 43 : $optMethod.hashCode());
        String $optTag = this.getOptTag();
        result = result * 59 + ($optTag == null ? 43 : $optTag.hashCode());
        String $optContent = this.getOptContent();
        result = result * 59 + ($optContent == null ? 43 : $optContent.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        return result;
    }

    public String toString() {
        return "ESOperationLog(logId=" + this.getLogId() + ", logLevel=" + this.getLogLevel() + ", userCode=" + this.getUserCode() + ", unitCode=" + this.getUnitCode() + ", correlationId=" + this.getCorrelationId() + ", optTime=" + this.getOptTime() + ", optId=" + this.getOptId() + ", optMethod=" + this.getOptMethod() + ", optTag=" + this.getOptTag() + ", optContent=" + this.getOptContent() + ", newValue=" + this.getNewValue() + ", oldValue=" + this.getOldValue() + ")";
    }
}

