/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.system.service.ElkOptLogManager;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/elkoptlog"})
@Api(tags={"elk\u65e5\u5fd7\u64cd\u4f5c\u63a7\u5236\u5668"})
public class ElkOptLogController
extends BaseController {
    @Resource
    ElkOptLogManager elkOptLogManager;
    @Autowired(required=false)
    private ESSearcher esObjectSearcher;

    @ApiOperation(value="\u5355\u6761\u65b0\u589e\u65e5\u5fd7\u4fe1\u606f")
    @RequestMapping(value={"/createOperationLog"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public void createOperationLog(@RequestBody OperationLog operationLog) throws IOException {
        this.elkOptLogManager.save(operationLog);
    }

    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u65e5\u5fd7\u4fe1\u606f")
    @RequestMapping(value={"/batchCreateOperationLog"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public void batchCreateOperationLog(@RequestBody List<OperationLog> operationLogs) throws IOException {
        operationLogs.forEach(esOperationLog -> this.elkOptLogManager.save((OperationLog)esOperationLog));
    }

    @ApiOperation(value="\u5220\u9664\u65e5\u5fd7\u4fe1\u606f")
    @RequestMapping(value={"/deleteOperationLog/{logId}"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public void deleteQuestionCatalog(@PathVariable String logId) {
        this.elkOptLogManager.deleteObjectById(logId);
    }

    @ApiOperation(value="\u4fee\u6539\u65e5\u5fd7\u4fe1\u606f")
    @RequestMapping(value={"/updateOperationLog/{logId}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public void updateOperationLog(@RequestBody OperationLog operationLog, @PathVariable String logId) {
        this.elkOptLogManager.updateOperationLog(operationLog, logId);
    }

    @ApiOperation(value="\u7cbe\u786e\u67e5\u8be2\u65e5\u5fd7\u4fe1\u606f")
    @RequestMapping(value={"/listES/{map}/{value}/{queryWord}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Map<String, Object>> listEs(String map, String value, String queryWord, PageDesc pageDesc) {
        Pair res = this.esObjectSearcher.search(CollectionsOpt.createHashMap((Object[])new Object[]{map, value}), queryWord, pageDesc.getPageNo(), pageDesc.getPageSize());
        pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)res.getLeft()));
        return PageQueryResult.createResult((Collection)((Collection)res.getRight()), (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u65e5\u5fd7\u4fe1\u606f\uff08\u4e0d\u586b\u5173\u952e\u5b57\u9ed8\u8ba4\u67e5\u8be2\u5168\u90e8\uff09")
    @RequestMapping(value={"/listESall"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Map<String, Object>> listEsAll(String queryWord, PageDesc pageDesc) {
        Pair res = this.esObjectSearcher.search(queryWord, pageDesc.getPageNo(), pageDesc.getPageSize());
        pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)res.getLeft()));
        return PageQueryResult.createResult((Collection)((Collection)res.getRight()), (PageDesc)pageDesc);
    }
}

