/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.transaction;

import com.centit.product.metadata.transaction.AbstractSourceConnectThreadHolder;
import com.centit.product.metadata.transaction.MetadataJdbcTransaction;
import java.sql.SQLException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class MetadataJdbcTransactionAspect {
    protected static final Logger logger = LoggerFactory.getLogger(MetadataJdbcTransactionAspect.class);

    @Pointcut(value="@annotation(com.centit.product.metadata.transaction.MetadataJdbcTransaction)")
    public void transactionAspect() {
    }

    @AfterThrowing(pointcut="transactionAspect() && @annotation(transaction)", throwing="ex")
    public void doAfterThrowing(JoinPoint joinPoint, MetadataJdbcTransaction transaction, Throwable ex) {
        if (ex instanceof RuntimeException) {
            try {
                AbstractSourceConnectThreadHolder.rollbackAndRelease();
            }
            catch (SQLException e) {
                logger.error(e.getLocalizedMessage());
            }
        }
    }

    @AfterReturning(pointcut="transactionAspect() && @annotation(transaction)")
    public void doAfterReturning(JoinPoint joinPoint, MetadataJdbcTransaction transaction) {
        try {
            AbstractSourceConnectThreadHolder.commitAndRelease();
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage());
        }
    }
}

