/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.centit.product.metadata.api.MetadataManageService;
import com.centit.product.metadata.dao.MetaOptRelationDao;
import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.product.metadata.po.MetaOptRelation;
import com.centit.support.algorithm.CollectionsOpt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MetadataManageServiceImpl
implements MetadataManageService {
    @Autowired
    private SourceInfoDao sourceInfoDao;
    protected Logger logger = LoggerFactory.getLogger(MetadataManageService.class);
    @Autowired
    MetaOptRelationDao metaOptRelationDao;

    @Transactional
    public int deleteMetaOptRelationByOptId(String optId) {
        if (StringUtils.isBlank((CharSequence)optId)) {
            this.logger.info("\u6839\u636eoptId\u5220\u9664\u5173\u8054\u5173\u7cfb\u63a5\u53e3\u53c2\u6570optId\u4e3a\u7a7a\u3002");
            return 0;
        }
        List metaOptRelations = this.metaOptRelationDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId}));
        if (CollectionUtils.isEmpty((Collection)metaOptRelations)) {
            this.logger.info("\u6839\u636eoptId\u672a\u67e5\u8be2\u5230\u5173\u8054\u4fe1\u606f\u3002optId:{}", (Object)optId);
            return 0;
        }
        Set ids = metaOptRelations.stream().map(MetaOptRelation::getId).collect(Collectors.toSet());
        for (String id : ids) {
            this.metaOptRelationDao.deleteObjectById((Object)id);
        }
        return ids.size();
    }

    public int countDataBase(Map<String, Object> params) {
        return this.sourceInfoDao.countDataBase(params);
    }
}

