/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.product.metadata.service.PropertyConvertor;
import com.centit.product.metadata.service.SourceInfoMetadata;
import com.centit.support.common.CachedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sourceInfoMetadata")
@Transactional
public class SourceInfoMetadataImpl
implements SourceInfoMetadata {
    @Autowired
    private SourceInfoDao sourceInfoDao;
    private PropertyConvertor propertyConvertor = null;
    private final CachedMap<String, SourceInfo> sourceInfoCache = new CachedMap(this::loadSourceInfo, 900L);

    public void setPropertyConvertor(PropertyConvertor propertyConvertor) {
        this.propertyConvertor = propertyConvertor;
    }

    protected SourceInfo loadSourceInfo(String databaseCode) {
        SourceInfo sourceInfo = this.sourceInfoDao.getDatabaseInfoById(databaseCode);
        if (this.propertyConvertor == null || sourceInfo == null) {
            return sourceInfo;
        }
        return this.propertyConvertor.convertSourceInfo(sourceInfo);
    }

    public SourceInfo fetchSourceInfo(String databaseCode) {
        return (SourceInfo)this.sourceInfoCache.getCachedValue((Object)databaseCode);
    }

    public SourceInfo convertorSourceInfo(SourceInfo sourceInfo) {
        if (this.propertyConvertor == null || sourceInfo == null) {
            return sourceInfo;
        }
        return this.propertyConvertor.convertSourceInfo(sourceInfo);
    }

    public void refreshCache() {
        this.sourceInfoCache.evictCache();
    }

    public void refreshCache(String databaseCode) {
        this.sourceInfoCache.evictIdentifiedCache((Object)databaseCode);
    }
}

