/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.centit.product.metadata.dao.MetaOptRelationDao;
import com.centit.product.metadata.po.MetaOptRelation;
import com.centit.product.metadata.service.MetaOptRelationService;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MetaOptRelationServiceImpl
implements MetaOptRelationService {
    protected Logger logger = LoggerFactory.getLogger(MetaOptRelationService.class);
    @Autowired
    MetaOptRelationDao metaOptRelationDao;

    @Override
    public void createMetaOptRelation(MetaOptRelation relation) {
        this.metaOptRelationDao.saveNewObject(relation);
    }

    @Override
    public void updateMetaOptRelation(MetaOptRelation relation) {
        this.metaOptRelationDao.updateObject(relation);
    }

    @Override
    public void deleteMetaOptRelation(String relationId) {
        this.metaOptRelationDao.deleteObjectById((Object)relationId);
    }

    @Override
    public List<MetaOptRelation> listMetaOptRelation(Map<String, Object> params, PageDesc pageDesc) {
        return this.metaOptRelationDao.listObjectsByProperties(params, pageDesc);
    }

    @Override
    public MetaOptRelation getMetaOptRelation(String relationId) {
        return this.metaOptRelationDao.getObjectById((Object)relationId);
    }

    @Override
    public MetaOptRelation getMetaOptRelation(String osId, String tableId) {
        return this.metaOptRelationDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"osId", osId, "tableId", tableId}));
    }

    @Override
    @Transactional
    public void batchAddOptRelation(List<MetaOptRelation> relations) {
        for (MetaOptRelation relation : relations) {
            MetaOptRelation metaOptRelation = this.metaOptRelationDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", relation.getOptId(), "tableId", relation.getTableId()}));
            if (null != metaOptRelation) {
                relation.setId(metaOptRelation.getId());
                this.metaOptRelationDao.updateObject(metaOptRelation);
                continue;
            }
            this.metaOptRelationDao.saveNewObject(relation);
        }
    }
}

