/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.product.metadata.api.ISourceInfo;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaRelDetail;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.product.metadata.service.MetaDataCache;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.product.metadata.service.SourceInfoMetadata;
import com.centit.product.metadata.transaction.AbstractSourceConnectThreadHolder;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6570\u636e\u5e93\u5143\u6570\u636e\u67e5\u8be2", tags={"\u5143\u6570\u636e\u67e5\u8be2"})
@RestController
@RequestMapping(value={"query"})
public class MetadataQueryController
extends BaseController {
    @Autowired
    private SourceInfoMetadata sourceInfoMetadata;
    @Autowired
    private MetaDataService metaDataService;
    @Autowired
    private MetaDataCache metaDataCache;

    @ApiOperation(value="\u6570\u636e\u5e93\u5217\u8868")
    @GetMapping(value={"/databases"})
    @WrapUpResponseBody
    public List<SourceInfo> databases(HttpServletRequest request) {
        Map parameters = MetadataQueryController.collectRequestParameters((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            return Collections.emptyList();
        }
        parameters.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        return this.metaDataService.listDatabase(parameters);
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u4e2d\u8868\u5206\u9875\u67e5\u8be2")
    @ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93\u4ee3\u7801")
    @GetMapping(value={"/{databaseCode}/tables"})
    @WrapUpResponseBody
    public PageQueryResult<Object> metaTables(@PathVariable String databaseCode, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = MetadataQueryController.collectRequestParameters((HttpServletRequest)request);
        searchColumn.put("databaseCode", databaseCode);
        JSONArray list = this.metaDataService.listMetaTables(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)list, (PageDesc)pageDesc, (Class[])new Class[]{MetaTable.class});
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u8868\u5143\u6570\u636e")
    @ApiImplicitParam(name="tableId", value="\u8868ID")
    @GetMapping(value={"/table/{tableId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public MetaTable getMetaTable(@PathVariable String tableId) {
        return this.metaDataService.getMetaTable(tableId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u8868\u5143\u6570\u636e(\u5305\u62ec\u5b57\u6bb5\u4fe1\u606f\u548c\u5173\u8054\u8868\u4fe1\u606f)")
    @ApiImplicitParam(name="tableId", value="\u8868ID")
    @GetMapping(value={"/table/{tableId}/all"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public MetaTable getMetaTableWithRelations(@PathVariable String tableId) {
        return this.metaDataService.getMetaTableWithRelations(tableId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u5143\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868ID")})
    @GetMapping(value={"/{tableId}/columns"})
    @WrapUpResponseBody
    public PageQueryResult<MetaColumn> listColumns(@PathVariable String tableId, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = MetadataQueryController.collectRequestParameters((HttpServletRequest)request);
        searchColumn.put("tableId", tableId);
        List<MetaColumn> list = this.metaDataService.listMetaColumns(searchColumn, pageDesc);
        return PageQueryResult.createResult(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5217\u5143\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868\u5143\u6570\u636eID"), @ApiImplicitParam(name="columnName", value="\u5217\u540d")})
    @GetMapping(value={"/{tableId}/column/{columnName}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public MetaColumn getColumn(@PathVariable String tableId, @PathVariable String columnName) {
        return this.metaDataService.getMetaColumn(tableId, columnName);
    }

    @ApiOperation(value="\u67e5\u8be2\u5173\u8054\u5173\u7cfb\u5143\u6570\u636e")
    @GetMapping(value={"/{tableId}/relations"})
    @WrapUpResponseBody
    public PageQueryResult<MetaRelation> metaRelation(@PathVariable String tableId, HttpServletRequest request, PageDesc pageDesc) {
        Map condition = BaseController.collectRequestParameters((HttpServletRequest)request);
        condition.put("parentTableId", tableId);
        List<MetaRelation> list = this.metaDataService.listMetaRelation(condition, pageDesc);
        return PageQueryResult.createResultMapDict(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5217\u53c2\u7167\u6570\u636e\uff0c REFERENCE_TYPE\uff01=\u20180\u2019\u6709\u6548")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868\u5143\u6570\u636eID"), @ApiImplicitParam(name="columnName", value="\u5217\u540d")})
    @GetMapping(value={"/{tableId}/reference/{columnName}"})
    @WrapUpResponseBody
    public Map<String, String> getColumnReferenceData(@PathVariable String tableId, @PathVariable String columnName, HttpServletRequest request) {
        MetaColumn col = this.metaDataService.getMetaColumn(tableId, columnName);
        if (col == null || StringUtils.isBlank((CharSequence)col.getReferenceType()) || "0".equals(col.getReferenceType())) {
            return null;
        }
        switch (col.getReferenceType()) {
            case "1": {
                return CodeRepositoryUtil.getLabelValueMap((String)col.getReferenceData());
            }
            case "2": {
                return CollectionsOpt.objectMapToStringMap((Map)CollectionsOpt.objectToMap((Object)JSON.parse((String)col.getReferenceData())));
            }
            case "3": {
                Map searchColumn = MetadataQueryController.collectRequestParameters((HttpServletRequest)request);
                MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
                SourceInfo sourceInfo = this.sourceInfoMetadata.fetchSourceInfo(tableInfo.getDatabaseCode());
                try {
                    List objects;
                    Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)sourceInfo);
                    Object object = null;
                    try {
                        QueryAndNamedParams qAp = QueryUtils.translateQuery((String)col.getReferenceData(), (Object)searchColumn);
                        objects = DatabaseAccess.findObjectsBySql((Connection)conn, (String)qAp.getQuery(), (Object)qAp.getParams());
                    }
                    catch (Throwable qAp) {
                        object = qAp;
                        throw qAp;
                    }
                    finally {
                        if (conn != null) {
                            if (object != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable qAp) {
                                    ((Throwable)object).addSuppressed(qAp);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                    if (objects != null) {
                        HashMap<String, String> stringMap = new HashMap<String, String>(objects.size() * 3 / 2 + 1);
                        for (Object[] objs : objects) {
                            if (objs == null || objs.length < 2) continue;
                            stringMap.put(StringBaseOpt.objectToString((Object)objs[0]), StringBaseOpt.objectToString((Object)objs[1]));
                        }
                        return stringMap;
                    }
                }
                catch (IOException | SQLException e) {
                    throw new ObjectException((Object)col, 620, (Throwable)e);
                }
                return null;
            }
            case "Y": {
                HashMap<String, String> stringMap = new HashMap<String, String>(120);
                for (int i = 1; i < 100; ++i) {
                    stringMap.put(String.valueOf(1950 + i), String.valueOf(1950 + i));
                }
                return stringMap;
            }
            case "M": {
                HashMap<String, String> stringMap = new HashMap<String, String>(100);
                for (int i = 1; i < 13; ++i) {
                    stringMap.put(String.valueOf(i), String.valueOf(i));
                }
                return stringMap;
            }
        }
        return null;
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5e93\u539f\u8868")
    @ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93ID")
    @GetMapping(value={"/origintables/{databaseCode}"})
    @WrapUpResponseBody
    public List<SimpleTableInfo> syncTables(@PathVariable String databaseCode) {
        return this.metaDataService.listRealTablesWithoutColumn(databaseCode);
    }

    @ApiOperation(value="\u67e5\u8be2\u8868\u7684SQL\u5411\u5bfc\u5143\u6570\u636e")
    @GetMapping(value={"/sqlWizard/{tableId}/{aliasName}"})
    @WrapUpResponseBody
    public JSONObject sqlWizardMateData(@PathVariable(value="tableId") String tableId, @PathVariable(value="aliasName") String aliasName, HttpServletRequest request) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoWithRelations(tableId);
        SourceInfo sourceInfo = this.metaDataService.getDatabaseInfo(tableInfo.getDatabaseCode());
        JSONObject json = new JSONObject();
        json.put((Object)"databaseType", (Object)sourceInfo.getDBType().name());
        JSONArray tableList = new JSONArray();
        JSONObject tableJson = new JSONObject();
        tableJson.put((Object)"table", (Object)tableInfo.getTableName());
        tableJson.put((Object)"tableAlias", (Object)aliasName);
        tableJson.put((Object)"title", (Object)tableInfo.getTableLabelName());
        tableJson.put((Object)"tableId", (Object)tableInfo.getTableId());
        tableList.add((Object)tableJson);
        List relations = tableInfo.getMdRelations();
        if (relations != null) {
            int ind = 0;
            for (MetaRelation relation : relations) {
                tableJson = new JSONObject();
                MetaTable childTableInfo = this.metaDataCache.getTableInfo(relation.getChildTableId());
                tableJson.put((Object)"table", (Object)childTableInfo.getTableName());
                tableJson.put((Object)"tableAlias", (Object)(aliasName + "_" + ind));
                tableJson.put((Object)"title", (Object)childTableInfo.getTableLabelName());
                tableJson.put((Object)"tableId", (Object)relation.getChildTableId());
                JSONArray joinColumns = new JSONArray();
                List relDetails = relation.getRelationDetails();
                if (relDetails != null) {
                    for (MetaRelDetail relDetail : relDetails) {
                        JSONObject relJson = new JSONObject();
                        relJson.put((Object)"leftColumn", (Object)relDetail.getParentColumnCode());
                        relJson.put((Object)"rightColumn", (Object)relDetail.getChildColumnCode());
                        joinColumns.add((Object)relJson);
                    }
                }
                tableJson.put((Object)"joinColumns", (Object)joinColumns);
                tableList.add((Object)tableJson);
                ++ind;
            }
        }
        json.put((Object)"tableList", (Object)tableList);
        JSONArray tableFields = new JSONArray();
        for (MetaColumn column : tableInfo.getMdColumns()) {
            JSONObject colJson = new JSONObject();
            colJson.put((Object)"column", (Object)column.getColumnName());
            colJson.put((Object)"tableAlias", (Object)aliasName);
            colJson.put((Object)"title", (Object)column.getFieldLabelName());
            tableFields.add((Object)colJson);
        }
        json.put((Object)"tableFields", (Object)tableFields);
        return json;
    }

    @ApiOperation(value="\u6309TableStore\u683c\u5f0f\u5bfc\u51fa\u6570\u636e\u5e93\u8868\u7ed3\u6784\u4fe1\u606f", notes="\u6309TableStore\u683c\u5f0f\u5bfc\u51fa\u6570\u636e\u5e93\u8868\u7ed3\u6784\u4fe1\u606f")
    @ApiImplicitParam(name="moduleId", type="path", value="\u6a21\u5757ID")
    @GetMapping(value={"/export/{databaseCode}"})
    public void exportDatabaseCode(@PathVariable String databaseCode, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SourceInfo sourceInfo = this.metaDataService.getDatabaseInfo(databaseCode);
        JSONObject project = new JSONObject();
        JSONObject projectInfo = new JSONObject();
        projectInfo.put((Object)"projectId", (Object)databaseCode);
        projectInfo.put((Object)"projectName", (Object)sourceInfo.getDatabaseName());
        projectInfo.put((Object)"projectDesc", (Object)sourceInfo.getDatabaseDesc());
        project.put((Object)"projectInfo", (Object)projectInfo);
        List<MetaTable> tables = this.metaDataService.listAllMetaTablesWithDetail(databaseCode);
        project.put((Object)"modules", (Object)new JSONArray());
        if (tables != null && tables.size() > 0) {
            JSONArray jaTables = new JSONArray();
            for (MetaTable table : tables) {
                JSONObject tableJson = new JSONObject();
                JSONObject tableInfo = new JSONObject();
                tableInfo.put((Object)"tableId", (Object)table.getTableId());
                tableInfo.put((Object)"tableType", (Object)table.getTableType());
                tableInfo.put((Object)"tableName", (Object)table.getTableName());
                tableInfo.put((Object)"tableLabelName", (Object)table.getTableLabelName());
                tableInfo.put((Object)"tableComment", (Object)table.getTableComment());
                tableJson.put((Object)"tableInfo", (Object)tableInfo);
                tableJson.put((Object)"columns", (Object)table.getColumns());
                jaTables.add((Object)tableJson);
            }
            project.put((Object)"tables", (Object)jaTables);
        }
        String fileName = sourceInfo.getDatabaseName() + ".json";
        ByteArrayInputStream bis = new ByteArrayInputStream(project.toJSONString(new JSONWriter.Feature[0]).getBytes(StandardCharsets.UTF_8));
        UploadDownloadUtils.downloadFile((InputStream)bis, (String)fileName, (HttpServletRequest)request, (HttpServletResponse)response);
    }
}

