/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.utils;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.product.metadata.po.MetaRelDetail;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.PendingMetaColumn;
import com.centit.product.metadata.po.PendingMetaTable;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import java.util.ArrayList;
import java.util.List;

public abstract class TableStoreJsonUtils {
    public static List<PendingMetaTable> fetchTables(JSONObject json) {
        ArrayList<PendingMetaTable> tableList = new ArrayList<PendingMetaTable>();
        JSONArray tables = json.getJSONArray("tables");
        if (tables != null && tables.size() > 0) {
            for (Object obj : tables) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject tableJson = (JSONObject)obj;
                JSONObject tableInfo = tableJson.getJSONObject("tableInfo");
                PendingMetaTable table1 = new PendingMetaTable();
                if (tableInfo != null) {
                    table1.setTableId(tableInfo.getString("tableId"));
                    table1.setTableType(tableInfo.getString("tableType"));
                    table1.setTableName(tableInfo.getString("tableName"));
                    table1.setTableLabelName(tableInfo.getString("tableLabelName"));
                    table1.setTableComment(tableInfo.getString("tableComment"));
                }
                table1.setViewSql(tableJson.getString("viewSql"));
                JSONArray columnsJson = tableJson.getJSONArray("columns");
                long nColNo = 0L;
                if (columnsJson != null && columnsJson.size() > 0) {
                    ArrayList<PendingMetaColumn> mdColumns = new ArrayList<PendingMetaColumn>();
                    for (Object col : columnsJson) {
                        if (!(col instanceof JSONObject)) continue;
                        JSONObject colJson = (JSONObject)col;
                        PendingMetaColumn column = new PendingMetaColumn();
                        column.setColumnName(colJson.getString("columnName"));
                        column.setFieldLabelName(colJson.getString("fieldLabelName"));
                        column.setFieldType(colJson.getString("fieldType"));
                        column.setMaxLength(NumberBaseOpt.castObjectToInteger((Object)colJson.get("maxLength")));
                        column.setScale(NumberBaseOpt.castObjectToInteger((Object)colJson.get("scale")));
                        column.setMandatory(BooleanBaseOpt.castObjectToBoolean((Object)colJson.get("mandatory"), (Boolean)false));
                        column.setPrimaryKey(BooleanBaseOpt.castObjectToBoolean((Object)colJson.get("primaryKey"), (Boolean)false));
                        column.setColumnComment(colJson.getString("columnComment"));
                        column.setColumnOrder(Long.valueOf(++nColNo));
                        mdColumns.add(column);
                    }
                    table1.setMdColumns(mdColumns);
                }
                tableList.add(table1);
            }
        }
        return tableList;
    }

    public static List<MetaRelation> fetchRelations(JSONObject json) {
        ArrayList<MetaRelation> relationList = new ArrayList<MetaRelation>();
        JSONArray modules = json.getJSONArray("modules");
        if (modules != null && modules.size() > 0) {
            for (Object obj : modules) {
                JSONObject moduleJson;
                JSONArray relations;
                if (!(obj instanceof JSONObject) || (relations = (moduleJson = (JSONObject)obj).getJSONArray("relations")) == null || relations.size() <= 0) continue;
                for (Object relObj : relations) {
                    JSONObject relationJson;
                    JSONObject relationInfo;
                    if (!(relObj instanceof JSONObject) || (relationInfo = (relationJson = (JSONObject)relObj).getJSONObject("info")) == null) continue;
                    MetaRelation relation = new MetaRelation();
                    relation.setRelationName(relationInfo.getString("relationsName"));
                    relation.setParentTableId(relationInfo.getString("parentTable"));
                    relation.setChildTableId(relationInfo.getString("chileTable"));
                    relation.setRelationComment(relationInfo.getString("relationsDesc"));
                    JSONArray refCols = json.getJSONArray("referenceColumns");
                    if (refCols != null && refCols.size() > 0) {
                        ArrayList<MetaRelDetail> relationDetails = new ArrayList<MetaRelDetail>();
                        for (Object colObj : refCols) {
                            if (!(colObj instanceof JSONObject)) continue;
                            JSONObject columnJson = (JSONObject)colObj;
                            MetaRelDetail detail = new MetaRelDetail();
                            detail.setParentColumnCode(columnJson.getString("parentColumn"));
                            detail.setChildColumnCode(columnJson.getString("childColumn"));
                            relationDetails.add(detail);
                        }
                        relation.setRelationDetails(relationDetails);
                    }
                    relationList.add(relation);
                }
            }
        }
        return relationList;
    }
}

