/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.centit.product.metadata.api.ISourceInfo;
import com.centit.product.metadata.service.DatabaseRunTime;
import com.centit.product.metadata.service.SourceInfoMetadata;
import com.centit.product.metadata.transaction.AbstractSourceConnectThreadHolder;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.DatabaseAccess;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatabaseRunTimeImpl
implements DatabaseRunTime {
    @Autowired
    private SourceInfoMetadata sourceInfoMetadata;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONArray query(String databaseId, String sql, Object[] params) {
        try (Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)this.sourceInfoMetadata.fetchSourceInfo(databaseId));){
            JSONArray jSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)sql, (Object[])params);
            return jSONArray;
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(620, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JSONArray query(String databaseId, String sql) {
        try (Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)this.sourceInfoMetadata.fetchSourceInfo(databaseId));){
            JSONArray jSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)sql);
            return jSONArray;
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(620, e.getMessage());
        }
    }

    @Override
    public int execute(String databaseId, String sql, Object[] params) {
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)this.sourceInfoMetadata.fetchSourceInfo(databaseId));
            return DatabaseAccess.doExecuteSql((Connection)conn, (String)sql, (Object[])params);
        }
        catch (SQLException e) {
            throw new ObjectException(620, e.getMessage());
        }
    }

    @Override
    public int execute(String databaseId, String sql) {
        try {
            Connection conn = AbstractSourceConnectThreadHolder.fetchConnect((ISourceInfo)this.sourceInfoMetadata.fetchSourceInfo(databaseId));
            return DatabaseAccess.doExecuteSql((Connection)conn, (String)sql) ? 1 : 0;
        }
        catch (SQLException e) {
            throw new ObjectException(620, e.getMessage());
        }
    }
}

