/*
 * Decompiled with CFR 0.152.
 */
package com.centit.stat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.product.dataopt.core.DataSet;
import com.centit.product.dataopt.core.SimpleDataSet;
import com.centit.product.dataopt.dataset.CsvDataSet;
import com.centit.stat.dao.ReportModelDao;
import com.centit.stat.po.ReportModel;
import com.centit.stat.service.ReportService;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.ZipCompressor;
import com.centit.support.database.utils.PageDesc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements ReportService {
    private Logger logger = LoggerFactory.getLogger((String)"\u62a5\u8868\u6587\u4e66");
    @Autowired
    private ReportModelDao reportDao;
    @Value(value="${app.home:./}")
    private String appHome;

    @Override
    public void createReportModel(ReportModel model) {
        this.reportDao.saveNewObject(model);
    }

    @Override
    public ReportModel getReportModel(String reportId) {
        return (ReportModel)this.reportDao.getObjectById(reportId);
    }

    @Override
    public List<ReportModel> listReportModel(Map<String, Object> param, PageDesc pageDesc) {
        return this.reportDao.listObjectsByProperties(param, pageDesc);
    }

    @Override
    public void deleteReportModel(String reportId) {
        this.reportDao.deleteObjectById(reportId);
    }

    @Override
    public void updateReportModel(ReportModel reportModel) {
        this.reportDao.updateObject(reportModel);
    }

    @Override
    public InputStream downModel(String applicationId) throws FileNotFoundException {
        this.appHome = this.appHome + File.separator + DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"YYYYMMddHHmmss");
        String sql = "select * from m_application_info where APPLICATION_ID=:applicationId";
        this.createFile(applicationId, sql, "m_application_info", this.appHome);
        sql = "select * from f_database_info where os_id=:applicationId";
        this.createFile(applicationId, sql, "f_database_info", this.appHome);
        sql = "select * from f_md_table where database_code in (select database_code from f_database_info where os_id=:applicationId)";
        this.createFile(applicationId, sql, "f_md_table", this.appHome);
        sql = "select * from f_md_column where table_id in (select table_id from f_md_table where database_code in (select database_code from f_database_info where os_id=:applicationId))";
        this.createFile(applicationId, sql, "f_md_column", this.appHome);
        sql = "select * from f_md_relation where parent_table_id in (select table_id from f_md_table where database_code in (select database_code from f_database_info where os_id=:applicationId))";
        this.createFile(applicationId, sql, "f_md_relation", this.appHome);
        sql = "select * from f_md_rel_detail where relation_id in (select relation_id from f_md_relation where parent_table_id in (select table_id from f_md_table where database_code in (select database_code from f_database_info where os_id=:applicationId)))";
        this.createFile(applicationId, sql, "f_md_rel_detail", this.appHome);
        sql = "select * from m_meta_form_model where APPLICATION_ID=:applicationId";
        this.createFile(applicationId, sql, "m_meta_form_model", this.appHome);
        sql = "select * from f_datacatalog where opt_ID=:applicationId";
        this.createFile(applicationId, sql, "f_datacatalog", this.appHome);
        sql = "select * from f_datadictionary where catalog_code in (select catalog_code from f_datacatalog where opt_ID=:applicationId)";
        this.createFile(applicationId, sql, "f_datadictionary", this.appHome);
        sql = "select * from q_chart_model where APPLICATION_ID=:applicationId";
        this.createFile(applicationId, sql, "q_chart_model", this.appHome);
        sql = "select * from q_chart_resource_column where chart_id in (select chart_id from q_chart_model where APPLICATION_ID=:applicationId)";
        this.createFile(applicationId, sql, "q_chart_resource_column", this.appHome);
        sql = "select * from q_data_packet where APPLICATION_ID=:applicationId";
        this.createFile(applicationId, sql, "q_data_packet", this.appHome);
        sql = "select * from q_data_packet_param where packet_id in (select packet_id from q_data_packet where APPLICATION_ID=:applicationId)";
        this.createFile(applicationId, sql, "q_data_packet_param", this.appHome);
        sql = "select * from q_dataset_define where packet_id in (select packet_id from q_data_packet where APPLICATION_ID=:applicationId)";
        this.createFile(applicationId, sql, "q_dataset_define", this.appHome);
        sql = "select * from q_dataset_columndesc where packet_id in (select packet_id from q_data_packet where APPLICATION_ID=:applicationId)";
        this.createFile(applicationId, sql, "q_dataset_columndesc", this.appHome);
        ZipCompressor.compress((String)(this.appHome + ".zip"), (String)this.appHome);
        new File(this.appHome).delete();
        FileInputStream in = new FileInputStream(this.appHome + ".zip");
        new File(this.appHome + ".zip").delete();
        return in;
    }

    private void createFile(String applicationId, String sql, String fileName, String filePath) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("applicationId", applicationId);
        JSONArray jsonArray = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this.reportDao, (String)sql, map);
        SimpleDataSet simpleDataSet = SimpleDataSet.fromJsonArray((JSONArray)jsonArray);
        CsvDataSet csvDataSet = new CsvDataSet();
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        csvDataSet.setFilePath(filePath + File.separator + fileName + ".csv");
        csvDataSet.save((DataSet)simpleDataSet);
    }
}

