/*
 * Decompiled with CFR 0.152.
 */
package com.centit.stat.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.fileserver.common.FileStore;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.product.dataopt.core.BizModel;
import com.centit.product.datapacket.service.DataPacketService;
import com.centit.stat.po.ReportModel;
import com.centit.stat.service.ReportService;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.Pretreatment;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileType;
import com.centit.support.report.JsonDocxContext;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.images.ByteArrayImageProvider;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u62a5\u8868\u6587\u4e66", tags={"\u62a5\u8868\u6587\u4e66"})
@RestController
@RequestMapping(value={"report"})
public class ReportController {
    @Autowired(required=false)
    private FileStore fileStore;
    @Autowired
    private ReportService reportService;
    @Autowired
    private DataPacketService dataPacketService;

    @ApiOperation(value="\u521b\u5efa\u62a5\u8868\u6587\u4e66\u914d\u7f6e")
    @PostMapping
    public ResponseData createReportModel(ReportModel model) {
        this.reportService.createReportModel(model);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u4fee\u6539\u62a5\u8868\u6587\u4e66\u914d\u7f6e")
    @ApiImplicitParam(name="reportId", value="\u6587\u4e66ID")
    @PutMapping(value={"/{reportId}"})
    @WrapUpResponseBody
    public void updateReport(@PathVariable String reportId, @RequestBody ReportModel reportModel) {
        reportModel.setReportId(reportId);
        this.reportService.updateReportModel(reportModel);
    }

    @ApiOperation(value="\u5220\u9664\u62a5\u8868\u6587\u4e66\u914d\u7f6e")
    @ApiImplicitParam(name="reportId", value="\u6587\u4e66ID")
    @DeleteMapping(value={"/{reportId}"})
    @WrapUpResponseBody
    public void deleteReport(@PathVariable String reportId) {
        this.reportService.deleteReportModel(reportId);
    }

    @ApiOperation(value="\u67e5\u8be2\u62a5\u8868\u6587\u4e66\u914d\u7f6e")
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<ReportModel> listChart(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        List<ReportModel> list = this.reportService.listReportModel(searchColumn, pageDesc);
        return PageQueryResult.createResult(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u62a5\u8868\u6587\u4e66\u6570\u636e")
    @GetMapping(value={"/data/{reportId}"})
    @WrapUpResponseBody
    public JSONObject reportData(@PathVariable String reportId, HttpServletRequest request) {
        Map params = BaseController.collectRequestParameters((HttpServletRequest)request);
        ReportModel reportModel = this.reportService.getReportModel(reportId);
        JSONObject json = this.dataPacketService.fetchDataPacketData(reportModel.getPacketId(), params).toJSONObject(true);
        json.put("queryParams", (Object)params);
        return json;
    }

    private void addImageMeta(FieldsMetadata metadata, JSONObject docData, Object fieldValue, String imageName, String placeholder) {
        metadata.addFieldAsImage(imageName, placeholder);
        if (fieldValue instanceof byte[]) {
            docData.put(placeholder, (Object)new ByteArrayImageProvider((byte[])fieldValue));
        } else if (fieldValue instanceof String) {
            String fileId = StringBaseOpt.castObjectToString((Object)fieldValue);
            try {
                docData.put(placeholder, (Object)new ByteArrayImageProvider(FileIOOpt.readBytesFromFile((File)this.fileStore.getFile(fileId))));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d\u62a5\u8868\u6587\u4e66")
    @GetMapping(value={"/download/{reportId}"})
    public void downLoadReport(@PathVariable String reportId, HttpServletRequest request, HttpServletResponse response) {
        Map params = BaseController.collectRequestParameters((HttpServletRequest)request);
        ReportModel reportModel = this.reportService.getReportModel(reportId);
        BizModel dataModel = this.dataPacketService.fetchDataPacketData(reportModel.getPacketId(), params);
        JSONObject docData = dataModel.toJSONObject(false);
        docData.put("queryParams", (Object)params);
        FieldsMetadata metadata = new FieldsMetadata();
        if (reportModel.getPhotoJs() != null && StringUtils.isNotBlank((CharSequence)reportModel.getPhotoJs())) {
            JSONArray jsonArray = JSONArray.parseArray((String)reportModel.getPhotoJs());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String imageName = jsonObject.getString("imageName");
                String fileFieldPath = jsonObject.getString("fieldName");
                int namePos = imageName.indexOf("[*]");
                int pathPos = fileFieldPath.indexOf("[*]");
                if (namePos > 0 && pathPos > 0) {
                    Object fieldValue;
                    String nameH = imageName.substring(0, namePos);
                    String nameT = imageName.substring(namePos + 3);
                    String pathH = fileFieldPath.substring(0, pathPos);
                    String pathT = fileFieldPath.substring(pathPos + 3);
                    int j = 0;
                    while ((fieldValue = ReflectionOpt.attainExpressionValue((Object)docData, (String)(pathH + "[" + j + "]" + pathT))) != null) {
                        this.addImageMeta(metadata, docData, fieldValue, nameH + "_" + j + "_" + nameT, "image_" + i + "_" + j);
                        ++j;
                    }
                    continue;
                }
                Object fieldValue = ReflectionOpt.attainExpressionValue((Object)docData, (String)fileFieldPath);
                if (fieldValue == null) continue;
                this.addImageMeta(metadata, docData, fieldValue, imageName, "image_" + i);
            }
        }
        try (FileInputStream in = new FileInputStream(this.fileStore.getFile(reportModel.getReportDocFileId()));){
            IXDocReport report = XDocReportRegistry.getRegistry().loadReport((InputStream)in, TemplateEngineKind.Freemarker, false);
            JsonDocxContext context = new JsonDocxContext((Object)docData);
            String fileName = URLEncoder.encode(Pretreatment.mapTemplateString((String)reportModel.getReportNameFormat(), (Object)params), "UTF-8") + ".docx";
            response.reset();
            response.setContentType(FileType.mapExtNameToMimeType((String)"docx"));
            response.setHeader("Content-disposition", "attachment; filename=" + fileName);
            report.setFieldsMetadata(metadata);
            report.process((IContext)context, (OutputStream)response.getOutputStream());
        }
        catch (XDocReportException | IOException e) {
            throw new ObjectException(704, e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    @GetMapping(value={"/downloadModel/{applicationId}"})
    public void downLoadModel(@PathVariable String applicationId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        InputStream in = this.reportService.downModel(applicationId);
        String fileName = URLEncoder.encode(applicationId, "UTF-8") + ".zip";
        response.setContentType(FileType.mapExtNameToMimeType((String)"zip"));
        response.setHeader("Content-disposition", "attachment; filename=" + fileName);
        IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
    }
}

