/*
 * Decompiled with CFR 0.152.
 */
package com.centit.pagedesign.po;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;

@Entity
@ApiModel
@Table(name="M_PAGE_MODEL")
public class PageModel
implements Serializable {
    private static final long serialVersionUID = 1176407979669503919L;
    @Id
    @Column(name="PAGE_CODE")
    @ApiModelProperty(value="\u9875\u9762\u4ee3\u7801", hidden=true)
    @ValueGenerator(strategy=GeneratorType.UUID)
    private String pageCode;
    @Column(name="PAGE_NAME")
    @ApiModelProperty(value="\u9875\u9762\u540d\u79f0", required=true)
    @NotBlank
    private String pageName;
    @ApiModelProperty(value="\u9875\u9762\u63cf\u8ff0")
    @Column(name="PAGE_COMMENT")
    private String pageComment;
    @Column(name="PAGE_TYPE")
    @ApiModelProperty(value="\u9875\u9762\u7c7b\u522b,R \u53ea\u8bfb\uff08\u89c6\u56fe\u3001\u67e5\u8be2\uff09\uff0cA  \u65b0\u589e\uff08\u53ea\u80fd\u65b0\u589e\u4e00\u6761\uff09\uff0cW \u4fee\u6539 \uff0cL \u7f16\u8f91\u5217\u8868\uff08\u589e\u5220\u6539\uff09")
    @NotBlank
    private String pageType;
    @JSONField(serialize=false)
    @Column(name="PAGE_DESIGN_JSON")
    @ApiModelProperty(value="\u9875\u9762\u6a21\u677f", required=true)
    @NotBlank
    private String pageDesignJson;
    @Column(name="RECORDER")
    @ApiModelProperty(value="\u66f4\u6539\u4eba\u5458", hidden=true)
    private String recorder;
    @Column(name="LAST_MODIFY_DATE")
    @ApiModelProperty(value="\u66f4\u6539\u65f6\u95f4", hidden=true)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW_UPDATE, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date lastModifyDate;
    @ApiModelProperty(value="\u4e1a\u52a1\u6a21\u5757\u4ee3\u7801")
    @Column(name="APPLICATION_ID")
    private String applicationId;

    public JSONObject getPageDesign() {
        if (StringUtils.isBlank((CharSequence)this.pageDesignJson)) {
            return null;
        }
        try {
            return JSONObject.parseObject((String)this.pageDesignJson);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPageCode() {
        return this.pageCode;
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getPageComment() {
        return this.pageComment;
    }

    public String getPageType() {
        return this.pageType;
    }

    public String getPageDesignJson() {
        return this.pageDesignJson;
    }

    public String getRecorder() {
        return this.recorder;
    }

    public Date getLastModifyDate() {
        return this.lastModifyDate;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public void setPageComment(String pageComment) {
        this.pageComment = pageComment;
    }

    public void setPageType(String pageType) {
        this.pageType = pageType;
    }

    public void setPageDesignJson(String pageDesignJson) {
        this.pageDesignJson = pageDesignJson;
    }

    public void setRecorder(String recorder) {
        this.recorder = recorder;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.lastModifyDate = lastModifyDate;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageModel)) {
            return false;
        }
        PageModel other = (PageModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pageCode = this.getPageCode();
        String other$pageCode = other.getPageCode();
        if (this$pageCode == null ? other$pageCode != null : !this$pageCode.equals(other$pageCode)) {
            return false;
        }
        String this$pageName = this.getPageName();
        String other$pageName = other.getPageName();
        if (this$pageName == null ? other$pageName != null : !this$pageName.equals(other$pageName)) {
            return false;
        }
        String this$pageComment = this.getPageComment();
        String other$pageComment = other.getPageComment();
        if (this$pageComment == null ? other$pageComment != null : !this$pageComment.equals(other$pageComment)) {
            return false;
        }
        String this$pageType = this.getPageType();
        String other$pageType = other.getPageType();
        if (this$pageType == null ? other$pageType != null : !this$pageType.equals(other$pageType)) {
            return false;
        }
        String this$pageDesignJson = this.getPageDesignJson();
        String other$pageDesignJson = other.getPageDesignJson();
        if (this$pageDesignJson == null ? other$pageDesignJson != null : !this$pageDesignJson.equals(other$pageDesignJson)) {
            return false;
        }
        String this$recorder = this.getRecorder();
        String other$recorder = other.getRecorder();
        if (this$recorder == null ? other$recorder != null : !this$recorder.equals(other$recorder)) {
            return false;
        }
        Date this$lastModifyDate = this.getLastModifyDate();
        Date other$lastModifyDate = other.getLastModifyDate();
        if (this$lastModifyDate == null ? other$lastModifyDate != null : !((Object)this$lastModifyDate).equals(other$lastModifyDate)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        return !(this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pageCode = this.getPageCode();
        result = result * 59 + ($pageCode == null ? 43 : $pageCode.hashCode());
        String $pageName = this.getPageName();
        result = result * 59 + ($pageName == null ? 43 : $pageName.hashCode());
        String $pageComment = this.getPageComment();
        result = result * 59 + ($pageComment == null ? 43 : $pageComment.hashCode());
        String $pageType = this.getPageType();
        result = result * 59 + ($pageType == null ? 43 : $pageType.hashCode());
        String $pageDesignJson = this.getPageDesignJson();
        result = result * 59 + ($pageDesignJson == null ? 43 : $pageDesignJson.hashCode());
        String $recorder = this.getRecorder();
        result = result * 59 + ($recorder == null ? 43 : $recorder.hashCode());
        Date $lastModifyDate = this.getLastModifyDate();
        result = result * 59 + ($lastModifyDate == null ? 43 : ((Object)$lastModifyDate).hashCode());
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        return result;
    }

    public String toString() {
        return "PageModel(pageCode=" + this.getPageCode() + ", pageName=" + this.getPageName() + ", pageComment=" + this.getPageComment() + ", pageType=" + this.getPageType() + ", pageDesignJson=" + this.getPageDesignJson() + ", recorder=" + this.getRecorder() + ", lastModifyDate=" + this.getLastModifyDate() + ", applicationId=" + this.getApplicationId() + ")";
    }
}

