/*
 * Decompiled with CFR 0.152.
 */
package com.centit.stat.client;

import com.centit.framework.appclient.AppSession;
import com.centit.stat.client.StatClient;
import com.centit.support.network.HttpExecutor;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;

public class StatClientImpl
implements StatClient {
    private AppSession appSession;
    private String fileServerExportUrl;

    public void setAppSession(AppSession appSession) {
        this.appSession = appSession;
    }

    public void setFileServerExportUrl(String fileServerUrl) {
        this.fileServerExportUrl = fileServerUrl;
    }

    @Override
    public CloseableHttpClient getHttpClient() throws Exception {
        return this.appSession.getHttpClient();
    }

    @Override
    public void releaseHttpClient(CloseableHttpClient httpClient) {
        this.appSession.releaseHttpClient(httpClient);
    }

    @Override
    public String getStatData(CloseableHttpClient httpClient, String modelName, Map<String, Object> params, int pageNo, int pageSize) throws Exception {
        Map<String, Object> paramsWithPage = params;
        if (pageSize > 0) {
            paramsWithPage = new HashMap<String, Object>();
            paramsWithPage.putAll(params);
            paramsWithPage.put("pageSize", pageSize);
            paramsWithPage.put("pageNo", pageNo);
            paramsWithPage.put("totalRows", -1);
        }
        this.appSession.checkAccessToken(httpClient);
        String jsonStr = HttpExecutor.simpleGet((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/service/stat/twodimenform/" + modelName), paramsWithPage);
        return jsonStr;
    }

    @Override
    public String getStatData(CloseableHttpClient httpclient, String modelName, Map<String, Object> params) throws Exception {
        return this.getStatData(httpclient, modelName, params, -1, -1);
    }

    @Override
    public String getStatData(String modelName, Map<String, Object> params, int pageNo, int pageSize) throws Exception {
        CloseableHttpClient httpclient = this.getHttpClient();
        String jsonStr = this.getStatData(httpclient, modelName, params, pageNo, pageSize);
        this.releaseHttpClient(httpclient);
        return jsonStr;
    }

    @Override
    public String getStatData(String modelName, Map<String, Object> params) throws Exception {
        CloseableHttpClient httpclient = this.getHttpClient();
        String jsonStr = this.getStatData(httpclient, modelName, params, -1, -1);
        this.releaseHttpClient(httpclient);
        return jsonStr;
    }
}

