/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.po;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.FieldType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@ApiModel
@Entity
@Table(name="F_MD_COLUMN")
public class MetaColumn
implements TableField,
Serializable {
    private static final long serialVersionUID = 201901071109L;
    @ApiModelProperty(value="\u8868ID", hidden=true)
    @Id
    @Column(name="TABLE_ID")
    @NotBlank
    private String tableId;
    @ApiModelProperty(value="\u5b57\u6bb5\u540d", hidden=true)
    @Id
    @Column(name="COLUMN_NAME")
    @NotBlank
    private String columnName;
    @ApiModelProperty(value="\u5b57\u6bb5\u663e\u793a\u540d\uff08\u53ef\u7f16\u8f91\uff09")
    @Column(name="FIELD_LABEL_NAME")
    @NotBlank
    @Length(max=200)
    private @NotBlank @Length(max=200) String fieldLabelName;
    @ApiModelProperty(value="\u5b57\u6bb5\u63cf\u8ff0\uff08\u53ef\u7f16\u8f91\uff09")
    @Column(name="COLUMN_COMMENT")
    @Length(max=256)
    private @Length(max=256) String columnComment;
    @OrderBy
    @ApiModelProperty(value="\u663e\u793a\u987a\u5e8f\uff08\u53ef\u7f16\u8f91\uff09")
    @Column(name="COLUMN_ORDER")
    private Long columnOrder;
    @ApiModelProperty(value="\u5b57\u6bb5\u7c7b\u578b", hidden=true)
    @Column(name="COLUMN_TYPE")
    @NotBlank
    @Length(max=32)
    private @NotBlank @Length(max=32) String columnType;
    @ApiModelProperty(value="\u5b57\u6bb5\u7c7b\u578b", hidden=true)
    @Column(name="FIELD_TYPE")
    @NotBlank
    @Length(max=32)
    private @NotBlank @Length(max=32) String fieldType;
    @ApiModelProperty(value="\u5b57\u6bb5\u957f\u5ea6", hidden=true)
    @Column(name="COLUMN_LENGTH")
    private Integer columnLength;
    @ApiModelProperty(value="\u5b57\u6bb5\u7cbe\u5ea6", hidden=true)
    @Column(name="SCALE")
    private Integer scale;
    @ApiModelProperty(value="\u5b57\u6bb5\u7c7b\u522b\uff08\u53ef\u7f16\u8f91\uff09(\u5b57\u6bb5\u7c7b\u522b.H\uff1a\u9690\u85cf\uff1bR\uff1a\u53ea\u8bfb\uff1bC\uff1a\u53ea\u80fd\u521b\u5efa\u4e0d\u80fd\u4fee\u6539\uff1bN\uff1a\u53ef\u8bfb\u5199)")
    @Column(name="ACCESS_TYPE")
    @NotBlank
    @Pattern(regexp="[HRCN]")
    @Length(max=1)
    private @NotBlank @Pattern(regexp="[HRCN]") @Length(max=1) String accessType = "N";
    @ApiModelProperty(value="\u662f\u5426\u5ef6\u8fdf\u52a0\u8f7d")
    @Column(name="LAZY_FETCH")
    private Boolean lazyFetch = false;
    @ApiModelProperty(value="\u662f\u5426\u5fc5\u586b", hidden=true)
    @Column(name="MANDATORY")
    @NotBlank
    private Boolean mandatory = false;
    @ApiModelProperty(value="\u662f\u5426\u4e3b\u952e", hidden=true)
    @Column(name="PRIMARY_KEY")
    private Boolean primaryKey = false;
    @ApiModelProperty(value="\u5f15\u7528\u7c7b\u578b 0\uff1a\u6ca1\u6709\uff1a1\uff1a \u6570\u636e\u5b57\u5178 2\uff1aJSON\u8868\u8fbe\u5f0f 3\uff1asql\u8bed\u53e5  4\uff1a\u590d\u5408\u6570\u636e\u5b57\u5178")
    @Column(name="REFERENCE_TYPE")
    @Length(max=2)
    private @Length(max=2) String referenceType;
    @ApiModelProperty(value="\u5f15\u7528\u6570\u636e \u6839\u636eparamReferenceType\u7c7b\u578b\uff081,2,3\uff09\u586b\u5199\u5bf9\u5e94\u503c")
    @Column(name="REFERENCE_DATA")
    @Length(max=1000)
    private @Length(max=1000) String referenceData;
    @ApiModelProperty(value="\u7ea6\u675f\u8868\u8fbe\u5f0f regex\u8868\u8fbe\u5f0f")
    @Column(name="CHECK_RULE_ID")
    @Length(max=64)
    private @Length(max=64) String checkRuleId;
    @ApiModelProperty(value="\u7ea6\u675f\u63d0\u793a \u7ea6\u675f\u4e0d\u901a\u8fc7\u63d0\u793a\u4fe1\u606f")
    @Column(name="CHECK_RULE_PARAMS")
    @Length(max=512)
    private @Length(max=512) JSONObject checkRuleParams;
    @Column(name="AUTO_CREATE_CONDITION")
    private String autoCreateCondition;
    @ApiModelProperty(value="\u81ea\u52a8\u751f\u6210\u89c4\u5219 C \u5e38\u91cf U uuid S sequence F \u51fd\u6570 /*O order*/ A \u81ea\u589e\u957f")
    @Column(name="AUTO_CREATE_RULE")
    @Length(max=1)
    private @Length(max=1) String autoCreateRule;
    @ApiModelProperty(value="\u81ea\u52a8\u751f\u6210\u53c2\u6570")
    @Column(name="AUTO_CREATE_PARAM")
    @Length(max=200)
    private @Length(max=200) String autoCreateParam;
    @ApiModelProperty(value="\u8131\u654f\u5904\u7406\u7c7b\u578b")
    @Column(name="SENSITIVE_TYPE")
    @Length(max=16)
    private @Length(max=16) String sensitiveType;
    @Column(name="WORKFLOW_VARIABLE_TYPE")
    @Pattern(regexp="[0-2]")
    @Length(max=1)
    private @Pattern(regexp="[0-2]") @Length(max=1) String workFlowVariableType;
    @ApiModelProperty(hidden=true)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW_UPDATE, condition=GeneratorCondition.ALWAYS, value="today()")
    @Column(name="LAST_MODIFY_DATE")
    private Date lastModifyDate;
    @ApiModelProperty(value="\u66f4\u6539\u4eba\u5458", hidden=true)
    @Column(name="RECORDER")
    @Length(max=8)
    @DictionaryMap(fieldName={"recorderName"}, value={"userCode"})
    private @Length(max=8) String recorder;
    @Transient
    @ApiModelProperty(hidden=true)
    private DBType databaseType;
    @Transient
    private Boolean isCompare;

    public MetaColumn() {
    }

    public MetaColumn(@NotBlank String tableId, @NotBlank String columnName) {
        this();
        this.tableId = tableId;
        this.columnName = columnName;
    }

    public MetaColumn convertFromTableField(SimpleTableField tableField) {
        this.columnName = tableField.getColumnName();
        this.columnType = tableField.getColumnType();
        this.fieldType = tableField.getFieldType();
        if (StringUtils.isNotBlank((CharSequence)tableField.getFieldLabelName())) {
            this.fieldLabelName = tableField.getFieldLabelName();
        }
        if (StringUtils.isNotBlank((CharSequence)tableField.getColumnComment()) && StringUtils.isBlank((CharSequence)this.columnComment)) {
            this.columnComment = tableField.getColumnComment();
        }
        this.columnLength = tableField.getMaxLength();
        this.scale = tableField.getScale();
        this.mandatory = tableField.isMandatory();
        this.primaryKey = tableField.isPrimaryKey();
        if (null == this.lazyFetch) {
            this.lazyFetch = tableField.isLazyFetch();
        }
        this.accessType = StringUtils.isBlank((CharSequence)this.accessType) ? "N" : this.accessType;
        return this;
    }

    @ApiModelProperty(hidden=true)
    @JSONField(serialize=false)
    public String getDefaultValue() {
        return null;
    }

    @ApiModelProperty(hidden=true)
    public String getPropertyName() {
        return FieldType.mapPropName((String)this.columnName);
    }

    public Integer getColumnLength() {
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.fieldType, (CharSequence[])new CharSequence[]{"string", "float", "double", "money", "integer", "long"})) {
            return this.columnLength == null ? 0 : this.columnLength;
        }
        return 0;
    }

    @ApiModelProperty(hidden=true)
    @JSONField(serialize=false)
    public Integer getMaxLength() {
        return this.getColumnLength();
    }

    public void setColumnLength(Integer columnLength) {
        this.columnLength = columnLength;
    }

    @ApiModelProperty(hidden=true)
    public Integer getScale() {
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.fieldType, (CharSequence[])new CharSequence[]{"float", "double", "money"})) {
            return this.scale == null ? 0 : this.scale;
        }
        return 0;
    }

    public String getColumnType() {
        return FieldType.mapToDatabaseType((String)this.columnType, (DBType)this.databaseType);
    }

    public boolean isMandatory() {
        return this.mandatory != null && this.mandatory != false;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey != null && this.primaryKey != false;
    }

    public boolean isLazyFetch() {
        return this.lazyFetch != null && this.lazyFetch != false;
    }

    public Class<?> getJavaType() {
        return FieldType.mapToJavaType((String)this.fieldType, (int)this.scale);
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFieldLabelName() {
        return this.fieldLabelName;
    }

    public String getColumnComment() {
        return this.columnComment;
    }

    public Long getColumnOrder() {
        return this.columnOrder;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public Boolean getLazyFetch() {
        return this.lazyFetch;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public Boolean getPrimaryKey() {
        return this.primaryKey;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public String getReferenceData() {
        return this.referenceData;
    }

    public String getCheckRuleId() {
        return this.checkRuleId;
    }

    public JSONObject getCheckRuleParams() {
        return this.checkRuleParams;
    }

    public String getAutoCreateCondition() {
        return this.autoCreateCondition;
    }

    public String getAutoCreateRule() {
        return this.autoCreateRule;
    }

    public String getAutoCreateParam() {
        return this.autoCreateParam;
    }

    public String getSensitiveType() {
        return this.sensitiveType;
    }

    public String getWorkFlowVariableType() {
        return this.workFlowVariableType;
    }

    public Date getLastModifyDate() {
        return this.lastModifyDate;
    }

    public String getRecorder() {
        return this.recorder;
    }

    public DBType getDatabaseType() {
        return this.databaseType;
    }

    public Boolean getIsCompare() {
        return this.isCompare;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setFieldLabelName(String fieldLabelName) {
        this.fieldLabelName = fieldLabelName;
    }

    public void setColumnComment(String columnComment) {
        this.columnComment = columnComment;
    }

    public void setColumnOrder(Long columnOrder) {
        this.columnOrder = columnOrder;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public void setLazyFetch(Boolean lazyFetch) {
        this.lazyFetch = lazyFetch;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public void setPrimaryKey(Boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    public void setReferenceData(String referenceData) {
        this.referenceData = referenceData;
    }

    public void setCheckRuleId(String checkRuleId) {
        this.checkRuleId = checkRuleId;
    }

    public void setCheckRuleParams(JSONObject checkRuleParams) {
        this.checkRuleParams = checkRuleParams;
    }

    public void setAutoCreateCondition(String autoCreateCondition) {
        this.autoCreateCondition = autoCreateCondition;
    }

    public void setAutoCreateRule(String autoCreateRule) {
        this.autoCreateRule = autoCreateRule;
    }

    public void setAutoCreateParam(String autoCreateParam) {
        this.autoCreateParam = autoCreateParam;
    }

    public void setSensitiveType(String sensitiveType) {
        this.sensitiveType = sensitiveType;
    }

    public void setWorkFlowVariableType(String workFlowVariableType) {
        this.workFlowVariableType = workFlowVariableType;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.lastModifyDate = lastModifyDate;
    }

    public void setRecorder(String recorder) {
        this.recorder = recorder;
    }

    public void setDatabaseType(DBType databaseType) {
        this.databaseType = databaseType;
    }

    public void setIsCompare(Boolean isCompare) {
        this.isCompare = isCompare;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaColumn)) {
            return false;
        }
        MetaColumn other = (MetaColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$columnOrder = this.getColumnOrder();
        Long other$columnOrder = other.getColumnOrder();
        if (this$columnOrder == null ? other$columnOrder != null : !((Object)this$columnOrder).equals(other$columnOrder)) {
            return false;
        }
        Integer this$columnLength = this.getColumnLength();
        Integer other$columnLength = other.getColumnLength();
        if (this$columnLength == null ? other$columnLength != null : !((Object)this$columnLength).equals(other$columnLength)) {
            return false;
        }
        Integer this$scale = this.getScale();
        Integer other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        Boolean this$lazyFetch = this.getLazyFetch();
        Boolean other$lazyFetch = other.getLazyFetch();
        if (this$lazyFetch == null ? other$lazyFetch != null : !((Object)this$lazyFetch).equals(other$lazyFetch)) {
            return false;
        }
        Boolean this$mandatory = this.getMandatory();
        Boolean other$mandatory = other.getMandatory();
        if (this$mandatory == null ? other$mandatory != null : !((Object)this$mandatory).equals(other$mandatory)) {
            return false;
        }
        Boolean this$primaryKey = this.getPrimaryKey();
        Boolean other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !((Object)this$primaryKey).equals(other$primaryKey)) {
            return false;
        }
        Boolean this$isCompare = this.getIsCompare();
        Boolean other$isCompare = other.getIsCompare();
        if (this$isCompare == null ? other$isCompare != null : !((Object)this$isCompare).equals(other$isCompare)) {
            return false;
        }
        String this$tableId = this.getTableId();
        String other$tableId = other.getTableId();
        if (this$tableId == null ? other$tableId != null : !this$tableId.equals(other$tableId)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$fieldLabelName = this.getFieldLabelName();
        String other$fieldLabelName = other.getFieldLabelName();
        if (this$fieldLabelName == null ? other$fieldLabelName != null : !this$fieldLabelName.equals(other$fieldLabelName)) {
            return false;
        }
        String this$columnComment = this.getColumnComment();
        String other$columnComment = other.getColumnComment();
        if (this$columnComment == null ? other$columnComment != null : !this$columnComment.equals(other$columnComment)) {
            return false;
        }
        String this$columnType = this.getColumnType();
        String other$columnType = other.getColumnType();
        if (this$columnType == null ? other$columnType != null : !this$columnType.equals(other$columnType)) {
            return false;
        }
        String this$fieldType = this.getFieldType();
        String other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
            return false;
        }
        String this$accessType = this.getAccessType();
        String other$accessType = other.getAccessType();
        if (this$accessType == null ? other$accessType != null : !this$accessType.equals(other$accessType)) {
            return false;
        }
        String this$referenceType = this.getReferenceType();
        String other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !this$referenceType.equals(other$referenceType)) {
            return false;
        }
        String this$referenceData = this.getReferenceData();
        String other$referenceData = other.getReferenceData();
        if (this$referenceData == null ? other$referenceData != null : !this$referenceData.equals(other$referenceData)) {
            return false;
        }
        String this$checkRuleId = this.getCheckRuleId();
        String other$checkRuleId = other.getCheckRuleId();
        if (this$checkRuleId == null ? other$checkRuleId != null : !this$checkRuleId.equals(other$checkRuleId)) {
            return false;
        }
        JSONObject this$checkRuleParams = this.getCheckRuleParams();
        JSONObject other$checkRuleParams = other.getCheckRuleParams();
        if (this$checkRuleParams == null ? other$checkRuleParams != null : !this$checkRuleParams.equals(other$checkRuleParams)) {
            return false;
        }
        String this$autoCreateCondition = this.getAutoCreateCondition();
        String other$autoCreateCondition = other.getAutoCreateCondition();
        if (this$autoCreateCondition == null ? other$autoCreateCondition != null : !this$autoCreateCondition.equals(other$autoCreateCondition)) {
            return false;
        }
        String this$autoCreateRule = this.getAutoCreateRule();
        String other$autoCreateRule = other.getAutoCreateRule();
        if (this$autoCreateRule == null ? other$autoCreateRule != null : !this$autoCreateRule.equals(other$autoCreateRule)) {
            return false;
        }
        String this$autoCreateParam = this.getAutoCreateParam();
        String other$autoCreateParam = other.getAutoCreateParam();
        if (this$autoCreateParam == null ? other$autoCreateParam != null : !this$autoCreateParam.equals(other$autoCreateParam)) {
            return false;
        }
        String this$sensitiveType = this.getSensitiveType();
        String other$sensitiveType = other.getSensitiveType();
        if (this$sensitiveType == null ? other$sensitiveType != null : !this$sensitiveType.equals(other$sensitiveType)) {
            return false;
        }
        String this$workFlowVariableType = this.getWorkFlowVariableType();
        String other$workFlowVariableType = other.getWorkFlowVariableType();
        if (this$workFlowVariableType == null ? other$workFlowVariableType != null : !this$workFlowVariableType.equals(other$workFlowVariableType)) {
            return false;
        }
        Date this$lastModifyDate = this.getLastModifyDate();
        Date other$lastModifyDate = other.getLastModifyDate();
        if (this$lastModifyDate == null ? other$lastModifyDate != null : !((Object)this$lastModifyDate).equals(other$lastModifyDate)) {
            return false;
        }
        String this$recorder = this.getRecorder();
        String other$recorder = other.getRecorder();
        if (this$recorder == null ? other$recorder != null : !this$recorder.equals(other$recorder)) {
            return false;
        }
        DBType this$databaseType = this.getDatabaseType();
        DBType other$databaseType = other.getDatabaseType();
        return !(this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaColumn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $columnOrder = this.getColumnOrder();
        result = result * 59 + ($columnOrder == null ? 43 : ((Object)$columnOrder).hashCode());
        Integer $columnLength = this.getColumnLength();
        result = result * 59 + ($columnLength == null ? 43 : ((Object)$columnLength).hashCode());
        Integer $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        Boolean $lazyFetch = this.getLazyFetch();
        result = result * 59 + ($lazyFetch == null ? 43 : ((Object)$lazyFetch).hashCode());
        Boolean $mandatory = this.getMandatory();
        result = result * 59 + ($mandatory == null ? 43 : ((Object)$mandatory).hashCode());
        Boolean $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : ((Object)$primaryKey).hashCode());
        Boolean $isCompare = this.getIsCompare();
        result = result * 59 + ($isCompare == null ? 43 : ((Object)$isCompare).hashCode());
        String $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : $tableId.hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $fieldLabelName = this.getFieldLabelName();
        result = result * 59 + ($fieldLabelName == null ? 43 : $fieldLabelName.hashCode());
        String $columnComment = this.getColumnComment();
        result = result * 59 + ($columnComment == null ? 43 : $columnComment.hashCode());
        String $columnType = this.getColumnType();
        result = result * 59 + ($columnType == null ? 43 : $columnType.hashCode());
        String $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
        String $accessType = this.getAccessType();
        result = result * 59 + ($accessType == null ? 43 : $accessType.hashCode());
        String $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : $referenceType.hashCode());
        String $referenceData = this.getReferenceData();
        result = result * 59 + ($referenceData == null ? 43 : $referenceData.hashCode());
        String $checkRuleId = this.getCheckRuleId();
        result = result * 59 + ($checkRuleId == null ? 43 : $checkRuleId.hashCode());
        JSONObject $checkRuleParams = this.getCheckRuleParams();
        result = result * 59 + ($checkRuleParams == null ? 43 : $checkRuleParams.hashCode());
        String $autoCreateCondition = this.getAutoCreateCondition();
        result = result * 59 + ($autoCreateCondition == null ? 43 : $autoCreateCondition.hashCode());
        String $autoCreateRule = this.getAutoCreateRule();
        result = result * 59 + ($autoCreateRule == null ? 43 : $autoCreateRule.hashCode());
        String $autoCreateParam = this.getAutoCreateParam();
        result = result * 59 + ($autoCreateParam == null ? 43 : $autoCreateParam.hashCode());
        String $sensitiveType = this.getSensitiveType();
        result = result * 59 + ($sensitiveType == null ? 43 : $sensitiveType.hashCode());
        String $workFlowVariableType = this.getWorkFlowVariableType();
        result = result * 59 + ($workFlowVariableType == null ? 43 : $workFlowVariableType.hashCode());
        Date $lastModifyDate = this.getLastModifyDate();
        result = result * 59 + ($lastModifyDate == null ? 43 : ((Object)$lastModifyDate).hashCode());
        String $recorder = this.getRecorder();
        result = result * 59 + ($recorder == null ? 43 : $recorder.hashCode());
        DBType $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
        return result;
    }

    public String toString() {
        return "MetaColumn(tableId=" + this.getTableId() + ", columnName=" + this.getColumnName() + ", fieldLabelName=" + this.getFieldLabelName() + ", columnComment=" + this.getColumnComment() + ", columnOrder=" + this.getColumnOrder() + ", columnType=" + this.getColumnType() + ", fieldType=" + this.getFieldType() + ", columnLength=" + this.getColumnLength() + ", scale=" + this.getScale() + ", accessType=" + this.getAccessType() + ", lazyFetch=" + this.getLazyFetch() + ", mandatory=" + this.getMandatory() + ", primaryKey=" + this.getPrimaryKey() + ", referenceType=" + this.getReferenceType() + ", referenceData=" + this.getReferenceData() + ", checkRuleId=" + this.getCheckRuleId() + ", checkRuleParams=" + this.getCheckRuleParams() + ", autoCreateCondition=" + this.getAutoCreateCondition() + ", autoCreateRule=" + this.getAutoCreateRule() + ", autoCreateParam=" + this.getAutoCreateParam() + ", sensitiveType=" + this.getSensitiveType() + ", workFlowVariableType=" + this.getWorkFlowVariableType() + ", lastModifyDate=" + this.getLastModifyDate() + ", recorder=" + this.getRecorder() + ", databaseType=" + this.getDatabaseType() + ", isCompare=" + this.getIsCompare() + ")";
    }
}

