/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.po;

import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.po.PendingMetaColumn;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.metadata.TableReference;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.database.utils.DBType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@ApiModel
@Entity
@Table(name="F_PENDING_META_TABLE")
public class PendingMetaTable
implements TableInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u8868ID", hidden=true)
    @Id
    @Column(name="TABLE_ID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String tableId;
    @ApiModelProperty(value="\u6570\u636e\u5e93ID")
    @Column(name="DATABASE_CODE")
    @DictionaryMap(value={"databaseInfo"}, fieldName={"databaseName"})
    private String databaseCode;
    @ApiModelProperty(value="\u8868\u4ee3\u7801", required=true)
    @Column(name="TABLE_NAME")
    @NotBlank
    @Length(max=64)
    private @NotBlank @Length(max=64) String tableName;
    @ApiModelProperty(value="\u8868\u4e2d\u6587\u540d", required=true)
    @Column(name="TABLE_LABEL_NAME")
    @NotBlank
    @Length(max=200)
    private @NotBlank @Length(max=200) String tableLabelName;
    @ApiModelProperty(value="\u8868\u7c7b\u578b\uff08T-\u8868\uff1bV-\u89c6\u56fe\uff09", required=true)
    @Column(name="TABLE_TYPE")
    @NotBlank
    @Pattern(regexp="[TV]")
    @Length(max=1)
    @DictionaryMap(fieldName={"tableTypeText"}, value={"TableType"})
    private @NotBlank @Pattern(regexp="[TV]") @Length(max=1) String tableType = "T";
    @ApiModelProperty(value="\u8868\u63cf\u8ff0")
    @Column(name="TABLE_COMMENT")
    @Length(max=256)
    private @Length(max=256) String tableComment;
    @ApiModelProperty(value="\u8868\u72b6\u6001\uff08\u5f85\u53d1\u5e03 W\u3001\u5df2\u53d1\u5e03 S\uff09", required=true)
    @Column(name="TABLE_STATE")
    @Length(max=2)
    private @Length(max=2) String tableState;
    @ApiModelProperty(value="\u4e0e\u6d41\u7a0b\u4e2d\u4e1a\u52a1\u5173\u8054\u5173\u7cfb(0: \u4e0d\u5173\u8054\u5de5\u4f5c\u6d41 1\uff1a\u548c\u6d41\u7a0b\u4e1a\u52a1\u5173\u8054 2\uff1a \u548c\u6d41\u7a0b\u8fc7\u7a0b\u5173\u8054)", required=true)
    @Column(name="WORKFLOW_OPT_TYPE")
    @Length(max=1)
    private @Length(max=1) String workFlowOptType;
    @Column(name="LAST_MODIFY_DATE")
    @ApiModelProperty(value="\u66f4\u6539\u65f6\u95f4", hidden=true)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW_UPDATE, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date lastModifyDate;
    @Column(name="RECORDER")
    @Length(max=64)
    @DictionaryMap(fieldName={"recorderName"}, value={"userCode"})
    private @Length(max=64) String recorder;
    @ApiModelProperty(value="\u89c6\u56fe\u6784\u5efasql")
    @Column(name="VIEW_SQL")
    private String viewSql;
    @ApiModelProperty(value="\u89c6\u56fe\u6784\u5efa\u987a\u5e8f\uff0c\u9488\u5bf9\u5d4c\u5957\u89c6\u56fe")
    @Column(name="VIEW_ORDER")
    private int viewOrder = 0;
    @OneToMany(mappedBy="mdTable", orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="TABLE_ID", referencedColumnName="TABLE_ID")
    private List<PendingMetaColumn> mdColumns;
    @Transient
    private DBType databaseType;

    public void setDatabaseType(DBType databaseType) {
        this.databaseType = databaseType;
        if (this.mdColumns != null) {
            for (PendingMetaColumn col : this.mdColumns) {
                col.setDatabaseType(databaseType);
            }
        }
    }

    public void addMdColumn(PendingMetaColumn mdColumn) {
        if (mdColumn == null) {
            return;
        }
        mdColumn.setTableId(this.tableId);
        if (this.mdColumns == null) {
            this.mdColumns = new ArrayList<PendingMetaColumn>(20);
        }
        this.mdColumns.add(mdColumn);
    }

    public PendingMetaTable copy(PendingMetaTable other) {
        this.setMdColumns(other.getMdColumns());
        this.setTableId(other.getTableId());
        this.setDatabaseCode(other.getDatabaseCode());
        this.tableName = other.getTableName();
        this.tableLabelName = other.getTableLabelName();
        this.tableState = other.getTableState();
        this.tableComment = other.getTableComment();
        this.workFlowOptType = other.getWorkFlowOptType();
        this.lastModifyDate = other.getLastModifyDate();
        this.recorder = other.getRecorder();
        return this;
    }

    public PendingMetaTable copyNotNullProperty(PendingMetaTable other) {
        if (other.getTableId() != null) {
            this.setTableId(other.getTableId());
        }
        if (other.getMdColumns() != null) {
            this.setMdColumns(other.getMdColumns());
        }
        if (other.getDatabaseCode() != null) {
            this.databaseCode = other.getDatabaseCode();
        }
        if (other.getTableName() != null) {
            this.tableName = other.getTableName();
        }
        if (other.getTableLabelName() != null) {
            this.tableLabelName = other.getTableLabelName();
        }
        if (other.getTableState() != null) {
            this.tableState = other.getTableState();
        }
        if (other.getTableComment() != null) {
            this.tableComment = other.getTableComment();
        }
        if (other.getWorkFlowOptType() != null) {
            this.workFlowOptType = other.getWorkFlowOptType();
        }
        if (other.getLastModifyDate() != null) {
            this.lastModifyDate = other.getLastModifyDate();
        }
        if (other.getRecorder() != null) {
            this.recorder = other.getRecorder();
        }
        if (other.getTableType() != null) {
            this.tableType = other.getTableType();
        }
        this.viewOrder = other.getViewOrder();
        if (other.getViewSql() != null) {
            this.viewSql = other.getViewSql();
        }
        return this;
    }

    public PendingMetaTable clearProperties() {
        this.mdColumns = null;
        this.databaseCode = null;
        this.tableName = null;
        this.tableLabelName = null;
        this.tableState = null;
        this.tableComment = null;
        this.workFlowOptType = null;
        this.lastModifyDate = null;
        this.recorder = null;
        return this;
    }

    public String getPkName() {
        return "PK_" + this.tableName;
    }

    public String getSchema() {
        return null;
    }

    public String getOrderBy() {
        return null;
    }

    public PendingMetaColumn findFieldByName(String name) {
        if (this.mdColumns == null) {
            return null;
        }
        for (PendingMetaColumn c : this.mdColumns) {
            if (!c.getPropertyName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public PendingMetaColumn findFieldByColumn(String name) {
        if (this.mdColumns == null) {
            return null;
        }
        for (PendingMetaColumn c : this.mdColumns) {
            if (!c.getColumnName().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    @JSONField(serialize=false)
    public List<PendingMetaColumn> getColumns() {
        return this.mdColumns;
    }

    public List<? extends TableReference> getReferences() {
        return null;
    }

    public MetaTable mapToMetaTable() {
        MetaTable mt = new MetaTable();
        mt.setTableId(this.getTableId());
        mt.setDatabaseCode(this.getDatabaseCode());
        mt.setTableName(this.getTableName());
        mt.setTableType(this.getTableType());
        mt.setAccessType("N");
        mt.setTableLabelName(this.getTableLabelName());
        mt.setTableComment(this.getTableComment());
        mt.setRecordDate(this.getLastModifyDate());
        mt.setWorkFlowOptType(this.getWorkFlowOptType());
        mt.setRecorder(this.getRecorder());
        mt.setDatabaseType(this.getDatabaseType());
        ArrayList<MetaColumn> columns = new ArrayList<MetaColumn>();
        if (this.getMdColumns() != null && this.getMdColumns().size() > 0) {
            for (PendingMetaColumn pc : this.getMdColumns()) {
                columns.add(pc.mapToMetaColumn());
            }
        }
        mt.setMdColumns(columns);
        return mt;
    }

    public PendingMetaTable convertFromPdmTable(SimpleTableInfo tableInfo) {
        this.tableName = tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getTableLabelName())) {
            this.tableLabelName = tableInfo.getTableLabelName();
        }
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getTableComment())) {
            this.tableComment = tableInfo.getTableComment();
        }
        this.tableState = StringUtils.isNotBlank((CharSequence)this.tableState) ? this.tableState : "W";
        this.workFlowOptType = StringUtils.isNotBlank((CharSequence)this.workFlowOptType) ? this.workFlowOptType : "0";
        return this;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getDatabaseCode() {
        return this.databaseCode;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableLabelName() {
        return this.tableLabelName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public String getTableState() {
        return this.tableState;
    }

    public String getWorkFlowOptType() {
        return this.workFlowOptType;
    }

    public Date getLastModifyDate() {
        return this.lastModifyDate;
    }

    public String getRecorder() {
        return this.recorder;
    }

    public String getViewSql() {
        return this.viewSql;
    }

    public int getViewOrder() {
        return this.viewOrder;
    }

    public List<PendingMetaColumn> getMdColumns() {
        return this.mdColumns;
    }

    public DBType getDatabaseType() {
        return this.databaseType;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public void setDatabaseCode(String databaseCode) {
        this.databaseCode = databaseCode;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTableLabelName(String tableLabelName) {
        this.tableLabelName = tableLabelName;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public void setTableState(String tableState) {
        this.tableState = tableState;
    }

    public void setWorkFlowOptType(String workFlowOptType) {
        this.workFlowOptType = workFlowOptType;
    }

    public void setLastModifyDate(Date lastModifyDate) {
        this.lastModifyDate = lastModifyDate;
    }

    public void setRecorder(String recorder) {
        this.recorder = recorder;
    }

    public void setViewSql(String viewSql) {
        this.viewSql = viewSql;
    }

    public void setViewOrder(int viewOrder) {
        this.viewOrder = viewOrder;
    }

    public void setMdColumns(List<PendingMetaColumn> mdColumns) {
        this.mdColumns = mdColumns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PendingMetaTable)) {
            return false;
        }
        PendingMetaTable other = (PendingMetaTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getViewOrder() != other.getViewOrder()) {
            return false;
        }
        String this$tableId = this.getTableId();
        String other$tableId = other.getTableId();
        if (this$tableId == null ? other$tableId != null : !this$tableId.equals(other$tableId)) {
            return false;
        }
        String this$databaseCode = this.getDatabaseCode();
        String other$databaseCode = other.getDatabaseCode();
        if (this$databaseCode == null ? other$databaseCode != null : !this$databaseCode.equals(other$databaseCode)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableLabelName = this.getTableLabelName();
        String other$tableLabelName = other.getTableLabelName();
        if (this$tableLabelName == null ? other$tableLabelName != null : !this$tableLabelName.equals(other$tableLabelName)) {
            return false;
        }
        String this$tableType = this.getTableType();
        String other$tableType = other.getTableType();
        if (this$tableType == null ? other$tableType != null : !this$tableType.equals(other$tableType)) {
            return false;
        }
        String this$tableComment = this.getTableComment();
        String other$tableComment = other.getTableComment();
        if (this$tableComment == null ? other$tableComment != null : !this$tableComment.equals(other$tableComment)) {
            return false;
        }
        String this$tableState = this.getTableState();
        String other$tableState = other.getTableState();
        if (this$tableState == null ? other$tableState != null : !this$tableState.equals(other$tableState)) {
            return false;
        }
        String this$workFlowOptType = this.getWorkFlowOptType();
        String other$workFlowOptType = other.getWorkFlowOptType();
        if (this$workFlowOptType == null ? other$workFlowOptType != null : !this$workFlowOptType.equals(other$workFlowOptType)) {
            return false;
        }
        Date this$lastModifyDate = this.getLastModifyDate();
        Date other$lastModifyDate = other.getLastModifyDate();
        if (this$lastModifyDate == null ? other$lastModifyDate != null : !((Object)this$lastModifyDate).equals(other$lastModifyDate)) {
            return false;
        }
        String this$recorder = this.getRecorder();
        String other$recorder = other.getRecorder();
        if (this$recorder == null ? other$recorder != null : !this$recorder.equals(other$recorder)) {
            return false;
        }
        String this$viewSql = this.getViewSql();
        String other$viewSql = other.getViewSql();
        if (this$viewSql == null ? other$viewSql != null : !this$viewSql.equals(other$viewSql)) {
            return false;
        }
        List<PendingMetaColumn> this$mdColumns = this.getMdColumns();
        List<PendingMetaColumn> other$mdColumns = other.getMdColumns();
        if (this$mdColumns == null ? other$mdColumns != null : !((Object)this$mdColumns).equals(other$mdColumns)) {
            return false;
        }
        DBType this$databaseType = this.getDatabaseType();
        DBType other$databaseType = other.getDatabaseType();
        return !(this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PendingMetaTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getViewOrder();
        String $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : $tableId.hashCode());
        String $databaseCode = this.getDatabaseCode();
        result = result * 59 + ($databaseCode == null ? 43 : $databaseCode.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableLabelName = this.getTableLabelName();
        result = result * 59 + ($tableLabelName == null ? 43 : $tableLabelName.hashCode());
        String $tableType = this.getTableType();
        result = result * 59 + ($tableType == null ? 43 : $tableType.hashCode());
        String $tableComment = this.getTableComment();
        result = result * 59 + ($tableComment == null ? 43 : $tableComment.hashCode());
        String $tableState = this.getTableState();
        result = result * 59 + ($tableState == null ? 43 : $tableState.hashCode());
        String $workFlowOptType = this.getWorkFlowOptType();
        result = result * 59 + ($workFlowOptType == null ? 43 : $workFlowOptType.hashCode());
        Date $lastModifyDate = this.getLastModifyDate();
        result = result * 59 + ($lastModifyDate == null ? 43 : ((Object)$lastModifyDate).hashCode());
        String $recorder = this.getRecorder();
        result = result * 59 + ($recorder == null ? 43 : $recorder.hashCode());
        String $viewSql = this.getViewSql();
        result = result * 59 + ($viewSql == null ? 43 : $viewSql.hashCode());
        List<PendingMetaColumn> $mdColumns = this.getMdColumns();
        result = result * 59 + ($mdColumns == null ? 43 : ((Object)$mdColumns).hashCode());
        DBType $databaseType = this.getDatabaseType();
        result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
        return result;
    }

    public String toString() {
        return "PendingMetaTable(tableId=" + this.getTableId() + ", databaseCode=" + this.getDatabaseCode() + ", tableName=" + this.getTableName() + ", tableLabelName=" + this.getTableLabelName() + ", tableType=" + this.getTableType() + ", tableComment=" + this.getTableComment() + ", tableState=" + this.getTableState() + ", workFlowOptType=" + this.getWorkFlowOptType() + ", lastModifyDate=" + this.getLastModifyDate() + ", recorder=" + this.getRecorder() + ", viewSql=" + this.getViewSql() + ", viewOrder=" + this.getViewOrder() + ", mdColumns=" + this.getMdColumns() + ", databaseType=" + this.getDatabaseType() + ")";
    }
}

