
DROP TABLE F_WEB_IM_GROUP_MEMBER;

CREATE TABLE F_WEB_IM_GROUP
(
    GROUP_ID             VARCHAR2(32) NOT NULL,
    OS_ID                VARCHAR2(20) NOT NULL,
    GROUP_TYPE           CHAR NOT NULL,
    GROUP_NAME           VARCHAR2(100) NOT NULL ,
    CREATOR              VARCHAR2(32) NOT NULL,
    CREATE_TIME          DATE ,
    GROUP_NOTICE         VARCHAR2(1000),
    PRIMARY KEY (GROUP_ID)
);

CREATE TABLE F_WEB_IM_GROUP_MEMBER
(
    OS_ID                VARCHAR2(20) NOT NULL,
    USER_CODE            VARCHAR2(32) NOT NULL,
    GROUP_ID             VARCHAR2(32) NOT NULL,
    GROUP_MEMO           VARCHAR2(1000) ,
    GROUP_ALIAS          VARCHAR2(100),
    JOIN_TIME            DATE NOT NULL,
    LAST_PUSH_TIME       DATE NOT NULL,
    PRIMARY KEY (USER_CODE, UNIT_CODE)
);


CREATE or REPLACE VIEW F_V_UNREAD_CHAT_MSG AS
select OS_ID, RECEIVER, SENDER, COUNT(*) as UNREAD_SUM, MAX(SEND_TIME) as LAST_MSG_SEND_TIME
from F_WEB_IM_MESSAGE
where MSG_TYPE = 'C' and MSG_STATE = 'U'
group by OS_ID,RECEIVER,SENDER;


CREATE or REPLACE  VIEW F_V_UNREAD_GROUP_MSG AS
select a.OS_ID, b.USER_CODE, b.UNIT_CODE, COUNT(*) as UNREAD_SUM, MAX(SEND_TIME) as LAST_MSG_SEND_TIME
from F_WEB_IM_MESSAGE a left join F_WEB_IM_GROUP_MEMBER b on
    (a.OS_ID=b.OS_ID and a.RECEIVER = b.UNIT_CODE)
where a.MSG_TYPE = 'G' and ( a.send_time > b.LAST_PUSH_TIME or b.LAST_PUSH_TIME is null)
group by a.OS_ID, b.USER_CODE, b.UNIT_CODE;



CREATE or REPLACE  VIEW F_V_LAST_UNREAD_CHAT_MSG AS
select a.OS_ID, a.RECEIVER, a.SENDER, a.UNREAD_SUM , b.SEND_TIME, b.SENDER_NAME,
       b.MSG_ID, b.MSG_TYPE, b.MSG_STATE, b.CONTENT, b.CONTENT_TYPE
from F_V_UNREAD_CHAT_MSG a join F_WEB_IM_MESSAGE b
   on (a.OS_ID = b.OS_ID and a.SENDER = b.SENDER
       and a.RECEIVER = b.RECEIVER and a.LAST_MSG_SEND_TIME = b.SEND_TIME);


CREATE or REPLACE VIEW F_V_LAST_UNREAD_GROUP_MSG AS
select a.OS_ID, a.UNIT_CODE, b.SENDER, b.RECEIVER, a.UNREAD_SUM , b.SEND_TIME, b.SENDER_NAME,
       b.MSG_ID, b.MSG_TYPE, b.MSG_STATE, b.CONTENT, b.CONTENT_TYPE
from F_V_UNREAD_GROUP_MSG a join F_WEB_IM_MESSAGE b
   on (a.OS_ID = b.OS_ID and a.UNIT_CODE = b.RECEIVER and a.LAST_MSG_SEND_TIME = b.SEND_TIME);

