/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.web.config;

import com.centit.fileserver.utils.FileStore;
import com.centit.fileserver.utils.OsFileStore;
import com.centit.framework.common.SysParametersUtils;
import com.centit.framework.components.impl.NotificationCenterImpl;
import com.centit.framework.components.impl.TextOperationLogWriterImpl;
import com.centit.framework.config.SpringSecurityDaoConfig;
import com.centit.framework.ip.app.config.IPAppSystemBeanConfig;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.framework.jdbc.config.JdbcConfig;
import com.centit.framework.model.adapter.MessageSender;
import com.centit.framework.model.adapter.NotificationCenter;
import com.centit.framework.model.adapter.OperationLogWriter;
import com.centit.im.robot.es.service.impl.IntelligentRobotEsImpl;
import com.centit.im.service.IntelligentRobot;
import com.centit.im.service.IntelligentRobotFactory;
import com.centit.im.service.impl.IntelligentRobotFactoryRpcImpl;
import com.centit.im.service.impl.IntelligentRobotFactorySingleImpl;
import com.centit.im.web.config.InstantiationServiceBeanPostProcessor;
import com.centit.im.web.plugins.JsfgwSmsMessageSender;
import com.centit.support.algorithm.NumberBaseOpt;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;

@Configuration
@ComponentScan(basePackages={"com.centit"}, excludeFilters={@ComponentScan.Filter(value={Controller.class})})
@Import(value={IPAppSystemBeanConfig.class, JdbcConfig.class, SpringSecurityDaoConfig.class})
public class ServiceBeanConfig {
    @Autowired
    private Environment env;
    @Autowired
    IntegrationEnvironment integrationEnvironment;

    @Bean
    public IntelligentRobotFactory intelligentRobotFactory() {
        if ("es".equals(this.env.getProperty("webim.robot.type"))) {
            IntelligentRobotFactorySingleImpl intelligentRobotFactory = new IntelligentRobotFactorySingleImpl();
            IntelligentRobotEsImpl intelligentRobot = new IntelligentRobotEsImpl();
            intelligentRobot.setMaxAnswer(NumberBaseOpt.parseInteger((String)this.env.getProperty("question.robot.answer.maxsize"), (Integer)4).intValue());
            intelligentRobotFactory.setIntelligentRobot((IntelligentRobot)intelligentRobot);
            return intelligentRobotFactory;
        }
        IntelligentRobotFactoryRpcImpl intelligentRobotFactory = new IntelligentRobotFactoryRpcImpl();
        intelligentRobotFactory.setIntegrationEnvironment(this.integrationEnvironment);
        return intelligentRobotFactory;
    }

    @Bean
    public FileStore fileStore() {
        String baseHome = this.env.getProperty("os.file.base.dir");
        if (StringUtils.isBlank((CharSequence)baseHome)) {
            baseHome = SysParametersUtils.getUploadHome();
        }
        return new OsFileStore(baseHome);
    }

    @Bean
    public NotificationCenter notificationCenter() {
        NotificationCenterImpl notificationCenter = new NotificationCenterImpl();
        notificationCenter.initMsgSenders();
        return notificationCenter;
    }

    @Bean
    @Lazy(value=false)
    public OperationLogWriter operationLogWriter() {
        TextOperationLogWriterImpl operationLog = new TextOperationLogWriterImpl();
        operationLog.init();
        return operationLog;
    }

    @Bean
    public MessageSender smsMessageManager() {
        JsfgwSmsMessageSender smsMessageManager = new JsfgwSmsMessageSender();
        smsMessageManager.setSmsSendUrl(this.env.getProperty("sms.send.url"));
        return smsMessageManager;
    }

    @Bean
    public InstantiationServiceBeanPostProcessor instantiationServiceBeanPostProcessor() {
        return new InstantiationServiceBeanPostProcessor();
    }
}

