/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.robot.es.controller;

import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.im.robot.es.po.QuestAndAnswer;
import com.centit.im.robot.es.service.QuestAndAnswerManager;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/questAndAnswer"})
@Api(value="robot", tags={"robot"})
public class QuestAndAnswerController
extends BaseController {
    @Autowired
    protected QuestAndAnswerManager questAndAnswerManager;
    @Autowired(required=false)
    private ESSearcher esObjectSearcher;

    @ApiOperation(value="3\u65b0\u589e")
    @RequestMapping(value={"/addQuestion"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData createQuestionCatalog(@RequestBody QuestAndAnswer questAndAnswer) throws IOException {
        questAndAnswer.setCreateTime(DatetimeOpt.currentUtilDate());
        this.questAndAnswerManager.saveNewObject(questAndAnswer);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="4\u5220\u9664")
    @RequestMapping(value={"/deleteQuestion/{questionId}"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public ResponseData deleteQuestionCatalog(@PathVariable String questionId) {
        this.questAndAnswerManager.deleteObjectById(questionId);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="6\u4fee\u6539")
    @RequestMapping(value={"/updateQuestion"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public void updateQuestionCatalog(@RequestBody QuestAndAnswer questAndAnswer) {
        this.questAndAnswerManager.updateQuestionCatalog(questAndAnswer);
    }

    @ApiOperation(value="7es\u7cbe\u786e\u67e5\u8be2")
    @RequestMapping(value={"/listES/{map}/{value}/{queryWord}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Map<String, Object>> listEs(String map, String value, String queryWord, PageDesc pageDesc) {
        Pair res = this.esObjectSearcher.search(CollectionsOpt.createHashMap((Object[])new Object[]{map, value}), queryWord, pageDesc.getPageNo(), pageDesc.getPageSize());
        pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)res.getLeft()));
        return PageQueryResult.createResult((Collection)((Collection)res.getRight()), (PageDesc)pageDesc);
    }

    @ApiOperation(value="8es\u67e5\u8be2")
    @RequestMapping(value={"/listESall/{queryWord}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Map<String, Object>> listEsAll(String queryWord, PageDesc pageDesc) {
        Pair res = this.esObjectSearcher.search(queryWord, pageDesc.getPageNo(), pageDesc.getPageSize());
        pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)res.getLeft()));
        return PageQueryResult.createResult((Collection)((Collection)res.getRight()), (PageDesc)pageDesc);
    }
}

