/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.robot.es.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.im.robot.es.po.QuestAndAnswer;
import com.centit.im.robot.es.service.QuestAndAnswerManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/questAndAnswer"})
public class QuestAndAnswerController
extends BaseController {
    @Resource
    protected QuestAndAnswerManager questAndAnswerManager;

    @RequestMapping(method={RequestMethod.GET})
    public void list(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = QuestAndAnswerController.convertSearchColumn((HttpServletRequest)request);
        JSONArray listObjects = this.questAndAnswerManager.listObjectsAsJson(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{questionId}"}, method={RequestMethod.GET})
    public void getQuestionCatalog(@PathVariable String questionId, HttpServletResponse response) {
        QuestAndAnswer questAndAnswer = (QuestAndAnswer)this.questAndAnswerManager.getObjectById((Serializable)((Object)questionId));
        JsonResultUtils.writeSingleDataJson((Object)questAndAnswer, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void createQuestionCatalog(@RequestBody QuestAndAnswer questAndAnswer, HttpServletResponse response) throws IOException {
        questAndAnswer.setCreateTime(DatetimeOpt.currentUtilDate());
        this.questAndAnswerManager.saveNewObject(questAndAnswer);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{questionId}"}, method={RequestMethod.DELETE})
    public void deleteQuestionCatalog(@PathVariable String questionId, HttpServletResponse response) {
        this.questAndAnswerManager.deleteObjectById((Serializable)((Object)questionId));
        JsonResultUtils.writeSingleDataJson((Object)questionId, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/delete/{questionId}"}, method={RequestMethod.DELETE})
    public void deleteQuestionCatalogSign(@PathVariable String questionId, HttpServletResponse response) {
        QuestAndAnswer questAndAnswer = (QuestAndAnswer)this.questAndAnswerManager.getObjectById((Serializable)((Object)questionId));
        if (questAndAnswer == null) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        questAndAnswer.setDeleteSign("T");
        this.questAndAnswerManager.mergeObject(questAndAnswer);
        JsonResultUtils.writeSingleDataJson((Object)questionId, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{questionId}"}, method={RequestMethod.PUT})
    public void updateQuestionCatalog(@PathVariable String questionId, @RequestBody QuestAndAnswer questAndAnswer, HttpServletResponse response) throws IOException {
        QuestAndAnswer dbQuestAndAnswer = (QuestAndAnswer)this.questAndAnswerManager.getObjectById((Serializable)((Object)questionId));
        if (null == questAndAnswer) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        dbQuestAndAnswer.copyNotNullProperty(questAndAnswer);
        this.questAndAnswerManager.mergeObject(dbQuestAndAnswer);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

