/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.service.impl;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.model.basedata.IUserUnit;
import com.centit.im.dao.FriendMemoDao;
import com.centit.im.dao.WebImCustomerDao;
import com.centit.im.dao.WebImGroupDao;
import com.centit.im.dao.WebImGroupMemberDao;
import com.centit.im.po.WebImCustomer;
import com.centit.im.po.WebImFriendMemo;
import com.centit.im.po.WebImGroup;
import com.centit.im.po.WebImGroupMember;
import com.centit.im.po.WebImGroupMemberId;
import com.centit.im.service.WebImSocket;
import com.centit.im.service.WebImUserManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="webImUserManager")
public class WebImUserManagerImpl
implements WebImUserManager {
    @Autowired
    protected WebImSocket webImSocket;
    @Autowired
    protected WebImCustomerDao customerDao;
    @Autowired
    protected FriendMemoDao friendMemoDao;
    @Autowired
    protected WebImGroupDao webImGroupDao;
    @Autowired
    protected WebImGroupMemberDao webImGroupMemberDao;

    @Override
    @Transactional
    public WebImCustomer getUser(String userCode) {
        IUserInfo ui;
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        WebImCustomer cust = (WebImCustomer)this.customerDao.getObjectById(userCode);
        if (cust == null && (ui = CodeRepositoryUtil.getUserInfoByCode((String)topUnit, (String)userCode)) != null) {
            cust = new WebImCustomer(userCode, ui.getUserName());
            cust.setUserType("U");
            cust.setOsId("WebIM");
        }
        if (cust != null) {
            cust.setUserState(this.webImSocket.checkUserState(userCode));
        }
        return cust;
    }

    @Override
    public int registerUser(WebImCustomer user) {
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        WebImCustomer customer = (WebImCustomer)this.customerDao.getObjectById(user.getUserCode());
        if (customer == null) {
            IUserInfo userInfo;
            user.setCreator("U0000000");
            if (StringUtils.isBlank((CharSequence)user.getUserName()) && (userInfo = CodeRepositoryUtil.getUserInfoByCode((String)topUnit, (String)user.getUserCode())) != null) {
                user.setUserName(userInfo.getUserName());
            }
            user.setCreateTime(DatetimeOpt.currentUtilDate());
            user.setLastActiveDate(DatetimeOpt.currentUtilDate());
            this.customerDao.saveNewObject(user);
        }
        return 1;
    }

    @Override
    @Transactional
    public List<WebImCustomer> listAllUser() {
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        List users = CodeRepositoryUtil.listAllUsers((String)topUnit);
        if (users == null || users.size() < 1) {
            return new ArrayList<WebImCustomer>();
        }
        List custs = this.customerDao.listObjects();
        HashMap<String, WebImCustomer> customerMap = new HashMap<String, WebImCustomer>(custs.size() * 3 / 2 + 1);
        for (WebImCustomer cust : custs) {
            customerMap.put(cust.getUserCode(), cust);
        }
        ArrayList<WebImCustomer> allcusts = new ArrayList<WebImCustomer>(users.size());
        for (IUserInfo user : users) {
            WebImCustomer cust = (WebImCustomer)customerMap.get(user.getUserCode());
            if (cust == null) {
                cust = new WebImCustomer(user.getUserCode(), user.getUserName());
                cust.setUserType("U");
                cust.setOsId("WebIM");
            }
            cust.setUserState(this.webImSocket.checkUserState(cust.getUserCode()));
            allcusts.add(cust);
        }
        return allcusts;
    }

    @Override
    @Transactional
    public List<WebImCustomer> listCustomerService() {
        List<WebImCustomer> allcusts = this.customerDao.listCustomerService();
        if (allcusts == null || allcusts.size() < 1) {
            return allcusts;
        }
        for (WebImCustomer cust : allcusts) {
            cust.setUserState(this.webImSocket.checkUserState(cust.getUserCode()));
        }
        return allcusts;
    }

    @Override
    @Transactional
    public List<WebImCustomer> listServiceCustomer(String serviceUserCode, Date lastServiceDate) {
        List<WebImCustomer> allcusts = this.customerDao.listServiceCustomer(serviceUserCode, lastServiceDate);
        for (WebImCustomer cust : allcusts) {
            cust.setUserState(this.webImSocket.checkUserState(cust.getUserCode()));
        }
        return allcusts;
    }

    @Override
    @Transactional
    public List<WebImCustomer> listCustomerService(String custCode, Date lastServiceDate) {
        List<WebImCustomer> allcusts = this.customerDao.listCustomerService(custCode, lastServiceDate);
        for (WebImCustomer cust : allcusts) {
            cust.setUserState(this.webImSocket.checkUserState(cust.getUserCode()));
        }
        return allcusts;
    }

    private WebImCustomer fetchCustomerInfo(String userCode) {
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        IUserInfo ui = CodeRepositoryUtil.getUserInfoByCode((String)topUnit, (String)userCode);
        if (ui == null) {
            return null;
        }
        WebImCustomer cust = new WebImCustomer(userCode, ui.getUserName());
        cust.setUserType("U");
        cust.setOsId("WebIM");
        return cust;
    }

    @Override
    @Transactional
    public List<WebImCustomer> listUnitUsers(String unitCode) {
        List users = CodeRepositoryUtil.listUnitUsers((String)unitCode);
        ArrayList<WebImCustomer> allcusts = new ArrayList<WebImCustomer>(users.size());
        for (IUserUnit user : users) {
            WebImCustomer cust = (WebImCustomer)this.customerDao.getObjectById(user.getUserCode());
            if (cust == null) {
                cust = this.fetchCustomerInfo(user.getUserCode());
            }
            if (cust == null) continue;
            cust.setUserState(this.webImSocket.checkUserState(cust.getUserCode()));
            allcusts.add(cust);
        }
        return allcusts;
    }

    @Override
    @Transactional
    public List<WebImCustomer> queryUsers(String name, PageDesc pageDesc) {
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        List users = CodeRepositoryUtil.listAllUsers((String)topUnit);
        if (users == null || users.size() < 1) {
            return new ArrayList<WebImCustomer>();
        }
        ArrayList<WebImCustomer> allcusts = new ArrayList<WebImCustomer>(pageDesc.getPageSize());
        int nMatchCount = 0;
        int startRow = pageDesc.getRowStart();
        int endRow = pageDesc.getRowEnd();
        for (IUserInfo user : users) {
            WebImCustomer cust;
            if (!StringUtils.contains((CharSequence)user.getUserName(), (CharSequence)name) && !StringUtils.contains((CharSequence)user.getRegCellPhone(), (CharSequence)name) && !StringUtils.contains((CharSequence)user.getLoginName(), (CharSequence)name) || (cust = null) != null) continue;
            if (++nMatchCount > startRow) {
                cust = new WebImCustomer(user.getUserCode(), user.getUserName());
                cust.setUserType("U");
                cust.setOsId("WebIM");
                cust.setUserState("F");
                allcusts.add(cust);
            }
            if (nMatchCount < endRow) continue;
            break;
        }
        pageDesc.setTotalRows(Integer.valueOf(nMatchCount >= endRow ? nMatchCount + pageDesc.getPageSize() : nMatchCount));
        return allcusts;
    }

    @Override
    @Transactional
    public Map<String, String> listAllUserState() {
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        List users = CodeRepositoryUtil.listAllUsers((String)topUnit);
        return this.webImSocket.checkUsersState(users);
    }

    @Override
    @Transactional
    public List<? extends IUnitInfo> listAllUnit() {
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        return CodeRepositoryUtil.listAllUnits((String)topUnit);
    }

    @Override
    @Transactional
    public List<? extends IUnitInfo> listSubUnit(String parentUnitCode) {
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        List allUnits = CodeRepositoryUtil.listAllUnits((String)topUnit);
        ArrayList<IUnitInfo> units = new ArrayList<IUnitInfo>();
        for (IUnitInfo uc : allUnits) {
            if (StringUtils.isBlank((CharSequence)parentUnitCode) || "0".equals(parentUnitCode)) {
                if (!StringUtils.isBlank((CharSequence)uc.getParentUnit()) && !"0".equals(uc.getParentUnit())) continue;
                units.add(uc);
                continue;
            }
            if (!parentUnitCode.equals(uc.getParentUnit())) continue;
            units.add(uc);
        }
        return units;
    }

    @Override
    @Transactional
    public List<IUnitInfo> listUserUnits(String userCode) {
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        List units = CodeRepositoryUtil.listUserUnits((String)topUnit, (String)userCode);
        if (units == null || units.size() < 1) {
            return null;
        }
        ArrayList<IUnitInfo> userUnits = new ArrayList<IUnitInfo>(units.size());
        for (IUserUnit unit : units) {
            IUnitInfo unitInfo = CodeRepositoryUtil.getUnitInfoByCode((String)topUnit, (String)unit.getUnitCode());
            if (unitInfo == null) continue;
            userUnits.add(unitInfo);
        }
        return userUnits;
    }

    @Override
    @Transactional
    public String configUserInfo(String userCode, WebImCustomer cust) {
        cust.setUserCode(userCode);
        this.customerDao.updateObject(cust);
        return userCode;
    }

    @Override
    @Transactional
    public void saveUserFriendMemo(WebImFriendMemo memo) {
        this.friendMemoDao.saveNewObject(memo);
    }

    private void saveMemberToGroup(String groupId, String memberCode) {
        WebImGroupMember member = (WebImGroupMember)this.webImGroupMemberDao.getObjectById(new WebImGroupMemberId(groupId, memberCode));
        if (member != null) {
            return;
        }
        member = new WebImGroupMember(new WebImGroupMemberId(groupId, memberCode), DatetimeOpt.currentUtilDate());
        member.setJoinTime(DatetimeOpt.currentUtilDate());
        member.setOsId("WebIM");
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        WebImCustomer customer = (WebImCustomer)this.customerDao.getObjectById(memberCode);
        if (customer == null) {
            customer = new WebImCustomer();
            customer.setCreator("U0000000");
            customer.setUserCode(memberCode);
            customer.setUserName(memberCode);
            IUserInfo userInfo = CodeRepositoryUtil.getUserInfoByCode((String)topUnit, (String)memberCode);
            if (userInfo != null) {
                customer.setUserName(userInfo.getUserName());
            }
            customer.setOsId("WebIM");
            customer.setCreateTime(DatetimeOpt.currentUtilDate());
            customer.setLastActiveDate(DatetimeOpt.currentUtilDate());
            this.customerDao.saveNewObject(customer);
        }
        member.setGroupAlias(customer.getUserName());
        this.webImGroupMemberDao.saveNewObject(member);
    }

    @Override
    @Transactional
    public List<WebImGroup> listUserGroups(String userCode) {
        return this.webImGroupDao.listObjectsByFilter("where GROUP_TYPE <> 'U' and GROUP_ID in (select UNIT_CODE from F_WEB_IM_GROUP_MEMBER  where USER_CODE = ?)", new Object[]{userCode});
    }

    @Override
    @Transactional
    public List<WebImGroup> queryUserGroups(String userCode, String groupName) {
        return this.webImGroupDao.listObjectsByFilter("where GROUP_TYPE <> 'U' and GROUP_NAME like ?  and GROUP_ID in (select UNIT_CODE from F_WEB_IM_GROUP_MEMBER  where USER_CODE = ?) ", new Object[]{QueryUtils.getMatchString((String)groupName), userCode});
    }

    @Override
    @Transactional
    public List<WebImGroup> queryGroups(Map<String, Object> params, PageDesc pageDesc) {
        return this.webImGroupDao.listObjectsByProperties(params, pageDesc);
    }

    @Override
    @Transactional
    public String createGroup(WebImGroup webImGroup) {
        String groupId = webImGroup.getGroupId();
        if (StringUtils.isBlank((CharSequence)groupId)) {
            groupId = UuidOpt.getUuidAsString22();
            webImGroup.setGroupId(groupId);
        }
        this.webImGroupDao.saveNewObject(webImGroup);
        String creator = webImGroup.getCreator();
        if (StringUtils.isNotBlank((CharSequence)creator)) {
            this.saveMemberToGroup(groupId, creator);
        }
        return groupId;
    }

    @Override
    @Transactional
    public String createGroupWithMembers(WebImGroup webImGroup, String[] members) {
        String groupId = this.createGroup(webImGroup);
        if (members != null) {
            for (String memberCode : members) {
                this.saveMemberToGroup(groupId, memberCode);
            }
        }
        return groupId;
    }

    @Override
    @Transactional
    public void updateGroupInfo(WebImGroup webImGroup) {
        if (webImGroup == null) {
            return;
        }
        this.webImGroupDao.updateObject(webImGroup);
    }

    @Override
    public List<WebImGroupMember> listGroupMembers(String groupId) {
        return this.webImGroupMemberDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", groupId}));
    }

    @Override
    @Transactional
    public void updateGroupMemberInfo(WebImGroupMember webImGroupMember) {
        this.webImGroupMemberDao.updateObject(webImGroupMember);
    }

    @Override
    @Transactional
    public void addGroupMember(String groupId, String memberCode) {
        this.saveMemberToGroup(groupId, memberCode);
    }

    @Override
    @Transactional
    public void updateGroupMembers(String groupId, String[] members) {
        if (members == null || members.length < 1) {
            return;
        }
        List memberList = CollectionsOpt.arrayToList((Object[])members);
        List dbMembers = this.webImGroupMemberDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"groupId", groupId}));
        if (dbMembers != null && dbMembers.size() > 0) {
            for (WebImGroupMember member : dbMembers) {
                if (memberList.contains(member.getUserCode())) continue;
                this.webImGroupMemberDao.deleteObjectById(member.getCid());
            }
        }
        for (String memberCode : members) {
            this.saveMemberToGroup(groupId, memberCode);
        }
    }

    @Override
    @Transactional
    public void removeGroupMember(String groupId, String userCode) {
        this.webImGroupMemberDao.deleteObjectById(new WebImGroupMemberId(groupId, userCode));
    }

    @Override
    @Transactional
    public int dissolveGroup(String groupId, String userCode, boolean force) {
        WebImGroup dbWebImGroup = (WebImGroup)this.webImGroupDao.getObjectById(groupId);
        if (dbWebImGroup != null && (force || dbWebImGroup.getCreator().equals(userCode))) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("groupId", groupId);
            this.webImGroupMemberDao.deleteObjectsByProperties(map);
            this.webImGroupDao.deleteObjectById(groupId);
            return 1;
        }
        return -1;
    }

    @Override
    public WebImGroup getGroupInfo(String groupId) {
        return (WebImGroup)this.webImGroupDao.getObjectById(groupId);
    }
}

