/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.service.impl;

import com.centit.framework.appclient.AppSession;
import com.centit.framework.appclient.RestfulHttpRequest;
import com.centit.im.po.RobotAnswer;
import com.centit.im.service.IntelligentRobot;
import java.net.URLEncoder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntelligentRobotRpcImpl
implements IntelligentRobot {
    private static Logger log = LoggerFactory.getLogger(IntelligentRobotRpcImpl.class);
    private AppSession appSession;

    public void initAppSession(String appServerUrl, String userCode, String password) {
        this.appSession = new AppSession(appServerUrl, userCode, password);
    }

    public void initAppSession(String appServerUrl) {
        this.appSession = new AppSession(appServerUrl);
    }

    public CloseableHttpClient getHttpClient() throws Exception {
        return this.appSession.allocHttpClient();
    }

    public void releaseHttpClient(CloseableHttpClient httpClient) {
        this.appSession.releaseHttpClient(httpClient);
    }

    public RobotAnswer sayHello(String custUserCode) {
        RobotAnswer result = (RobotAnswer)RestfulHttpRequest.getResponseObject((AppSession)this.appSession, (String)("/hello/" + custUserCode), RobotAnswer.class);
        if (result != null) {
            return result;
        }
        return RobotAnswer.createTestAnswer();
    }

    public RobotAnswer sayGoodbye(String custUserCode) {
        RobotAnswer result = (RobotAnswer)RestfulHttpRequest.getResponseObject((AppSession)this.appSession, (String)("/goodbye/" + custUserCode), RobotAnswer.class);
        if (result != null) {
            return result;
        }
        return RobotAnswer.createTestAnswer();
    }

    public RobotAnswer askQuestion(String custUserCode, String question) {
        try {
            RobotAnswer result = (RobotAnswer)RestfulHttpRequest.getResponseObject((AppSession)this.appSession, (String)("/ask/" + custUserCode + "?question=" + URLEncoder.encode(question, "utf-8") + "&userCode" + custUserCode), RobotAnswer.class);
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return RobotAnswer.createTestAnswer();
    }
}

