/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.im.po.WebImCustomer;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Repository;

@Repository
public class WebImCustomerDao
extends BaseDaoImpl<WebImCustomer, String> {
    public static final Log log = LogFactory.getLog(WebImCustomerDao.class);

    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("osId", "EQUAL");
        filterField.put("userCode", "EQUAL");
        filterField.put("userName", "LIKE");
        filterField.put("customerService", "EQUAL");
        filterField.put("creator", "EQUAL");
        filterField.put("createTime", "EQUAL");
        return filterField;
    }

    public List<WebImCustomer> listCustByType(String userType) {
        return this.listObjectsByFilter("where USER_TYPE = ?", new Object[]{userType});
    }

    public List<WebImCustomer> listCustomerService() {
        return this.listObjectsByFilter(" where USER_TYPE = 'S' or USER_TYPE = 'P'", new Object[0]);
    }

    public List<WebImCustomer> listCustomerServiceByOptId(String optId) {
        return this.listObjectsByFilter("where (USER_TYPE = 'S' or USER_TYPE = 'P') and SERVICE_OPTS like ? ", new Object[]{"%" + optId + "%"});
    }

    public List<WebImCustomer> listServiceCustomer(String serviceUserCode, Date lastServiceDate) {
        Date lsd = lastServiceDate == null ? DatetimeOpt.addMonths((Date)DatetimeOpt.currentUtilDate(), (int)-1) : lastServiceDate;
        String sql = "select b.USER_CODE,b.OS_ID,b.USER_TYPE,b.USER_NAME,b.HEAD_SCULPTURE,b.CUSTOMER_SERVICE, b.LAST_ACTIVE_DATE,b.CREATOR,b.Service_Opts,b.CREATE_TIME  from f_web_im_customer b  where exists ( SELECT * FROM f_web_im_message f       where ((f.SENDER = b.USER_CODE and f.RECEIVER= :serviceCode ) or (f.SENDER= :serviceCode and f.RECEIVER = b.USER_CODE)) and f.SEND_TIME >= :serviceDate)  and b.USER_TYPE = 'C'  ORDER BY b.LAST_ACTIVE_DATE ";
        return this.listObjectsBySql(sql, CollectionsOpt.createHashMap((Object[])new Object[]{"serviceCode", serviceUserCode, "serviceDate", lsd}));
    }

    public List<WebImCustomer> listCustomerService(String custCode, Date lastServiceDate) {
        Date lsd = lastServiceDate == null ? DatetimeOpt.addMonths((Date)DatetimeOpt.currentUtilDate(), (int)-1) : lastServiceDate;
        String sql = "select b.USER_CODE,b.OS_ID,b.USER_TYPE,b.USER_NAME,b.HEAD_SCULPTURE,b.CUSTOMER_SERVICE, b.LAST_ACTIVE_DATE,b.CREATOR,b.Service_Opts,b.CREATE_TIME  from f_web_im_customer b  where exists ( SELECT * FROM f_web_im_message f       where ((f.SENDER = b.USER_CODE and f.RECEIVER= :custCode ) or (f.SENDER= :custCode and f.RECEIVER = b.USER_CODE)) and f.SEND_TIME >= :serviceDate)  and ( b.USER_TYPE = 'S' or b.USER_TYPE = 'P' )  ORDER BY b.LAST_ACTIVE_DATE ";
        return this.listObjectsBySql(sql, CollectionsOpt.createHashMap((Object[])new Object[]{"custCode", custCode, "serviceDate", lsd}));
    }
}

