/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.im.po.WebImCustomer;
import com.centit.im.po.WebImFriendMemo;
import com.centit.im.po.WebImGroup;
import com.centit.im.po.WebImGroupMember;
import com.centit.im.service.WebImSocket;
import com.centit.im.service.WebImUserManager;
import com.centit.im.utils.ImMessageBuild;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.compiler.Lexer;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.image.ImageOpt;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/webimcust"})
@Api(value="\u7528\u6237\u7ba1\u7406\u63a5\u53e3", tags={"\u7528\u6237\u7ba1\u7406\u63a5\u53e3"})
public class WebImUserController
extends BaseController {
    @Autowired
    protected WebImUserManager webImUserManager;
    @Autowired
    protected FileStore fileStore;
    @Autowired
    protected WebImSocket webImSocket;

    @ApiOperation(value="01\u914d\u7f6e\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/friend"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData setFriendMemo(@RequestBody WebImFriendMemo memo) {
        this.webImUserManager.saveUserFriendMemo(memo);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="02\u6ce8\u518c\u7528\u6237")
    @RequestMapping(value={"/register"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData registerUser(@RequestBody WebImCustomer user) {
        this.webImUserManager.registerUser(user);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="30\u7528\u6237\u79bb\u7ebf")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/signOut/{userCode}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData signOut(@PathVariable String userCode) {
        this.webImSocket.signOutUser(userCode);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="03\u67e5\u8be2\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"/listUser"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<WebImCustomer> listAllUser() {
        return this.webImUserManager.listAllUser();
    }

    @ApiOperation(value="26\u6839\u636e\u59d3\u540d\u67e5\u8be2\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"/queryUser"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<WebImCustomer> queryUser(String name, PageDesc pageDesc) {
        List<WebImCustomer> customers = this.webImUserManager.queryUsers(name, pageDesc);
        return PageQueryResult.createResult(customers, (PageDesc)pageDesc);
    }

    @ApiOperation(value="04\u67e5\u8be2\u673a\u6784\u5217\u8868")
    @RequestMapping(value={"/allUnit"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUnitInfo> listAllUnits() {
        List<? extends IUnitInfo> allUnits = this.webImUserManager.listAllUnit();
        if (allUnits == null || allUnits.isEmpty()) {
            return allUnits;
        }
        CollectionsOpt.sortAsTree(allUnits, IUnitInfo::getUnitCode, IUnitInfo::getParentUnit);
        return allUnits;
    }

    @ApiOperation(value="05\u67e5\u8be2\u4e0b\u5c42\u673a\u6784\u5217\u8868")
    @ApiImplicitParam(name="parentUnitCode", value="\u673a\u6784\u4ee3\u7801\uff1b\u20180\u2019\u8868\u793a\u9876\u5c42\u673a\u6784", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/subUnit/{parentUnitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends IUnitInfo> listSubUnits(@PathVariable String parentUnitCode) {
        List<? extends IUnitInfo> allUnits = this.webImUserManager.listSubUnit(parentUnitCode);
        if (allUnits == null || allUnits.isEmpty()) {
            return allUnits;
        }
        Collections.sort(allUnits, GeneralAlgorithm.comparing(IUnitInfo::getUnitOrder, (boolean)false));
        return allUnits;
    }

    @ApiOperation(value="06\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f")
    @RequestMapping(value={"/user/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public WebImCustomer getUser(@PathVariable String userCode) {
        return this.webImUserManager.getUser(userCode);
    }

    @ApiOperation(value="07\u67e5\u8be2\u6240\u6709\u670d\u52a1\u7684\u5bf9\u8c61")
    @RequestMapping(value={"/cust/{serviceUserCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<WebImCustomer> listServiceCustomer(@PathVariable String serviceUserCode, Date lastServiceDate) {
        return this.webImUserManager.listServiceCustomer(serviceUserCode, lastServiceDate);
    }

    @ApiOperation(value="08\u67e5\u8be2\u6240\u6709\u5ba2\u670d\u4e13\u5bb6")
    @RequestMapping(value={"/services"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<WebImCustomer> listCustomerService() {
        return this.webImUserManager.listCustomerService();
    }

    @ApiOperation(value="25\u67e5\u8be2\u548c\u7528\u6237\u4ea4\u6d41\u8fc7\u7684\u6240\u6709\u5ba2\u670d")
    @RequestMapping(value={"/services/{custCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<WebImCustomer> listCustomerService(@PathVariable String custCode, Date lastServiceDate) {
        return this.webImUserManager.listCustomerService(custCode, lastServiceDate);
    }

    @ApiOperation(value="09\u67e5\u8be2\u7cfb\u7edf\u8054\u7cfb\u72b6\u6001")
    @RequestMapping(value={"/userState"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, String> listAllUserState() {
        return this.webImUserManager.listAllUserState();
    }

    @ApiOperation(value="10\u67e5\u8be2\u7528\u6237\u7684\u673a\u6784\uff08\u5185\u7f6e\u7684\u548c\u7ec4\u7ec7\u673a\u6784\u4e00\u81f4\u7684\u7fa4\uff09")
    @RequestMapping(value={"/userUnits/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<IUnitInfo> listUserUnit(@PathVariable String userCode) {
        return this.webImUserManager.listUserUnits(userCode);
    }

    @ApiOperation(value="11\u67e5\u8be2\u673a\u6784\u4e2d\u7684\u6210\u5458")
    @RequestMapping(value={"/unitUsers/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<WebImCustomer> listUnitUsers(@PathVariable String unitCode) {
        return this.webImUserManager.listUnitUsers(unitCode);
    }

    @ApiOperation(value="12\u914d\u7f6e\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/config/{userCode}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public String setUserConfig(@PathVariable String userCode, @RequestBody WebImCustomer cust) {
        return this.webImUserManager.configUserInfo(userCode, cust);
    }

    @ApiOperation(value="13\u67e5\u8be2\u7528\u6237\u7684\u673a\u6784\uff08\u5185\u7f6e\u7684\u548c\u7ec4\u7ec7\u673a\u6784\u4e00\u81f4\u7684\u7fa4\uff09")
    @RequestMapping(value={"/userGroups/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<WebImGroup> listUserGroups(@PathVariable String userCode) {
        return this.webImUserManager.listUserGroups(userCode);
    }

    @ApiOperation(value="27\u6839\u636e\u7fa4\u540d\u67e5\u8be2\u7528\u6237\u6240\u5728\u7fa4\u5217\u8868")
    @RequestMapping(value={"/queryUserGroups/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<WebImGroup> queryUserGroup(@PathVariable String userCode, String name) {
        return this.webImUserManager.queryUserGroups(userCode, name);
    }

    @ApiOperation(value="28\u6839\u636e\u7fa4\u540d\u7fa4\u5217\u8868")
    @RequestMapping(value={"/queryGroups"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<WebImGroup> queryGroup(HttpServletRequest request, PageDesc pageDesc) {
        Map params = WebImUserController.collectRequestParameters((HttpServletRequest)request);
        List<WebImGroup> objs = this.webImUserManager.queryGroups(params, pageDesc);
        return PageQueryResult.createResult(objs, (PageDesc)pageDesc);
    }

    @ApiOperation(value="14\u521b\u5efa\u7fa4\u53ca\u7528\u6237\u6570\u7ec4")
    @ApiImplicitParam(name="groupJson", value="json\u683c\u5f0f\uff0c\u7fa4\u7ec4\u4fe1\u606f\uff0c\u6dfb\u52a0\u4e86\u4e00\u4e2a\u989d\u5916\u7684\u5c5e\u6027\u201cmembers\u201d\u4e3a\u7fa4\u6210\u5458\u7528\u6237\u4ee3\u7801\u6570\u503c", paramType="body", dataTypeClass=WebImGroup.class)
    @RequestMapping(value={"/group"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public WebImGroup createGroup(@RequestBody String groupJson, HttpServletRequest request) {
        JSONObject jsonObject = JSON.parseObject((String)groupJson);
        WebImGroup webImGroup = WebImGroup.createFromJson(jsonObject);
        String currentUserCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)currentUserCode)) {
            webImGroup.setCreator(currentUserCode);
        }
        webImGroup.setGroupType("G");
        Object members = jsonObject.get("members");
        String groupId = this.webImUserManager.createGroupWithMembers(webImGroup, (String[])CollectionsOpt.listToArray((Collection)StringBaseOpt.objectToStringList((Object)members)));
        webImGroup.setGroupId(groupId);
        for (String memberCode : StringBaseOpt.objectToStringList((Object)members)) {
            this.webImSocket.sendMessage(memberCode, ImMessageBuild.create().type("M").sender("system").receiver(memberCode).contentType("notice").message("\u60a8\u52a0\u5165\u4e86\u7fa4" + webImGroup.getGroupName() + "\uff01").addContent("groupId", (Object)groupId).build());
        }
        return webImGroup;
    }

    @ApiOperation(value="15\u4fee\u6539\u7fa4\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"/group"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData updateGroupInfo(@RequestBody String groupJson) {
        WebImGroup webImGroup = WebImGroup.createFromJsonString(groupJson);
        this.webImUserManager.updateGroupInfo(webImGroup);
        this.webImSocket.sendGroupMessage(webImGroup.getGroupId(), ImMessageBuild.create().type("M").sender("system").receiver(webImGroup.getGroupId()).contentType("update").content((Map)((JSONObject)JSON.toJSON((Object)webImGroup))).build());
        return ResponseData.makeSuccessResponse();
    }

    private void innerAddGroupMember(String groupId, String memberCode, String userCode) {
        this.webImUserManager.addGroupMember(groupId, memberCode);
        WebImCustomer user = this.webImUserManager.getUser(memberCode);
        String memberDesc = user == null ? memberCode : user.getUserName();
        WebImGroup group = this.webImUserManager.getGroupInfo(groupId);
        String groupDesc = group == null ? groupId : group.getGroupName();
        this.webImSocket.sendMessage(memberCode, ImMessageBuild.create().type("M").sender("system").receiver(memberCode).contentType("notice").addContent("groupId", (Object)groupId).addContent("userId", (Object)memberCode).message("\u60a8\u52a0\u5165\u4e86\u7fa4" + groupDesc + "\uff01").build());
        String userDesc = this.webImUserManager.getUser(userCode) == null ? userCode : this.webImUserManager.getUser(userCode).getUserName();
        userDesc = memberDesc + "\u88ab" + userDesc + "\u62c9\u5165\u7fa4\u804a\uff01";
        this.webImSocket.sendGroupMessage(groupId, ImMessageBuild.create().type("S").sender("system").receiver(groupId).contentType("notice").message(userDesc).addContent("groupId", (Object)groupId).addContent("userId", (Object)memberCode).build());
    }

    @ApiOperation(value="17\u6dfb\u52a0\u591a\u4e2a\u7528\u6237\u5165\u7fa4")
    @RequestMapping(value={"/member/{groupId}/{userCode}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData addGroupMembers(@PathVariable String groupId, @PathVariable String userCode, @RequestBody String memberCodes) {
        Lexer lexer = new Lexer(memberCodes);
        String word = lexer.getAWord();
        while (StringUtils.isNotBlank((CharSequence)word)) {
            if (!StringUtils.equalsAny((CharSequence)word, (CharSequence[])new CharSequence[]{"[", ",", "]"}) && StringUtils.isNotBlank((CharSequence)(word = StringRegularOpt.trimString((String)word)))) {
                this.innerAddGroupMember(groupId, word, userCode);
            }
            word = lexer.getAWord();
        }
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="18\u4fee\u6539\u7fa4\u6210\u5458\u4fe1\u606f")
    @RequestMapping(value={"/member"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData updateGroupMember(@RequestBody String memberInfoJson) {
        WebImGroupMember webImGroupMember = WebImGroupMember.createFromJson(JSON.parseObject((String)memberInfoJson));
        this.webImUserManager.updateGroupMemberInfo(webImGroupMember);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="19\u83b7\u53d6\u7fa4\u6210\u5458\u4fe1\u606f")
    @RequestMapping(value={"/member/{groupId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<WebImGroupMember> listGroupMembers(@PathVariable String groupId) {
        return this.webImUserManager.listGroupMembers(groupId);
    }

    @ApiOperation(value="20\u83b7\u53d6\u7fa4\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"/group/{groupId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public WebImGroup getGroupInfo(@PathVariable String groupId) {
        return this.webImUserManager.getGroupInfo(groupId);
    }

    @ApiOperation(value="21\u9000\u51fa\u7fa4")
    @RequestMapping(value={"/quitGroup/{groupId}/{memberCode}/{userCode}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseData removeGroupMember(@PathVariable String groupId, @PathVariable String memberCode, @PathVariable String userCode) {
        this.webImUserManager.removeGroupMember(groupId, memberCode);
        WebImCustomer user = this.webImUserManager.getUser(memberCode);
        String memberDesc = user == null ? memberCode : user.getUserName();
        String userDesc = this.webImUserManager.getUser(userCode) == null ? userCode : this.webImUserManager.getUser(userCode).getUserName();
        userDesc = memberDesc + "\u88ab" + userDesc + "\u8e22\u51fa\u7fa4\u804a";
        this.webImSocket.sendGroupMessage(groupId, ImMessageBuild.create().type("S").sender("system").receiver(groupId).contentType("notice").message(userDesc).build());
        WebImGroup group = this.webImUserManager.getGroupInfo(groupId);
        String groupDesc = group == null ? groupId : group.getGroupName();
        this.webImSocket.sendMessage(memberCode, ImMessageBuild.create().type("M").sender("system").receiver(memberCode).contentType("quitGroup").message("\u60a8\u5df2\u9000\u51fa\u4e86\u7fa4" + groupDesc + "\uff01").addContent("groupId", (Object)groupId).build());
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="22\u7528\u6237\u9000\u7fa4")
    @RequestMapping(value={"/dissolveGroup/{groupId}/{userCode}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public ResponseMapData dissolveGroup(@PathVariable String groupId, @PathVariable String userCode) {
        int nRres = this.webImUserManager.dissolveGroup(groupId, userCode, false);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("flag", (Object)nRres);
        if (nRres > 0) {
            return resData;
        }
        resData.addResponseData("message", (Object)"\u7fa4\u4e0d\u5b58\u5728\u6216\u8005\u60a8\u4e0d\u662f\u7fa4\u4e3b\u3002");
        return resData;
    }

    @ApiOperation(value="23\u5220\u9664\uff08\u89e3\u6563\uff09\u7fa4")
    @RequestMapping(value={"/deleteGroup/{groupId}/{userCode}"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public ResponseMapData deleteGroup(@PathVariable String groupId, @PathVariable String userCode) {
        List<WebImGroupMember> members = this.webImUserManager.listGroupMembers(groupId);
        WebImGroup webImGroup = this.webImUserManager.getGroupInfo(groupId);
        int nRres = this.webImUserManager.dissolveGroup(groupId, userCode, true);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("flag", (Object)nRres);
        if (nRres > 0) {
            for (WebImGroupMember memberCode : members) {
                this.webImSocket.sendMessage(memberCode.getUserCode(), ImMessageBuild.create().type("M").sender("system").receiver(memberCode.getUserCode()).contentType("deleteGroup").message("\u7fa4" + webImGroup.getGroupName() + "\u5df2\u89e3\u6563\uff01").addContent("groupId", (Object)groupId).build());
            }
            return resData;
        }
        resData.addResponseData("message", (Object)"\u7fa4\u4e0d\u5b58\u5728\u3002");
        return resData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="24 \u83b7\u53d6\u7528\u6237\u5934\u50cf")
    @RequestMapping(value={"/sculpture/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody(contentType=WrapUpContentType.IMAGE)
    public RenderedImage getHeadSculpture(@PathVariable String userCode, Integer size, Integer point) {
        String headFileId = null;
        WebImCustomer user = this.webImUserManager.getUser(userCode);
        if (user != null) {
            headFileId = user.getHeadSculpture();
        }
        if (StringUtils.length(headFileId) > 35) {
            FileInfo fileInfo = UploadDownloadUtils.createFileBaseInfo((String)headFileId);
            try (InputStream inputStream = this.fileStore.loadFileStream(this.fileStore.matchFileStoreUrl((FileBaseInfo)fileInfo, fileInfo.getFileSize()));){
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                return bufferedImage;
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
        }
        if (size == null) {
            size = 60;
        }
        if (point != null) return ImageOpt.createIdIcon((String)userCode, (int)size, (int)point);
        point = 12;
        return ImageOpt.createIdIcon((String)userCode, (int)size, (int)point);
    }
}

