/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.service.impl;

import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.model.basedata.IUserUnit;
import com.centit.im.dao.FriendMemoDao;
import com.centit.im.dao.WebImCustomerDao;
import com.centit.im.dao.WebImGroupDao;
import com.centit.im.dao.WebImGroupMemberDao;
import com.centit.im.po.WebImCustomer;
import com.centit.im.po.WebImFriendMemo;
import com.centit.im.po.WebImGroup;
import com.centit.im.po.WebImGroupMember;
import com.centit.im.po.WebImGroupMemberId;
import com.centit.im.service.WebImSocket;
import com.centit.im.service.WebImUserManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.ListOpt;
import com.centit.support.algorithm.UuidOpt;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="webImUserManager")
public class WebImUserManagerImpl
implements WebImUserManager {
    @Resource
    protected PlatformEnvironment platformEnvironment;
    @Resource
    protected WebImSocket webImSocket;
    @Resource
    protected WebImCustomerDao customerDao;
    @Resource
    protected FriendMemoDao friendMemoDao;
    @Resource
    protected WebImGroupDao webImGroupDao;
    @Resource
    protected WebImGroupMemberDao webImGroupMemberDao;

    @Override
    @Transactional
    public WebImCustomer getUser(String userCode) {
        IUserInfo ui;
        WebImCustomer cust = (WebImCustomer)this.customerDao.getObjectById(userCode);
        if (cust == null && (ui = this.platformEnvironment.getUserInfoByUserCode(userCode)) != null) {
            cust = new WebImCustomer(userCode, ui.getUserName());
            cust.setUserType("U");
            cust.setOsId("WebIM");
        }
        if (cust != null) {
            cust.setUserState(this.webImSocket.checkUserState(userCode));
        }
        return cust;
    }

    @Override
    public int registerUser(WebImCustomer user) {
        WebImCustomer customer = (WebImCustomer)this.customerDao.getObjectById(user.getUserCode());
        if (customer == null) {
            IUserInfo userInfo;
            user.setCreator("U0000000");
            if (StringUtils.isBlank((CharSequence)user.getUserName()) && (userInfo = this.platformEnvironment.getUserInfoByUserCode(user.getUserCode())) != null) {
                user.setUserName(userInfo.getUserName());
            }
            user.setCreateTime(DatetimeOpt.currentUtilDate());
            user.setLastActiveDate(DatetimeOpt.currentUtilDate());
            this.customerDao.saveNewObject(user);
        }
        return 1;
    }

    @Override
    @Transactional
    public List<WebImCustomer> listAllUser() {
        List users = this.platformEnvironment.listAllUsers();
        if (users == null || users.size() < 1) {
            return new ArrayList<WebImCustomer>();
        }
        List custs = this.customerDao.listObjects();
        HashMap<String, WebImCustomer> customerMap = new HashMap<String, WebImCustomer>(custs.size() * 3 / 2 + 1);
        for (WebImCustomer cust : custs) {
            customerMap.put(cust.getUserCode(), cust);
        }
        ArrayList<WebImCustomer> allcusts = new ArrayList<WebImCustomer>(users.size());
        for (IUserInfo user : users) {
            WebImCustomer cust = (WebImCustomer)customerMap.get(user.getUserCode());
            if (cust == null) {
                cust = new WebImCustomer(user.getUserCode(), user.getUserName());
                cust.setUserType("U");
                cust.setOsId("WebIM");
            }
            cust.setUserState(this.webImSocket.checkUserState(cust.getUserCode()));
            allcusts.add(cust);
        }
        return allcusts;
    }

    @Override
    @Transactional
    public List<WebImCustomer> listCustomerService() {
        List<WebImCustomer> allcusts = this.customerDao.listCustomerService();
        if (allcusts == null || allcusts.size() < 1) {
            return allcusts;
        }
        for (WebImCustomer cust : allcusts) {
            cust.setUserState(this.webImSocket.checkUserState(cust.getUserCode()));
        }
        return allcusts;
    }

    @Override
    @Transactional
    public List<WebImCustomer> listServiceCustomer(String serviceUserCode, Date lastServiceDate) {
        List<WebImCustomer> allcusts = this.customerDao.listServiceCustomer(serviceUserCode, lastServiceDate);
        for (WebImCustomer cust : allcusts) {
            cust.setUserState(this.webImSocket.checkUserState(cust.getUserCode()));
        }
        return allcusts;
    }

    @Override
    @Transactional
    public List<WebImCustomer> listAllUnitUser(String unitCode) {
        List users = this.platformEnvironment.listUnitUsers(unitCode);
        ArrayList<WebImCustomer> allcusts = new ArrayList<WebImCustomer>(users.size());
        for (IUserUnit user : users) {
            WebImCustomer cust = (WebImCustomer)this.customerDao.getObjectById(user.getUserCode());
            if (cust == null) {
                IUserInfo ui = this.platformEnvironment.getUserInfoByUserCode(user.getUserCode());
                cust = new WebImCustomer(user.getUserCode(), ui.getUserName());
                cust.setUserType("U");
                cust.setOsId("WebIM");
            }
            cust.setUserState(this.webImSocket.checkUserState(cust.getUserCode()));
            allcusts.add(cust);
        }
        return allcusts;
    }

    @Override
    @Transactional
    public Map<String, String> listAllUserState() {
        List users = this.platformEnvironment.listAllUsers();
        return this.webImSocket.checkUsersState(users);
    }

    @Override
    @Transactional
    public List<? extends IUnitInfo> listAllUnit() {
        return this.platformEnvironment.listAllUnits();
    }

    @Override
    @Transactional
    public List<? extends IUnitInfo> listSubUnit(String parentUnitCode) {
        List allUnits = this.platformEnvironment.listAllUnits();
        ArrayList<IUnitInfo> units = new ArrayList<IUnitInfo>();
        for (IUnitInfo uc : allUnits) {
            if (StringUtils.isBlank((CharSequence)parentUnitCode) || "0".equals(parentUnitCode)) {
                if (!StringUtils.isBlank((CharSequence)uc.getParentUnit()) && !"0".equals(uc.getParentUnit())) continue;
                units.add(uc);
                continue;
            }
            if (!parentUnitCode.equals(uc.getParentUnit())) continue;
            units.add(uc);
        }
        return units;
    }

    @Override
    @Transactional
    public List<IUnitInfo> listUserUnit(String userCode) {
        List units = this.platformEnvironment.listUserUnits(userCode);
        if (units == null || units.size() < 1) {
            return null;
        }
        ArrayList<IUnitInfo> userUnits = new ArrayList<IUnitInfo>(units.size());
        for (IUserUnit unit : units) {
            userUnits.add(this.platformEnvironment.getUnitInfoByUnitCode(unit.getUnitCode()));
        }
        return userUnits;
    }

    @Override
    @Transactional
    public String configUserInfo(String userCode, WebImCustomer cust) {
        WebImCustomer dbWebImCustomer = (WebImCustomer)this.customerDao.getObjectById(userCode);
        dbWebImCustomer.copyNotNullProperty(cust);
        this.customerDao.mergeObject(dbWebImCustomer);
        return userCode;
    }

    @Override
    @Transactional
    public void saveUserFriendMemo(WebImFriendMemo memo) {
        this.friendMemoDao.saveNewObject(memo);
    }

    private void saveMemberToGroup(String groupId, String memberCode) {
        WebImGroupMember member = (WebImGroupMember)this.webImGroupMemberDao.getObjectById(new WebImGroupMemberId(groupId, memberCode));
        if (member != null) {
            return;
        }
        member = new WebImGroupMember(new WebImGroupMemberId(groupId, memberCode), DatetimeOpt.currentUtilDate());
        member.setJoinTime(DatetimeOpt.currentUtilDate());
        member.setOsId("default");
        WebImCustomer customer = (WebImCustomer)this.customerDao.getObjectById(memberCode);
        if (customer == null) {
            customer = new WebImCustomer();
            customer.setCreator("U0000000");
            customer.setUserCode(memberCode);
            customer.setUserName(memberCode);
            IUserInfo userInfo = this.platformEnvironment.getUserInfoByUserCode(memberCode);
            if (userInfo != null) {
                customer.setUserName(userInfo.getUserName());
            }
            customer.setOsId("default");
            customer.setCreateTime(DatetimeOpt.currentUtilDate());
            customer.setLastActiveDate(DatetimeOpt.currentUtilDate());
            this.customerDao.saveNewObject(customer);
        }
        member.setGroupAlias(customer.getUserName());
        this.webImGroupMemberDao.saveNewObject(member);
    }

    @Override
    @Transactional
    public String createGroup(WebImGroup webImGroup) {
        String groupId = webImGroup.getGroupId();
        if (StringUtils.isBlank((CharSequence)groupId)) {
            groupId = UuidOpt.getUuidAsString32();
            webImGroup.setGroupId(groupId);
        }
        this.webImGroupDao.saveNewObject(webImGroup);
        String creator = webImGroup.getCreator();
        if (StringUtils.isNotBlank((CharSequence)creator)) {
            this.saveMemberToGroup(groupId, creator);
        }
        return groupId;
    }

    @Override
    @Transactional
    public String createGroupWithMembers(WebImGroup webImGroup, String[] members) {
        String groupId = this.createGroup(webImGroup);
        if (members != null) {
            for (String memberCode : members) {
                this.saveMemberToGroup(groupId, memberCode);
            }
        }
        return groupId;
    }

    @Override
    @Transactional
    public void updateGroupInfo(WebImGroup webImGroup) {
        if (webImGroup == null) {
            return;
        }
        WebImGroup dbWebImGroup = (WebImGroup)this.webImGroupDao.getObjectById(webImGroup.getGroupId());
        if (dbWebImGroup == null) {
            return;
        }
        dbWebImGroup.copyNotNullProperty(webImGroup);
        this.webImGroupDao.updateObject(dbWebImGroup);
    }

    @Override
    public List<WebImGroupMember> listGroupMembers(String groupId) {
        return this.webImGroupMemberDao.listObjectsByProperty("groupId", groupId);
    }

    @Override
    @Transactional
    public void updateGroupMemberInfo(WebImGroupMember webImGroupMember) {
        WebImGroupMember dbWebImGroupMember = (WebImGroupMember)this.webImGroupMemberDao.getObjectById(webImGroupMember.getCid());
        dbWebImGroupMember.copyNotNullProperty(webImGroupMember);
        this.webImGroupMemberDao.updateObject(dbWebImGroupMember);
    }

    @Override
    @Transactional
    public void addGroupMember(String groupId, String memberCode) {
        this.saveMemberToGroup(groupId, memberCode);
    }

    @Override
    @Transactional
    public void updateGroupMembers(String groupId, String[] members) {
        if (members == null || members.length < 1) {
            return;
        }
        List memberList = ListOpt.arrayToList((Object[])members);
        List dbMembers = this.webImGroupMemberDao.listObjectsByProperty("groupId", groupId);
        if (dbMembers != null && dbMembers.size() > 0) {
            for (WebImGroupMember member : dbMembers) {
                if (memberList.contains(member.getUserCode())) continue;
                this.webImGroupMemberDao.deleteObjectById(member.getCid());
            }
        }
        for (String memberCode : members) {
            this.saveMemberToGroup(groupId, memberCode);
        }
    }

    @Override
    @Transactional
    public void removeGroupMember(String groupId, String userCode) {
        this.webImGroupMemberDao.deleteObjectById(new WebImGroupMemberId(groupId, userCode));
    }

    @Override
    @Transactional
    public int dissolveGroup(String groupId, String userCode, boolean force) {
        WebImGroup dbWebImGroup = (WebImGroup)this.webImGroupDao.getObjectById(groupId);
        if (dbWebImGroup != null && (force || dbWebImGroup.getCreator().equals(userCode))) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("groupId", groupId);
            this.webImGroupMemberDao.deleteObjectsByProperties(map);
            this.webImGroupDao.deleteObjectById(groupId);
            return 1;
        }
        return -1;
    }

    @Override
    public WebImGroup getGroupInfo(String groupId) {
        return (WebImGroup)this.webImGroupDao.getObjectById(groupId);
    }
}

