/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.po;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(name="F_WEB_IM_GROUP")
public class WebImGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="GROUP_ID")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    private String groupId;
    @Column(name="OS_ID")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    private String osId;
    @Column(name="GROUP_TYPE")
    @NotNull
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String groupType;
    @Column(name="GROUP_NAME")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String groupName;
    @Column(name="GROUP_NOTICE")
    @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String groupNotice;
    @Column(name="CREATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String creator;
    @Column(name="CREATE_TIME")
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today")
    private Date createTime;

    public WebImGroup() {
    }

    public WebImGroup(String id, Date createTime) {
        this.groupId = id;
        this.createTime = createTime;
    }

    public String getOsId() {
        return this.osId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupNotice() {
        return this.groupNotice;
    }

    public void setGroupNotice(String groupNotice) {
        this.groupNotice = groupNotice;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public WebImGroup copy(WebImGroup other) {
        this.setOsId(other.getOsId());
        this.setGroupId(other.getGroupId());
        this.setCreator(other.getCreator());
        this.setGroupName(other.getGroupName());
        this.setGroupType(other.getGroupType());
        this.setGroupNotice(other.getGroupNotice());
        this.setCreateTime(other.getCreateTime());
        return this;
    }

    public WebImGroup copyNotNullProperty(WebImGroup other) {
        if (other.getOsId() != null) {
            this.setOsId(other.getOsId());
        }
        if (other.getGroupId() != null) {
            this.setGroupId(other.getGroupId());
        }
        if (other.getCreator() != null) {
            this.setCreator(other.getCreator());
        }
        if (other.getGroupName() != null) {
            this.setGroupName(other.getGroupName());
        }
        if (other.getGroupType() != null) {
            this.setGroupType(other.getGroupType());
        }
        if (other.getGroupNotice() != null) {
            this.setGroupNotice(other.getGroupNotice());
        }
        if (other.getCreateTime() != null) {
            this.setCreateTime(other.getCreateTime());
        }
        return this;
    }

    public WebImGroup clearProperties() {
        return this;
    }

    public static WebImGroup createFromJsonString(String jsonStr) {
        JSONObject jsonObject = JSON.parseObject((String)jsonStr);
        if (jsonObject == null) {
            return null;
        }
        return WebImGroup.createFromJson(jsonObject);
    }

    public static WebImGroup createFromJson(JSONObject jsonObject) {
        WebImGroup imGroup = new WebImGroup();
        imGroup.setGroupId(jsonObject.getString("groupId"));
        imGroup.setOsId(jsonObject.getString("osId"));
        imGroup.setGroupType(jsonObject.getString("groupType"));
        imGroup.setGroupName(jsonObject.getString("groupName"));
        imGroup.setGroupNotice(jsonObject.getString("groupNotice"));
        imGroup.setCreator(jsonObject.getString("creator"));
        imGroup.setCreateTime(DatetimeOpt.castObjectToDate((Object)jsonObject.get((Object)"createTime")));
        return imGroup;
    }
}

