/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.po;

import com.centit.im.po.WebImFriendMemoId;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(name="F_WEB_IM_FRIEND_MEMO")
public class WebImFriendMemo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private WebImFriendMemoId cid;
    @Column(name="OS_ID")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=20, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String osId;
    @Column(name="LAST_UPDATE_TIME")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastUpdateTime;
    @Column(name="FRIEND_ALIAS")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String friendAlias;
    @Column(name="FRIEND_MEMO")
    @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String friendMemo;

    public WebImFriendMemo() {
    }

    public WebImFriendMemo(WebImFriendMemoId id, String osId, Date lastUpdateTime) {
        this.cid = id;
        this.osId = osId;
        this.lastUpdateTime = lastUpdateTime;
    }

    public WebImFriendMemo(WebImFriendMemoId id, String osId, Date lastUpdateTime, String friendAlias, String friendMemo) {
        this.cid = id;
        this.osId = osId;
        this.lastUpdateTime = lastUpdateTime;
        this.friendAlias = friendAlias;
        this.friendMemo = friendMemo;
    }

    public WebImFriendMemoId getCid() {
        return this.cid;
    }

    public void setCid(WebImFriendMemoId id) {
        this.cid = id;
    }

    public String getUserCode() {
        if (this.cid == null) {
            this.cid = new WebImFriendMemoId();
        }
        return this.cid.getUserCode();
    }

    public void setUserCode(String userCode) {
        if (this.cid == null) {
            this.cid = new WebImFriendMemoId();
        }
        this.cid.setUserCode(userCode);
    }

    public String getFriendCode() {
        if (this.cid == null) {
            this.cid = new WebImFriendMemoId();
        }
        return this.cid.getFriendCode();
    }

    public void setFriendCode(String friendCode) {
        if (this.cid == null) {
            this.cid = new WebImFriendMemoId();
        }
        this.cid.setFriendCode(friendCode);
    }

    public String getOsId() {
        return this.osId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getFriendAlias() {
        return this.friendAlias;
    }

    public void setFriendAlias(String friendAlias) {
        this.friendAlias = friendAlias;
    }

    public String getFriendMemo() {
        return this.friendMemo;
    }

    public void setFriendMemo(String friendMemo) {
        this.friendMemo = friendMemo;
    }

    public WebImFriendMemo copy(WebImFriendMemo other) {
        this.setUserCode(other.getUserCode());
        this.setFriendCode(other.getFriendCode());
        this.osId = other.getOsId();
        this.lastUpdateTime = other.getLastUpdateTime();
        this.friendAlias = other.getFriendAlias();
        this.friendMemo = other.getFriendMemo();
        return this;
    }

    public WebImFriendMemo copyNotNullProperty(WebImFriendMemo other) {
        if (other.getUserCode() != null) {
            this.setUserCode(other.getUserCode());
        }
        if (other.getFriendCode() != null) {
            this.setFriendCode(other.getFriendCode());
        }
        if (other.getOsId() != null) {
            this.osId = other.getOsId();
        }
        if (other.getLastUpdateTime() != null) {
            this.lastUpdateTime = other.getLastUpdateTime();
        }
        if (other.getFriendAlias() != null) {
            this.friendAlias = other.getFriendAlias();
        }
        if (other.getFriendMemo() != null) {
            this.friendMemo = other.getFriendMemo();
        }
        return this;
    }

    public WebImFriendMemo clearProperties() {
        this.osId = null;
        this.lastUpdateTime = null;
        this.friendAlias = null;
        this.friendMemo = null;
        return this;
    }
}

