/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.im.po.WebImCustomer;
import com.centit.im.po.WebImFriendMemo;
import com.centit.im.po.WebImGroup;
import com.centit.im.po.WebImGroupMember;
import com.centit.im.service.WebImUserManager;
import com.centit.support.algorithm.ListOpt;
import com.centit.support.algorithm.StringBaseOpt;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/webimcust"})
public class WebImUserController
extends BaseController {
    @Resource
    protected WebImUserManager webImUserManager;

    @RequestMapping(value={"/friend"}, method={RequestMethod.POST})
    public void setFriendMemo(@RequestBody WebImFriendMemo memo, HttpServletResponse response) {
        this.webImUserManager.saveUserFriendMemo(memo);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/register"}, method={RequestMethod.POST})
    public void registerUser(@RequestBody WebImCustomer user, HttpServletResponse response) {
        this.webImUserManager.registerUser(user);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/listUser"}, method={RequestMethod.GET})
    public void listAllUser(HttpServletResponse response) {
        List<WebImCustomer> allCusts = this.webImUserManager.listAllUser();
        JsonResultUtils.writeSingleDataJson(allCusts, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/allUnit"}, method={RequestMethod.GET})
    public void listAllUnits(HttpServletResponse response) {
        List<? extends IUnitInfo> allUnits = this.webImUserManager.listAllUnit();
        ListOpt.sortAsTree(allUnits, (p, c) -> StringUtils.equals((CharSequence)p.getUnitCode(), (CharSequence)c.getParentUnit()));
        JsonResultUtils.writeSingleDataJson(allUnits, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/subUnit/{parentUnitCode}"}, method={RequestMethod.GET})
    public void listSubUnits(@PathVariable String parentUnitCode, HttpServletResponse response) {
        List<? extends IUnitInfo> allUnits = this.webImUserManager.listSubUnit(parentUnitCode);
        Collections.sort(allUnits, Comparator.comparing(IUnitInfo::getUnitOrder));
        JsonResultUtils.writeSingleDataJson(allUnits, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/user/{userCode}"}, method={RequestMethod.GET})
    public void getUser(@PathVariable String userCode, HttpServletResponse response) {
        WebImCustomer cust = this.webImUserManager.getUser(userCode);
        JsonResultUtils.writeSingleDataJson((Object)cust, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/cust/{serviceUserCode}"}, method={RequestMethod.GET})
    public void listServiceCustomer(@PathVariable String serviceUserCode, Date lastServiceDate, HttpServletResponse response) {
        List<WebImCustomer> allcusts = this.webImUserManager.listServiceCustomer(serviceUserCode, lastServiceDate);
        JsonResultUtils.writeSingleDataJson(allcusts, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/services"}, method={RequestMethod.GET})
    public void listCustomerService(HttpServletResponse response) {
        List<WebImCustomer> allcusts = this.webImUserManager.listCustomerService();
        JsonResultUtils.writeSingleDataJson(allcusts, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/listUserState"}, method={RequestMethod.GET})
    public void listAllUserState(HttpServletResponse response) {
        Map<String, String> mapUserState = this.webImUserManager.listAllUserState();
        JsonResultUtils.writeSingleDataJson(mapUserState, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/listUserUnit/{userCode}"}, method={RequestMethod.GET})
    public void listUserUnit(@PathVariable String userCode, HttpServletResponse response) {
        List<IUnitInfo> listUserUnit = this.webImUserManager.listUserUnit(userCode);
        JsonResultUtils.writeSingleDataJson(listUserUnit, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/listUnitUser/{unitCode}"}, method={RequestMethod.GET})
    public void listAllUnitUser(@PathVariable String unitCode, HttpServletResponse response) {
        List<WebImCustomer> listAllUnitUser = this.webImUserManager.listAllUnitUser(unitCode);
        JsonResultUtils.writeSingleDataJson(listAllUnitUser, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/config/{userCode}"}, method={RequestMethod.POST})
    public void setUserConfig(@PathVariable String userCode, @RequestBody WebImCustomer cust, HttpServletResponse response) {
        String useCode = this.webImUserManager.configUserInfo(userCode, cust);
        JsonResultUtils.writeSingleDataJson((Object)useCode, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/creategroup"}, method={RequestMethod.POST})
    public void cresteGroup(@RequestBody String groupJson, HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = JSON.parseObject((String)groupJson);
        WebImGroup webImGroup = WebImGroup.createFromJson(jsonObject);
        String currentUserCode = this.getLoginUserCode(request);
        if (StringUtils.isNotBlank((CharSequence)currentUserCode)) {
            webImGroup.setCreator(currentUserCode);
        }
        webImGroup.setGroupType("G");
        Object members = jsonObject.get((Object)"members");
        String groupId = this.webImUserManager.createGroupWithMembers(webImGroup, (String[])ListOpt.listToArray((Collection)StringBaseOpt.objectToStringList((Object)members)));
        webImGroup.setGroupId(groupId);
        JsonResultUtils.writeSingleDataJson((Object)webImGroup, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/updategroup"}, method={RequestMethod.PUT})
    public void updateGroupInfo(@RequestBody String groupJson, HttpServletResponse response) {
        WebImGroup webImGroup = WebImGroup.createFromJsonString(groupJson);
        this.webImUserManager.updateGroupInfo(webImGroup);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/addgroupmember/{groupId}/{memberCode}"}, method={RequestMethod.PUT})
    public void addGroupMember(@PathVariable String groupId, @PathVariable String memberCode, HttpServletResponse response) {
        this.webImUserManager.addGroupMember(groupId, memberCode);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/updategroupmembers/{groupId}"}, method={RequestMethod.PUT})
    public void updateGroupMembers(@PathVariable String groupId, @RequestBody String membersJsonStr, HttpServletResponse response) {
        JSONArray ja = JSON.parseArray((String)membersJsonStr);
        this.webImUserManager.updateGroupMembers(groupId, (String[])ListOpt.listToArray((Collection)StringBaseOpt.objectToStringList((Object)ja)));
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/listgroupmember/{groupId}"}, method={RequestMethod.GET})
    public void listGroupMembers(@PathVariable String groupId, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson(this.webImUserManager.listGroupMembers(groupId), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/getgroupInfo/{groupId}"}, method={RequestMethod.GET})
    public void getGroupInfo(@PathVariable String groupId, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)this.webImUserManager.getGroupInfo(groupId), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/updatememberinfo"}, method={RequestMethod.PUT})
    public void updateGroupMember(@RequestBody String memberInfoJson, HttpServletResponse response) {
        this.webImUserManager.updateGroupMemberInfo(WebImGroupMember.createFromJson(JSON.parseObject((String)memberInfoJson)));
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/quitgroup/{groupId}/{memberCode}"}, method={RequestMethod.PUT})
    public void removeGroupMember(@PathVariable String groupId, @PathVariable String memberCode, HttpServletResponse response) {
        this.webImUserManager.removeGroupMember(groupId, memberCode);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/dissolvegroup/{groupId}"}, method={RequestMethod.PUT})
    public void dissolveGroup(@PathVariable String groupId, HttpServletRequest request, HttpServletResponse response) {
        int nRres = this.webImUserManager.dissolveGroup(groupId, this.getLoginUserCode(request), false);
        if (nRres > 0) {
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        } else {
            JsonResultUtils.writeMessageJson((String)"\u7fa4\u4e0d\u5b58\u5728\u6216\u8005\u60a8\u4e0d\u662f\u7fa4\u4e3b\u3002", (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/deleteGroup/{groupId}"}, method={RequestMethod.DELETE})
    public void deleteGroup(@PathVariable String groupId, HttpServletRequest request, HttpServletResponse response) {
        int nRres = this.webImUserManager.dissolveGroup(groupId, this.getLoginUserCode(request), true);
        if (nRres > 0) {
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        } else {
            JsonResultUtils.writeMessageJson((String)"\u7fa4\u4e0d\u5b58\u5728\u3002", (HttpServletResponse)response);
        }
    }
}

