/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.socketio;

import com.centit.im.service.WebImSocket;
import javax.annotation.Resource;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.server.standard.SpringConfigurator;

@ServerEndpoint(value="/im/{userCode}", configurator=SpringConfigurator.class)
@Service
public class WebImSocketListener {
    private static Logger logger = LoggerFactory.getLogger(WebImSocketListener.class);
    @Resource
    @Autowired
    protected WebImSocket webImSocket;

    @OnOpen
    public void onOpen(Session session, @PathParam(value="userCode") String userCode) {
        try {
            this.webImSocket.signInUser(userCode, session);
        }
        catch (Exception e) {
            logger.error("onOpen", (Throwable)e);
        }
    }

    @OnClose
    public void onClose(Session session) {
        try {
            this.webImSocket.signOutUser(session);
        }
        catch (Exception e) {
            logger.error("onClose", (Throwable)e);
        }
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        try {
            this.webImSocket.recvMessage(session, message);
        }
        catch (Exception e) {
            logger.error("onMessage" + message, (Throwable)e);
        }
    }

    @OnError
    public void onError(Throwable error) {
        logger.error("onError" + error.getMessage(), error);
    }
}

