/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.socketio;

import com.alibaba.fastjson.JSON;
import com.centit.im.po.RobotAnswer;
import com.centit.im.po.WebImCustomer;
import com.centit.im.socketio.ImMessage;
import com.centit.im.socketio.ImMessageBuild;
import com.centit.support.algorithm.DatetimeOpt;
import org.apache.commons.lang3.StringUtils;

public class ImMessageUtils {
    public static ImMessage fromJSonString(String jsonString) {
        ImMessage msg = (ImMessage)JSON.parseObject((String)jsonString, ImMessage.class);
        if (msg.getSendTime() == null) {
            msg.setSendTime(DatetimeOpt.currentUtilDate());
        }
        return msg;
    }

    public static boolean checkMessage(ImMessage msg) {
        if (StringUtils.isBlank((CharSequence)msg.getType()) || StringUtils.isBlank((CharSequence)msg.getContentType())) {
            return false;
        }
        if (msg.getSendTime() == null) {
            msg.setSendTime(DatetimeOpt.currentUtilDate());
        }
        return true;
    }

    public static ImMessage buildOnlineMessage(String userCode, String userName, String headSculpture) {
        ImMessageBuild msgBuilder = new ImMessageBuild().type("B").contentType("notice").sender(userCode).senderName(userName).addContent("state", "online");
        if (StringUtils.isNotBlank((CharSequence)headSculpture)) {
            msgBuilder.addContent("headSculpture", headSculpture);
        }
        return msgBuilder.build();
    }

    public static ImMessage buildOfflineMessage(String userCode) {
        return new ImMessageBuild().type("B").contentType("notice").sender(userCode).addContent("state", "offline").build();
    }

    public static ImMessage buildOfflineCommand() {
        return new ImMessageBuild().type("S").contentType("offline").sender("system").message("\u540c\u540d\u7528\u6237\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55\uff0c\u60a8\u88ab\u8feb\u4e0b\u7ebf\uff01").build();
    }

    public static ImMessage buildSystemMessage(String sender, String message) {
        return new ImMessageBuild().type("S").contentType("text").sender(sender).senderName("\u7cfb\u7edf\u63d0\u793a").message(message).build();
    }

    public static ImMessage buildSystemMessageChangService(String sender, String message, WebImCustomer cust, WebImCustomer service, String type) {
        return new ImMessageBuild().type("S").contentType("text").sender(sender).senderName("\u7cfb\u7edf\u63d0\u793a").addContent("id", cust.getUserCode()).addContent("custName", cust.getUserName()).addContent("serviceCode", service.getUserCode()).addContent("serviceName", service.getUserName()).addContent("type", type).message(message).build();
    }

    public static ImMessage buildSystemMessagePraise(String message, String senderId) {
        return new ImMessageBuild().type("S").contentType("text").sender("system").senderName("\u7cfb\u7edf\u63d0\u793a").addContent("id", senderId).message(message).build();
    }

    public static ImMessage buildChatMessage(String message, WebImCustomer cust, WebImCustomer service, WebImCustomer beforeChangeService) {
        return new ImMessageBuild().type("C").contentType("text").sender(cust.getUserCode()).senderName(cust.getUserName()).receiver(service.getUserCode()).addContent("chatType", "service").addContent("beforeId", beforeChangeService.getUserCode()).message(message).build();
    }

    public static ImMessage buildSystemMessage(String message) {
        return ImMessageUtils.buildSystemMessage("system", message);
    }

    public static ImMessage buildAcceptCustMessage(String service, WebImCustomer customer) {
        return new ImMessageBuild().type("S").contentType("text").sender(customer.getUserCode()).senderName("\u7cfb\u7edf\u63d0\u793a").message("\u8bf7\u4e3a\u5ba2\u6237 " + customer.getUserName() + " \u670d\u52a1\u3002").addContent("custUserCode", customer.getUserCode()).addContent("custUserName", customer.getUserName()).addContent("custHeadSculpture", customer.getHeadSculpture()).build();
    }

    public static ImMessage buildRobotAnswer(String receiver, RobotAnswer answer) {
        return new ImMessageBuild().type("Q").contentType("text").sender("robot").senderName("\u667a\u80fd\u5ba2\u670d").receiver(receiver).message(answer.getMessage()).addContent("options", answer.getOptions()).build();
    }
}

