/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.socketio;

import com.centit.im.socketio.ImMessage;
import com.centit.support.algorithm.DatetimeOpt;
import java.util.Date;
import java.util.Map;

public class ImMessageBuild {
    private ImMessage msg = new ImMessage();

    public ImMessageBuild() {
        this.msg.setSendTime(DatetimeOpt.currentUtilDate());
    }

    public ImMessageBuild type(String msgType) {
        this.msg.setType(msgType);
        return this;
    }

    public ImMessageBuild broadcast() {
        this.msg.setType("B");
        this.msg.setReceiver("onlineusers");
        return this;
    }

    public ImMessageBuild toAll() {
        this.msg.setType("A");
        this.msg.setReceiver("all");
        return this;
    }

    public ImMessageBuild contentType(String conType) {
        this.msg.setContentType(conType);
        return this;
    }

    public ImMessageBuild content(Map<String, Object> con) {
        this.msg.setContent(con);
        return this;
    }

    public ImMessageBuild addContent(String key, Object con) {
        this.msg.getContent().put(key, con);
        return this;
    }

    public ImMessageBuild sender(String from) {
        this.msg.setSender(from);
        return this;
    }

    public ImMessageBuild senderName(String fromUserName) {
        this.msg.setSenderName(fromUserName);
        return this;
    }

    public ImMessageBuild message(String text) {
        this.msg.getContent().put("msg", text);
        return this;
    }

    public ImMessageBuild file(String fileUrl) {
        this.msg.setContentType("file");
        this.msg.getContent().put("file", fileUrl);
        return this;
    }

    public ImMessageBuild iamge(String iamgeUrl) {
        this.msg.setContentType("image");
        this.msg.getContent().put("file", iamgeUrl);
        return this;
    }

    public ImMessageBuild voice(String voiceUrl) {
        this.msg.setContentType("voice");
        this.msg.getContent().put("file", voiceUrl);
        return this;
    }

    public ImMessageBuild video(String videoUrl) {
        this.msg.setContentType("video");
        this.msg.getContent().put("file", videoUrl);
        return this;
    }

    public ImMessageBuild receiver(String to) {
        this.msg.setReceiver(to);
        return this;
    }

    public ImMessageBuild sendTime(Date sendDatetime) {
        this.msg.setSendTime(sendDatetime);
        return this;
    }

    public ImMessage build() {
        return this.msg;
    }
}

