/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.centit.framework.model.adapter.NotificationCenter;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.model.basedata.IUserUnit;
import com.centit.im.dao.CustomerPraiseDao;
import com.centit.im.dao.WebImCustomerDao;
import com.centit.im.dao.WebImGroupMemberDao;
import com.centit.im.dao.WebImMessageDao;
import com.centit.im.po.RobotAnswer;
import com.centit.im.po.RobotAnswerItem;
import com.centit.im.po.WebImCustomer;
import com.centit.im.po.WebImCustomerPraise;
import com.centit.im.po.WebImMessage;
import com.centit.im.service.IntelligentRobot;
import com.centit.im.service.IntelligentRobotFactory;
import com.centit.im.service.WebImSocket;
import com.centit.im.socketio.ImMessage;
import com.centit.im.socketio.ImMessageBuild;
import com.centit.im.socketio.ImMessageUtils;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import javax.websocket.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebImSocketImpl
implements WebImSocket {
    public static final Log log = LogFactory.getLog(WebImSocketImpl.class);
    private static AtomicInteger onlineCount = new AtomicInteger(0);
    private static ConcurrentHashMap<String, Session> userCodeToSession = new ConcurrentHashMap();
    private static ConcurrentHashMap<Session, WebImCustomer> sessionToUserCode = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, WebImCustomer> onlineCustService = new ConcurrentHashMap();
    @Resource
    protected WebImMessageDao messageDao;
    @Resource
    protected WebImCustomerDao customerDao;
    @Resource
    protected WebImGroupMemberDao webImGroupMemberDao;
    @Resource
    protected CustomerPraiseDao customerPraiseDao;
    @Resource
    protected PlatformEnvironment platformEnvironment;
    @Resource
    protected IntelligentRobotFactory intelligentRobotFactory;
    @Value(value="${notify.type}")
    protected String noticeType;
    @Autowired
    protected NotificationCenter notificationCenter;

    private static Session getSessionByUserCode(String userCode) {
        if (userCode == null) {
            return null;
        }
        return userCodeToSession.get(userCode);
    }

    private static WebImCustomer getUserBySession(Session session) {
        if (session == null) {
            return null;
        }
        return sessionToUserCode.get(session);
    }

    private static String getUserCodeBySession(Session session) {
        if (session == null) {
            return null;
        }
        WebImCustomer cust = sessionToUserCode.get(session);
        if (cust == null) {
            return null;
        }
        return cust.getUserCode();
    }

    private static WebImCustomer getOnlineServiceByUserCode(String userCode) {
        if (userCode == null) {
            return null;
        }
        return onlineCustService.get(userCode);
    }

    @Override
    public void signInUser(String userCode, Session session) {
    }

    private void signOutUser(String userCode, Session session) {
        if (!StringUtils.isBlank((CharSequence)userCode)) {
            onlineCount.decrementAndGet();
            userCodeToSession.remove(userCode);
            sessionToUserCode.remove(session);
            onlineCustService.remove(userCode);
            this.broadcastMessage(ImMessageUtils.buildOfflineMessage(userCode));
        }
    }

    @Override
    public void signOutUser(Session session) {
        WebImCustomer user = WebImSocketImpl.getUserBySession(session);
        if (user != null) {
            this.signOutUser(user.getUserCode(), session);
        }
    }

    private void pushCustomerServiceInfo(Session session, String custUserCode, WebImCustomer service) {
        this.pushMessage(session, new ImMessageBuild().type("M").contentType("service").sender("system").receiver(custUserCode).senderName("\u7cfb\u7edf\u7ba1\u7406\u5458").sendTime(DatetimeOpt.currentUtilDate()).addContent("userCode", service.getUserCode()).addContent("userName", service.getUserName()).addContent("userState", service.getUserState()).addContent("headSculpture", service.getHeadSculpture()).message("\u5ba2\u670d " + service.getUserName() + ("O".equals(service.getUserState()) ? " \u6b63\u5728\u4e3a\u60a8\u670d\u52a1\u3002" : " \u4e3a\u60a8\u670d\u52a1\uff0c\u6682\u65f6\u4e0d\u5728\u7ebf\uff0c\u8bf7\u7559\u8a00\u3002")).build());
    }

    private void registerUser(Session session, ImMessage message) {
        String userCode = message.getSender();
        String osId = message.fetchContentString("osId");
        String userName = message.fetchContentString("userName");
        WebImCustomer cust = (WebImCustomer)this.customerDao.getObjectById(userCode);
        Date currDate = DatetimeOpt.currentUtilDate();
        String headSculpture = message.fetchContentString("headSculpture");
        if (cust != null) {
            cust.setLastActiveDate(currDate);
            if (StringUtils.isNotBlank((CharSequence)userName)) {
                cust.setUserName(userName);
            }
            if (StringUtils.isNotBlank((CharSequence)headSculpture)) {
                cust.setHeadSculpture(headSculpture);
            }
            cust.setUserType(message.fetchContentString("userType"));
            String serviceOpts = message.fetchContentString("serviceOpts");
            if (StringUtils.isNotBlank((CharSequence)serviceOpts)) {
                cust.setServiceOpts(serviceOpts);
            }
            this.customerDao.updateObject(cust);
        } else {
            String custUserCode = message.fetchContentString("userCode");
            cust = new WebImCustomer();
            cust.setUserCode(custUserCode);
            cust.setOsId(osId);
            cust.setUserName(StringUtils.isNotBlank((CharSequence)userName) ? userName : custUserCode);
            if (StringUtils.isNotBlank((CharSequence)headSculpture)) {
                cust.setHeadSculpture(headSculpture);
            }
            cust.setUserType(message.fetchContentString("userType"));
            cust.setCreateTime(currDate);
            cust.setLastActiveDate(currDate);
            cust.setServiceOpts(message.fetchContentString("serviceOpts"));
            cust.setCreator("U0000000");
            this.customerDao.saveNewObject(cust);
        }
        Session oldSession = WebImSocketImpl.getSessionByUserCode(userCode);
        if (oldSession != null) {
            this.pushMessage(oldSession, ImMessageUtils.buildOfflineCommand());
            sessionToUserCode.remove(oldSession);
            try {
                oldSession.close();
            }
            catch (IOException e) {
                log.info((Object)("\u7528\u6237\u591a\u70b9\u767b\u5f55\u5bfc\u81f4session\u5173\u95ed\u5f02\u5e38 :" + e.getMessage()));
            }
        }
        sessionToUserCode.put(session, cust);
        userCodeToSession.put(userCode, session);
        onlineCount.incrementAndGet();
        if ("S".equals(cust.getUserType()) || "P".equals(cust.getUserType())) {
            cust.setUserState("O");
            onlineCustService.put(cust.getUserCode(), cust);
        }
        this.broadcastMessage(ImMessageUtils.buildOnlineMessage(userCode, userName, headSculpture));
    }

    private void askForService(Session session, ImMessage message) {
        List<WebImCustomer> allServices;
        String optId;
        String userCode = message.getSender();
        WebImCustomer cust = (WebImCustomer)this.customerDao.getObjectById(userCode);
        if (cust == null || !"C".equals(cust.getUserType())) {
            return;
        }
        String custServiceCode = message.fetchContentString("customerService");
        WebImCustomer service = null;
        if (StringUtils.isBlank((CharSequence)custServiceCode)) {
            custServiceCode = cust.getCustomerService();
        }
        if (StringUtils.isNotBlank((CharSequence)(optId = message.fetchContentString("optId"))) && (allServices = this.customerDao.listCustomerServiceByOptId(optId)) != null && allServices.size() > 0) {
            ArrayList<WebImCustomer> onlineServices = new ArrayList<WebImCustomer>();
            for (WebImCustomer cs : allServices) {
                if (WebImSocketImpl.getSessionByUserCode(cs.getUserCode()) != null) {
                    onlineServices.add(cs);
                    cs.setUserState("O");
                } else {
                    cs.setUserState("F");
                }
                if (!StringUtils.equals((CharSequence)custServiceCode, (CharSequence)cs.getUserCode())) continue;
                service = cs;
            }
            Random random = new Random();
            if (service != null && "F".equalsIgnoreCase(service.getUserState()) && onlineServices.size() > 0) {
                service = (WebImCustomer)onlineServices.get(random.nextInt(onlineServices.size()));
                service.setUserState("O");
            } else if (service == null) {
                service = allServices.get(random.nextInt(allServices.size()));
                service.setUserState("F");
            }
        }
        if (service == null) {
            List<WebImCustomer> allService;
            if (StringUtils.isNotBlank((CharSequence)custServiceCode)) {
                service = (WebImCustomer)this.customerDao.getObjectById(custServiceCode);
            }
            if (service != null) {
                service.setUserState(this.checkUserState(service.getUserCode()));
            }
            Random random = new Random();
            if ((service == null || "F".equalsIgnoreCase(service.getUserState())) && onlineCustService.size() > 0) {
                String[] keys = new String[onlineCustService.size()];
                keys = ((ConcurrentHashMap.CollectionView)((Object)onlineCustService.keySet())).toArray(keys);
                String randomKey = keys[random.nextInt(keys.length)];
                service = WebImSocketImpl.getOnlineServiceByUserCode(randomKey);
                service.setUserState("O");
            } else if (service == null && (allService = this.customerDao.listCustomerService()) != null && allService.size() > 0) {
                service = allService.get(random.nextInt(allService.size()));
                service.setUserState("F");
            }
        }
        if (service != null) {
            cust.setCustomerService(service.getUserCode());
            this.customerDao.updateObject(cust);
            this.pushCustomerServiceInfo(session, cust.getUserCode(), service);
        } else {
            this.pushMessage(session, ImMessageUtils.buildSystemMessage(message.getReceiver(), "\u7cfb\u7edf\u9519\u8bef\uff1a\u670d\u52a1\u7aef\u6ca1\u6709\u5ba2\u670d\u4eba\u5458\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458"));
        }
    }

    private void setReadState(Session session, ImMessage message) {
        if (StringUtils.isBlank((CharSequence)message.getReceiver()) || "all".equalsIgnoreCase(message.getReceiver())) {
            this.messageDao.updateReadState(message.getSender());
        } else {
            this.messageDao.updateReadState(message.getSender(), message.getReceiver());
        }
    }

    private void setGroupReadState(Session session, ImMessage message) {
        this.webImGroupMemberDao.setGroupReadState(message.getSender(), message.getReceiver());
    }

    private void successChangeCustomerService(Session session, String receiver, WebImCustomer service) {
        WebImCustomer cust;
        Session receiverSession = WebImSocketImpl.getSessionByUserCode(receiver);
        if (receiverSession != null) {
            this.pushCustomerServiceInfo(receiverSession, receiver, service);
        }
        if ((cust = (WebImCustomer)this.customerDao.getObjectById(receiver)) != null) {
            cust.setCustomerService(service.getUserCode());
            this.customerDao.updateObject(cust);
            WebImCustomer beforeChangeService = WebImSocketImpl.getUserBySession(session);
            this.pushMessage(session, ImMessageUtils.buildSystemMessageChangService(receiver, "\u5207\u6362\u5ba2\u670d\u6210\u529f\uff0c\u8bf7\u79bb\u5f00\u672c\u7a97\u53e3\u3002", cust, beforeChangeService, "B"));
            this.pushMessage(service.getUserCode(), ImMessageUtils.buildSystemMessageChangService(receiver, "\u8bf7\u4e3a" + cust.getUserName() + "\u5ba2\u6237\u670d\u52a1\u3002", cust, beforeChangeService, "A"));
            this.saveChangeCustomerService(receiver, beforeChangeService, service);
            this.saveAndSendChangeCustomerCall(service, cust, beforeChangeService);
        }
    }

    public void saveAndSendChangeCustomerCall(WebImCustomer service, WebImCustomer cust, WebImCustomer beforeChangeService) {
        Session session = WebImSocketImpl.getSessionByUserCode(service.getUserCode());
        WebImMessage webMessage = new WebImMessage();
        if (session == null) {
            webMessage.setMsgType("C");
            webMessage.setReceiver(service.getUserCode());
            webMessage.setSender(cust.getUserCode());
            webMessage.setSenderName(cust.getUserName());
            JSONObject json = new JSONObject();
            json.put("msg", (Object)"\u4f60\u597d");
            json.put("chatType", (Object)"service");
            json.put("contentType", (Object)"text");
            json.put("beforeId", (Object)beforeChangeService.getUserCode());
            webMessage.setContent(json.toString());
            webMessage.setSendTime(DatetimeOpt.currentUtilDate());
            webMessage.setMsgState("U");
            webMessage.setMsgId(UuidOpt.getUuidAsString32());
        }
        this.messageDao.saveNewObject(webMessage);
        this.notificationCenter.sendMessage(cust.getUserCode(), service.getUserCode(), "\u5ba2\u670d\u8f6c\u63a5", "\u4f60\u597d", "sms");
    }

    @Transactional
    public void saveChangeCustomerService(String receiver, WebImCustomer beforeChangeService, WebImCustomer afterChangeService) {
        WebImMessage webMessage = new WebImMessage();
        webMessage.setMsgType("S");
        webMessage.setReceiver(receiver);
        webMessage.setSender(beforeChangeService.getUserCode());
        webMessage.setSenderName(beforeChangeService.getUserName());
        JSONObject json = new JSONObject();
        json.put("msg", (Object)(beforeChangeService.getUserName() + "\u5207\u6362\u81f3\u5ba2\u670d" + afterChangeService.getUserName()));
        json.put("contentType", (Object)"text");
        webMessage.setContent(json.toString());
        webMessage.setSendTime(DatetimeOpt.currentUtilDate());
        webMessage.setMsgState("C");
        webMessage.setMsgId(UuidOpt.getUuidAsString32());
        this.messageDao.saveNewObject(webMessage);
    }

    private void changeOnlineCustomerService(Session session, ImMessage message) {
        String serviceUserCode = message.fetchContentString("service");
        WebImCustomer service = WebImSocketImpl.getOnlineServiceByUserCode(serviceUserCode);
        if (service == null) {
            this.pushMessage(session, ImMessageUtils.buildSystemMessage(message.getReceiver(), "\u5207\u6362\u5ba2\u670d\u5931\u8d25\uff0c\u56e0\u4e3a\u60a8\u9009\u62e9\u7684\u5ba2\u670d\u4e0d\u5728\u7ebf\u3002"));
        } else {
            this.successChangeCustomerService(session, message.getReceiver(), service);
        }
    }

    private void changeCustomerService(Session session, ImMessage message) {
        String serviceUserCode = message.fetchContentString("service");
        WebImCustomer service = WebImSocketImpl.getOnlineServiceByUserCode(serviceUserCode);
        if (service == null && (service = (WebImCustomer)this.customerDao.getObjectById(serviceUserCode)) != null) {
            service.setUserState("F");
        }
        if (service == null) {
            this.pushMessage(session, ImMessageUtils.buildSystemMessage(message.getReceiver(), "\u5207\u6362\u5ba2\u670d\u5931\u8d25\uff0c\u6ca1\u6709\u8fd9\u4e2a\u5ba2\u670d\u3002"));
        } else {
            this.successChangeCustomerService(session, message.getReceiver(), service);
            this.notificationCenter.sendMessage(message.getSender(), message.getReceiver(), "\u5ba2\u670d\u8f6c\u63a5", "\u6709\u5ba2\u6237\u5728\u7ebf\u54a8\u8be2\u8f6c\u63a5\u7ed9\u60a8", "sms");
        }
    }

    private void pushForm(Session session, ImMessage message) {
        Session custSession = WebImSocketImpl.getSessionByUserCode(message.getReceiver());
        if (custSession == null) {
            this.pushMessage(session, ImMessageUtils.buildSystemMessagePraise("\u5bf9\u65b9\u5df2\u7ecf\u79bb\u7ebf\uff0c\u65e0\u6cd5\u5bf9\u60a8\u7684\u670d\u52a1\u505a\u51fa\u8bc4\u4ef7\u3002", message.getReceiver()));
        } else {
            this.pushMessage(custSession, message);
            this.pushMessage(session, ImMessageUtils.buildSystemMessagePraise("\u60a8\u7684\u8bc4\u4ef7\u8bf7\u6c42\u5df2\u6210\u529f\u53d1\u7ed9\u5bf9\u65b9\u3002", message.getReceiver()));
        }
    }

    private void saveFormData(Session session, ImMessage message) {
        String fromType = message.fetchContentString("formType");
        if (StringUtils.isBlank((CharSequence)fromType)) {
            return;
        }
        switch (fromType) {
            case "praise": {
                WebImCustomerPraise praise = new WebImCustomerPraise();
                praise.setPraiseId(UuidOpt.getUuidAsString32());
                praise.setCustomerCode(message.getSender());
                praise.setUserCode(message.getReceiver());
                praise.setServiceScore(NumberBaseOpt.parseInteger((String)message.fetchContentString("score"), (Integer)0));
                praise.setCreateTime(DatetimeOpt.currentUtilDate());
                praise.setOsId(message.fetchContentString("osId"));
                praise.setServiceSummary("summary");
                this.customerPraiseDao.saveNewObject(praise);
                this.pushMessage(session, ImMessageUtils.buildSystemMessage("\u60a8\u7684\u8bc4\u4ef7\u5df2\u7ecf\u6210\u529f\u63d0\u4ea4\u3002"));
                this.pushMessage(message.getReceiver(), ImMessageUtils.buildSystemMessagePraise("\u5bf9\u65b9\u5df2\u7ecf\u7ed9\u60a8\u8bc4\u4ef7\u3002", message.getSender()));
                break;
            }
        }
    }

    @Transactional
    public void onCommand(Session session, ImMessage message) {
        switch (message.getContentType()) {
            case "read": {
                this.setReadState(session, message);
                break;
            }
            case "readGroup": {
                this.setGroupReadState(session, message);
                break;
            }
            case "register": {
                this.registerUser(session, message);
                break;
            }
            case "service": {
                this.changeCustomerService(session, message);
                break;
            }
            case "pushForm": {
                this.pushForm(session, message);
                break;
            }
            case "form": {
                this.saveFormData(session, message);
                break;
            }
            case "askForService": {
                this.askForService(session, message);
                break;
            }
            case "askRobot": {
                this.askRobot(session, message);
                break;
            }
            default: {
                this.pushMessage(message.getReceiver(), message);
            }
        }
    }

    private void saveRobotAnswer(String recever, RobotAnswer answer) {
        WebImMessage webMessage = new WebImMessage();
        webMessage.setSenderName("\u667a\u80fd\u5ba2\u670d");
        webMessage.setSender("robot");
        webMessage.setReceiver(recever);
        StringBuilder sbContent = new StringBuilder(answer.getMessage());
        if (answer.getOptions() != null && answer.getOptions().size() > 0) {
            for (RobotAnswerItem item : answer.getOptions()) {
                sbContent.append("\r\n").append(item.getLabel());
            }
        }
        webMessage.setContent(sbContent.toString());
        webMessage.setMsgId(UuidOpt.getUuidAsString32());
        webMessage.setMsgType("C");
        webMessage.setMsgState("C");
        webMessage.setSendTime(DatetimeOpt.currentUtilDate());
        this.messageDao.saveNewObject(webMessage);
    }

    @Transactional
    public void askRobot(Session session, ImMessage message) {
        WebImCustomer cust = WebImSocketImpl.getUserBySession(session);
        if (cust == null) {
            RobotAnswer answer = new RobotAnswer("\u6ca1\u6709\u60a8\u7684\u6ce8\u518c\u4fe1\u606f\uff0c\u8bf7\u5148\u6ce8\u518c:");
            answer.addCommandOption("\u6ce8\u518c", "register");
            this.pushMessage(session, ImMessageUtils.buildRobotAnswer(message.getSender(), answer));
            return;
        }
        IntelligentRobot robot = this.intelligentRobotFactory.getIntelligentRobot(cust.getOsId());
        if (robot == null) {
            RobotAnswer answer = new RobotAnswer("\u7cfb\u7edf\u6ca1\u6709\u8bbe\u7f6e\u673a\u5668\u4eba\u4fe1\u606f\uff0c\u8bf7\u7533\u8bf7\u4eba\u5de5\u670d\u52a1:");
            answer.addCommandOption("\u8f6c\u4eba\u5de5\u670d\u52a1", "askForService");
            this.pushMessage(session, ImMessageUtils.buildRobotAnswer(message.getSender(), answer));
            return;
        }
        if ("M".equalsIgnoreCase(message.getType())) {
            RobotAnswer answer = robot.sayHello(cust.getUserCode());
            ImMessage robotMessage = ImMessageUtils.buildRobotAnswer(message.getSender(), answer);
            this.pushMessage(session, robotMessage);
            this.saveRobotAnswer(message.getSender(), answer);
            return;
        }
        WebImMessage webMessage = new WebImMessage();
        message.getContent().put("contentType", message.getContentType());
        webMessage.copy(message);
        webMessage.setMsgId(UuidOpt.getUuidAsString32());
        webMessage.setMsgType("C");
        webMessage.setMsgState("C");
        webMessage.setReceiver("robot");
        webMessage.setSendTime(DatetimeOpt.currentUtilDate());
        this.messageDao.saveNewObject(webMessage);
        RobotAnswer answer = robot.askQuestion(cust.getUserCode(), message.fetchContentString("question"));
        ImMessage robotMessage = ImMessageUtils.buildRobotAnswer(message.getSender(), answer);
        this.pushMessage(session, robotMessage);
        this.saveRobotAnswer(message.getSender(), answer);
    }

    @Override
    @Transactional
    public void recvMessage(Session session, ImMessage message) {
        switch (message.getType()) {
            case "C": {
                if (StringUtils.isBlank((CharSequence)message.getReceiver())) break;
                this.sendMessage(message.getReceiver(), message);
                break;
            }
            case "Q": {
                this.askRobot(session, message);
                break;
            }
            case "G": {
                this.sendGroupMessage(message.getReceiver(), message);
                break;
            }
            case "B": {
                this.broadcastMessage(message);
                break;
            }
            case "A": {
                this.toallMessage(message);
                break;
            }
            case "M": {
                this.onCommand(session, message);
            }
        }
    }

    @Override
    @Transactional
    public void recvMessage(Session session, String jsonMessage) {
        ImMessage msg = ImMessageUtils.fromJSonString(jsonMessage);
        if (StringUtils.isBlank((CharSequence)msg.getSender())) {
            msg.setSender(WebImSocketImpl.getUserCodeBySession(session));
        }
        this.recvMessage(session, msg);
    }

    private boolean pushMessage(Session session, ImMessage message) {
        if (session == null) {
            return false;
        }
        session.getAsyncRemote().sendText(message.toString());
        return true;
    }

    private boolean pushMessage(String userCode, ImMessage message) {
        Session session = WebImSocketImpl.getSessionByUserCode(userCode);
        return this.pushMessage(session, message);
    }

    @Override
    @Transactional
    public void sendMessage(String userCode, ImMessage message) {
        WebImMessage webMessage = new WebImMessage();
        message.getContent().put("contentType", message.getContentType());
        webMessage.copy(message);
        webMessage.setMsgId(UuidOpt.getUuidAsString32());
        message.setMsgId(webMessage.getMsgId());
        webMessage.setMsgType("C");
        webMessage.setMsgState("U");
        Session session = WebImSocketImpl.getSessionByUserCode(userCode);
        if (session != null) {
            webMessage.setMsgState("C");
            this.pushMessage(session, message);
        } else if (StringUtils.equals((CharSequence)"sms", (CharSequence)this.noticeType)) {
            Map<String, Object> content = message.getContent();
            this.notificationCenter.sendMessage(message.getSender(), message.getReceiver(), "\u79bb\u7ebf\u6d88\u606f", StringBaseOpt.objectToString((Object)content.get("msg")), "sms");
        }
        webMessage.setSendTime(DatetimeOpt.currentUtilDate());
        this.messageDao.saveNewObject(webMessage);
    }

    @Override
    @Transactional
    public void sendGroupMessage(String unitCode, ImMessage message) {
        List users = this.platformEnvironment.listUnitUsers(unitCode);
        for (IUserUnit user : users) {
            this.pushMessage(user.getUserCode(), message);
        }
        message.getContent().put("contentType", message.getContentType());
        WebImMessage webMessage = new WebImMessage();
        webMessage.copy(message);
        webMessage.setMsgId(UuidOpt.getUuidAsString32());
        webMessage.setMsgType("G");
        webMessage.setMsgState("U");
        webMessage.setSendTime(DatetimeOpt.currentUtilDate());
        this.messageDao.saveNewObject(webMessage);
    }

    @Override
    @Transactional
    public void toallMessage(ImMessage message) {
        List users = this.platformEnvironment.listAllUsers();
        for (IUserInfo user : users) {
            this.pushMessage(user.getUserCode(), message);
        }
        message.getContent().put("contentType", message.getContentType());
        WebImMessage webMessage = new WebImMessage();
        webMessage.copy(message);
        webMessage.setMsgId(UuidOpt.getUuidAsString32());
        webMessage.setMsgType("G");
        webMessage.setMsgState("U");
        webMessage.setReceiver("all");
        webMessage.setSendTime(DatetimeOpt.currentUtilDate());
        this.messageDao.saveNewObject(webMessage);
    }

    @Override
    public void broadcastMessage(ImMessage message) {
        for (Session session : sessionToUserCode.keySet()) {
            this.pushMessage(session, message);
        }
    }

    @Override
    public Map<String, String> checkUsersState(List<? extends IUserInfo> users) {
        HashMap<String, String> userState = new HashMap<String, String>();
        if (users == null) {
            return userState;
        }
        for (IUserInfo iUserInfo : users) {
            userState.put(iUserInfo.getUserCode(), WebImSocketImpl.getSessionByUserCode(iUserInfo.getUserCode()) == null ? "F" : "O");
        }
        return userState;
    }

    @Override
    public String checkUserState(String userCode) {
        return WebImSocketImpl.getSessionByUserCode(userCode) == null ? "F" : "O";
    }

    @Override
    public Map<String, String> checkUnitUserState(List<? extends IUserUnit> users) {
        HashMap<String, String> userState = new HashMap<String, String>();
        if (users == null) {
            return userState;
        }
        for (IUserUnit iUserUnit : users) {
            userState.put(iUserUnit.getUserCode(), WebImSocketImpl.getSessionByUserCode(iUserUnit.getUserCode()) == null ? "F" : "O");
        }
        return userState;
    }

    @Override
    public Set<String> getAllOnlineUsers() {
        return userCodeToSession.keySet();
    }
}

