/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import com.centit.im.dao.WebImGroupDao;
import com.centit.im.dao.WebImGroupMemberDao;
import com.centit.im.dao.WebImMessageDao;
import com.centit.im.po.WebImMessage;
import com.centit.im.service.WebImMessageManager;
import com.centit.support.database.utils.PageDesc;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebImMessageManagerImpl
extends BaseEntityManagerImpl<WebImMessage, String, WebImMessageDao>
implements WebImMessageManager {
    @Resource
    private WebImGroupMemberDao webImGroupMemberDao;
    @Resource
    private WebImGroupDao webImGroupDao;
    private WebImMessageDao webImMessageDao;

    @NotNull
    @Resource(name="webImMessageDao")
    public void setWebImMessageDao(WebImMessageDao baseDao) {
        this.webImMessageDao = baseDao;
        this.setBaseDao(this.webImMessageDao);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listChatMessage(String sender, String receiver, Date lastReadDate, PageDesc pageDesc) {
        this.webImMessageDao.updateReadState(sender, receiver);
        return this.webImMessageDao.listChatMessage(sender, receiver, lastReadDate, pageDesc);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listAllChatMessage(String receiver, Date lastReadDate, PageDesc pageDesc) {
        this.webImMessageDao.updateReadState(receiver);
        return this.webImMessageDao.listAllChatMessage(receiver, lastReadDate, pageDesc);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listGroupChatMessage(String receiver, Date lastReadDate, PageDesc pageDesc) {
        return this.webImMessageDao.listGroupChatMessage(receiver, lastReadDate, pageDesc);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listGroupChatMessage(String userCode, String unitCode, Date lastReadDate, PageDesc pageDesc) {
        this.webImGroupMemberDao.setGroupReadState(userCode, unitCode);
        return this.webImMessageDao.listGroupChatMessage(unitCode, lastReadDate, pageDesc);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Integer> statUnreadMessage(String receiver) {
        return this.webImMessageDao.statUnreadMsg(receiver);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Integer> statGroupUnreadMessage(String userCode) {
        return this.webImMessageDao.statGroupUnreadMsg(userCode);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray statUnreadWithLastMsg(String receiver) {
        return this.webImMessageDao.statUnreadWithLastMsg(receiver);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray statGroupUnreadWithLastMsg(String userCode) {
        return this.webImMessageDao.statGroupUnreadWithLastMsg(userCode);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int setReadState(String receiver, String sender) {
        return this.webImMessageDao.updateReadState(sender, receiver);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int setReadState(String userCode) {
        return this.webImMessageDao.updateReadState(userCode);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void setGroupReadState(String userCode, String unitCode) {
        this.webImGroupMemberDao.setGroupReadState(userCode, unitCode);
    }
}

