/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.appclient.AppSession;
import com.centit.im.po.RobotAnswer;
import com.centit.im.service.IntelligentRobot;
import com.centit.support.network.HttpExecutor;
import java.net.URLEncoder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntelligentRobotRpcImpl
implements IntelligentRobot {
    private static Logger log = LoggerFactory.getLogger(IntelligentRobotRpcImpl.class);
    private AppSession appSession;

    public void initAppSession(String appServerUrl, String userCode, String password) {
        this.appSession = new AppSession(appServerUrl, userCode, password);
    }

    public void initAppSession(String appServerUrl) {
        this.appSession = new AppSession(appServerUrl);
    }

    public CloseableHttpClient getHttpClient() throws Exception {
        return this.appSession.getHttpClient();
    }

    public void releaseHttpClient(CloseableHttpClient httpClient) {
        this.appSession.releaseHttpClient(httpClient);
    }

    @Override
    public RobotAnswer sayHello(String custUserCode) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.getHttpClient();
            String jsonStr = HttpExecutor.simpleGet((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/hello/" + custUserCode));
            JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
            RobotAnswer result = (RobotAnswer)JSONObject.toJavaObject((JSON)jsonObj.getJSONObject("data"), RobotAnswer.class);
            this.releaseHttpClient(httpClient);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.releaseHttpClient(httpClient);
            return RobotAnswer.createTestAnswer();
        }
    }

    @Override
    public RobotAnswer sayBoodbye(String custUserCode) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.getHttpClient();
            String jsonStr = HttpExecutor.simpleGet((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/goodbye/" + custUserCode));
            JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
            RobotAnswer result = (RobotAnswer)JSONObject.toJavaObject((JSON)jsonObj.getJSONObject("data"), RobotAnswer.class);
            this.releaseHttpClient(httpClient);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.releaseHttpClient(httpClient);
            return RobotAnswer.createTestAnswer();
        }
    }

    @Override
    public RobotAnswer askQuestion(String custUserCode, String question) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.getHttpClient();
            String jsonStr = HttpExecutor.simpleGet((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/ask/" + custUserCode + "?question=" + URLEncoder.encode(question, "utf-8") + "&userCode" + custUserCode));
            JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
            RobotAnswer result = (RobotAnswer)JSONObject.toJavaObject((JSON)jsonObj.getJSONObject("data"), RobotAnswer.class);
            this.releaseHttpClient(httpClient);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.releaseHttpClient(httpClient);
            return RobotAnswer.createTestAnswer();
        }
    }
}

