/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.po;

import com.alibaba.fastjson.JSON;
import com.centit.im.socketio.ImMessage;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(name="F_WEB_IM_MESSAGE")
public class WebImMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="MSG_ID")
    private String msgId;
    @Column(name="OS_ID")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=20, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String osId;
    @Column(name="MSG_TYPE")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String msgType;
    @Column(name="SENDER")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String sender;
    @Column(name="SENDER_NAME")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String senderName;
    @Column(name="RECEIVER")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String receiver;
    @Column(name="SEND_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date sendTime;
    @Column(name="MSG_STATE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String msgState;
    @Column(name="CONTENT_TYPE")
    @Length(max=20, message="\u5185\u5bb9\u7c7b\u578b\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String contentType;
    @Column(name="CONTENT")
    @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String content;

    public WebImMessage() {
        this.osId = "WebIM";
    }

    public WebImMessage(String msgId, String msgType, String sender, String receiver) {
        this.msgId = msgId;
        this.osId = "WebIM";
        this.msgType = msgType;
        this.sender = sender;
        this.receiver = receiver;
    }

    public WebImMessage(String msgId, String msgType, String sender, String receiver, Date sendTime, String msgState, String content, String senderName) {
        this.msgId = msgId;
        this.osId = "WebIM";
        this.msgType = msgType;
        this.sender = sender;
        this.receiver = receiver;
        this.sendTime = sendTime;
        this.msgState = msgState;
        this.content = content;
        this.senderName = senderName;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getOsId() {
        return this.osId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public String getMsgState() {
        return this.msgState;
    }

    public void setMsgState(String msgState) {
        this.msgState = msgState;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public WebImMessage copy(ImMessage other) {
        this.sender = other.getSender();
        this.receiver = other.getReceiver();
        this.sendTime = other.getSendTime();
        this.senderName = other.getSenderName();
        this.contentType = other.getContentType();
        this.content = JSON.toJSONString(other.getContent());
        this.msgType = other.getType();
        return this;
    }

    public WebImMessage copy(WebImMessage other) {
        this.setMsgId(other.getMsgId());
        this.osId = other.getOsId();
        this.msgType = other.getMsgType();
        this.sender = other.getSender();
        this.receiver = other.getReceiver();
        this.sendTime = other.getSendTime();
        this.msgState = other.getMsgState();
        this.contentType = other.getContentType();
        this.content = other.getContent();
        this.senderName = other.getSenderName();
        return this;
    }

    public WebImMessage copyNotNullProperty(WebImMessage other) {
        if (other.getMsgId() != null) {
            this.setMsgId(other.getMsgId());
        }
        if (other.getOsId() != null) {
            this.osId = other.getOsId();
        }
        if (other.getMsgType() != null) {
            this.msgType = other.getMsgType();
        }
        if (other.getSender() != null) {
            this.sender = other.getSender();
        }
        if (other.getReceiver() != null) {
            this.receiver = other.getReceiver();
        }
        if (other.getSendTime() != null) {
            this.sendTime = other.getSendTime();
        }
        if (other.getMsgState() != null) {
            this.msgState = other.getMsgState();
        }
        if (other.getContentType() != null) {
            this.contentType = other.getContentType();
        }
        if (other.getContent() != null) {
            this.content = other.getContent();
        }
        if (other.getSenderName() != null) {
            this.senderName = other.getSenderName();
        }
        return this;
    }

    public WebImMessage clearProperties() {
        this.osId = null;
        this.msgType = null;
        this.sender = null;
        this.receiver = null;
        this.sendTime = null;
        this.msgState = null;
        this.contentType = null;
        this.content = null;
        this.senderName = null;
        return this;
    }
}

