/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.po;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.im.po.WebImGroupMemberId;
import com.centit.support.algorithm.DatetimeOpt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(name="F_WEB_IM_GROUP_MEMBER")
public class WebImGroupMember
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private WebImGroupMemberId cid;
    @Column(name="OS_ID")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    private String osId;
    @Column(name="GROUP_ALIAS")
    private String groupAlias;
    @Column(name="GROUP_MEMO")
    private String groupMemo;
    @Column(name="LAST_PUSH_TIME")
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastPushTime;
    @Column(name="JOIN_TIME")
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date joinTime;

    public WebImGroupMember() {
    }

    public WebImGroupMember(WebImGroupMemberId id, Date lastPushTime) {
        this.cid = id;
        this.lastPushTime = lastPushTime;
    }

    public WebImGroupMemberId getCid() {
        return this.cid;
    }

    public void setCid(WebImGroupMemberId id) {
        this.cid = id;
    }

    public String getOsId() {
        return this.osId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public String getUserCode() {
        if (this.cid == null) {
            this.cid = new WebImGroupMemberId();
        }
        return this.cid.getUserCode();
    }

    public void setUserCode(String userCode) {
        if (this.cid == null) {
            this.cid = new WebImGroupMemberId();
        }
        this.cid.setUserCode(userCode);
    }

    public String getGroupId() {
        if (this.cid == null) {
            this.cid = new WebImGroupMemberId();
        }
        return this.cid.getGroupId();
    }

    public void setGroupId(String unitCode) {
        if (this.cid == null) {
            this.cid = new WebImGroupMemberId();
        }
        this.cid.setGroupId(unitCode);
    }

    public String getGroupAlias() {
        return this.groupAlias;
    }

    public void setGroupAlias(String groupAlias) {
        this.groupAlias = groupAlias;
    }

    public String getGroupMemo() {
        return this.groupMemo;
    }

    public void setGroupMemo(String groupMemo) {
        this.groupMemo = groupMemo;
    }

    public Date getJoinTime() {
        return this.joinTime;
    }

    public void setJoinTime(Date joinTime) {
        this.joinTime = joinTime;
    }

    public Date getLastPushTime() {
        return this.lastPushTime;
    }

    public void setLastPushTime(Date lastPushTime) {
        this.lastPushTime = lastPushTime;
    }

    public WebImGroupMember copy(WebImGroupMember other) {
        this.setOsId(other.getOsId());
        this.setUserCode(other.getUserCode());
        this.setGroupId(other.getGroupId());
        this.setGroupAlias(other.getGroupAlias());
        this.setGroupMemo(other.getGroupMemo());
        this.setJoinTime(other.getJoinTime());
        this.lastPushTime = other.getLastPushTime();
        return this;
    }

    public WebImGroupMember copyNotNullProperty(WebImGroupMember other) {
        if (other.getOsId() != null) {
            this.setOsId(other.getOsId());
        }
        if (other.getUserCode() != null) {
            this.setUserCode(other.getUserCode());
        }
        if (other.getGroupId() != null) {
            this.setGroupId(other.getGroupId());
        }
        if (other.getGroupAlias() != null) {
            this.setGroupAlias(other.getGroupAlias());
        }
        if (other.getGroupMemo() != null) {
            this.setGroupMemo(other.getGroupMemo());
        }
        if (other.getJoinTime() != null) {
            this.setJoinTime(other.getJoinTime());
        }
        if (other.getLastPushTime() != null) {
            this.lastPushTime = other.getLastPushTime();
        }
        return this;
    }

    public WebImGroupMember clearProperties() {
        this.lastPushTime = null;
        return this;
    }

    public static WebImGroupMember createFromJson(JSONObject jo) {
        WebImGroupMember webImGroupMember = new WebImGroupMember();
        webImGroupMember.setOsId(jo.getString("osId"));
        webImGroupMember.setGroupId(jo.getString("groupId"));
        webImGroupMember.setUserCode(jo.getString("userCode"));
        webImGroupMember.setGroupAlias(jo.getString("groupAlias"));
        webImGroupMember.setGroupMemo(jo.getString("groupMemo"));
        webImGroupMember.setJoinTime(DatetimeOpt.castObjectToDate((Object)jo.get((Object)"joinTime")));
        webImGroupMember.setLastPushTime(DatetimeOpt.castObjectToDate((Object)jo.get((Object)"lastPushTime")));
        return webImGroupMember;
    }

    public static List<WebImGroupMember> createFromJsonArray(JSONArray ja) {
        if (ja == null || ja.size() < 1) {
            return null;
        }
        ArrayList<WebImGroupMember> members = new ArrayList<WebImGroupMember>(ja.size());
        for (Object obj : ja) {
            members.add(WebImGroupMember.createFromJson((JSONObject)obj));
        }
        return members;
    }
}

