/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.po;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(name="F_WEB_IM_CUSTOMER_PRAISE")
public class WebImCustomerPraise
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="PRAISE_ID")
    private String praiseId;
    @Column(name="OS_ID")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=20, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String osId;
    @Column(name="USER_CODE")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String userCode;
    @Column(name="CUSTOMER_CODE")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String customerCode;
    @Column(name="SERVICE_SUMMARY")
    @Length(max=200, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String serviceSummary;
    @Column(name="SERVICE_SCORE")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    private int serviceScore;
    @Column(name="CREATE_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createTime;

    public WebImCustomerPraise() {
    }

    public WebImCustomerPraise(String praiseId, String osId, String customerCode, int serviceScore) {
        this.praiseId = praiseId;
        this.osId = osId;
        this.customerCode = customerCode;
        this.serviceScore = serviceScore;
    }

    public WebImCustomerPraise(String praiseId, String osId, String userCode, String customerCode, String serviceSummary, int serviceScore, Date createTime) {
        this.praiseId = praiseId;
        this.osId = osId;
        this.userCode = userCode;
        this.customerCode = customerCode;
        this.serviceSummary = serviceSummary;
        this.serviceScore = serviceScore;
        this.createTime = createTime;
    }

    public String getPraiseId() {
        return this.praiseId;
    }

    public void setPraiseId(String praiseId) {
        this.praiseId = praiseId;
    }

    public String getOsId() {
        return this.osId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getServiceSummary() {
        return this.serviceSummary;
    }

    public void setServiceSummary(String serviceSummary) {
        this.serviceSummary = serviceSummary;
    }

    public int getServiceScore() {
        return this.serviceScore;
    }

    public void setServiceScore(int serviceScore) {
        this.serviceScore = serviceScore;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public WebImCustomerPraise copy(WebImCustomerPraise other) {
        this.setPraiseId(other.getPraiseId());
        this.osId = other.getOsId();
        this.userCode = other.getUserCode();
        this.customerCode = other.getCustomerCode();
        this.serviceSummary = other.getServiceSummary();
        this.serviceScore = other.getServiceScore();
        this.createTime = other.getCreateTime();
        return this;
    }

    public WebImCustomerPraise copyNotNullProperty(WebImCustomerPraise other) {
        if (other.getPraiseId() != null) {
            this.setPraiseId(other.getPraiseId());
        }
        if (other.getOsId() != null) {
            this.osId = other.getOsId();
        }
        if (other.getUserCode() != null) {
            this.userCode = other.getUserCode();
        }
        if (other.getCustomerCode() != null) {
            this.customerCode = other.getCustomerCode();
        }
        if (other.getServiceSummary() != null) {
            this.serviceSummary = other.getServiceSummary();
        }
        if (other.getServiceScore() != -1) {
            this.serviceScore = other.getServiceScore();
        }
        if (other.getCreateTime() != null) {
            this.createTime = other.getCreateTime();
        }
        return this;
    }

    public WebImCustomerPraise clearProperties() {
        this.osId = null;
        this.userCode = null;
        this.customerCode = null;
        this.serviceSummary = null;
        this.serviceScore = -1;
        this.createTime = null;
        return this;
    }
}

