/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.po;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(name="F_WEB_IM_CUSTOMER")
public class WebImCustomer
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="USER_CODE")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    private String userCode;
    @Column(name="OS_ID")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    private String osId;
    @Column(name="USER_TYPE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String userType;
    @Column(name="USER_NAME")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String userName;
    @Column(name="HEAD_SCULPTURE")
    @Length(max=200, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String headSculpture;
    @Column(name="SERVICE_OPTS")
    @Length(max=1000, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String serviceOpts;
    @Column(name="CUSTOMER_SERVICE")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String customerService;
    @Column(name="LAST_ACTIVE_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastActiveDate;
    @Column(name="CREATOR")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private String creator;
    @Column(name="CREATE_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createTime;
    @Transient
    private String userState;

    public WebImCustomer() {
    }

    public WebImCustomer(String userCode, String userName) {
        this.userCode = userCode;
        this.userName = userName;
    }

    public WebImCustomer(String userCode, String osId, String userType, String userName, String headSculpture, String customerService, Date lastActiveDate, String creator, Date createTime) {
        this.userCode = userCode;
        this.osId = osId;
        this.userType = userType;
        this.userName = userName;
        this.headSculpture = headSculpture;
        this.customerService = customerService;
        this.lastActiveDate = lastActiveDate;
        this.creator = creator;
        this.createTime = createTime;
    }

    public String getOsId() {
        return this.osId;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(String customerService) {
        this.customerService = customerService;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getHeadSculpture() {
        return this.headSculpture;
    }

    public void setHeadSculpture(String headSculpture) {
        this.headSculpture = headSculpture;
    }

    public Date getLastActiveDate() {
        return this.lastActiveDate;
    }

    public void setLastActiveDate(Date lastActiveDate) {
        this.lastActiveDate = lastActiveDate;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getServiceOpts() {
        return this.serviceOpts;
    }

    public void setServiceOpts(String serviceOpts) {
        this.serviceOpts = serviceOpts;
    }

    public String getUserState() {
        if (this.userState == null) {
            return "F";
        }
        return this.userState;
    }

    public void setUserState(String userState) {
        this.userState = userState;
    }

    public WebImCustomer copy(WebImCustomer other) {
        this.setOsId(other.getOsId());
        this.setUserCode(other.getUserCode());
        this.userName = other.getUserName();
        this.customerService = other.getCustomerService();
        this.creator = other.getCreator();
        this.createTime = other.getCreateTime();
        this.userType = other.getUserType();
        this.headSculpture = other.getHeadSculpture();
        this.lastActiveDate = other.getLastActiveDate();
        this.serviceOpts = other.getServiceOpts();
        return this;
    }

    public WebImCustomer copyNotNullProperty(WebImCustomer other) {
        if (other.getOsId() != null) {
            this.setOsId(other.getOsId());
        }
        if (other.getUserCode() != null) {
            this.setUserCode(other.getUserCode());
        }
        if (other.getUserName() != null) {
            this.userName = other.getUserName();
        }
        if (other.getCustomerService() != null) {
            this.customerService = other.getCustomerService();
        }
        if (other.getCreator() != null) {
            this.creator = other.getCreator();
        }
        if (other.getCreateTime() != null) {
            this.createTime = other.getCreateTime();
        }
        if (other.getUserType() != null) {
            this.userType = other.getUserType();
        }
        if (other.getHeadSculpture() != null) {
            this.headSculpture = other.getHeadSculpture();
        }
        if (other.getLastActiveDate() != null) {
            this.lastActiveDate = other.getLastActiveDate();
        }
        if (other.getServiceOpts() != null) {
            this.serviceOpts = other.getServiceOpts();
        }
        return this;
    }

    public WebImCustomer clearProperties() {
        this.userName = null;
        this.customerService = null;
        this.creator = null;
        this.createTime = null;
        this.userType = null;
        this.headSculpture = null;
        this.lastActiveDate = null;
        this.serviceOpts = null;
        return this;
    }
}

