/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.im.po.WebImMessage;
import com.centit.im.service.WebImMessageManager;
import com.centit.im.service.WebImSocket;
import com.centit.im.socketio.ImMessage;
import com.centit.im.socketio.ImMessageUtils;
import com.centit.support.database.utils.PageDesc;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/webim"})
public class WebImController
extends BaseController {
    @Resource
    protected WebImMessageManager webImMessageManager;
    @Resource
    protected WebImSocket webImSocket;

    public static JSONArray messgeListToJson(JSONArray messageList) {
        if (CollectionUtils.isEmpty((Collection)messageList)) {
            return messageList;
        }
        for (Object obj : messageList) {
            JSONObject jsonObject = (JSONObject)obj;
            JSONObject jsonContent = (JSONObject)JSON.parse((String)jsonObject.getString("content"));
            jsonObject.put("content", (Object)jsonContent);
            jsonObject.put("contentType", jsonContent.get((Object)"contentType"));
        }
        return messageList;
    }

    public static JSONArray messgeListToJson(List<WebImMessage> messageList) {
        if (CollectionUtils.isEmpty(messageList)) {
            return null;
        }
        return WebImController.messgeListToJson((JSONArray)JSON.toJSON(messageList));
    }

    @RequestMapping(value={"/historyMessage/{receiver}/{sender}"}, method={RequestMethod.GET})
    public void listUserHistoryMessage(@PathVariable String receiver, @PathVariable String sender, PageDesc pageDesc, Date lastReadDate, HttpServletResponse response) {
        JSONArray listObjects = this.webImMessageManager.listChatMessage(sender, receiver, lastReadDate, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)WebImController.messgeListToJson(listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/allHistoryMessage/{receiver}"}, method={RequestMethod.GET})
    public void listAllHistoryMessage(@PathVariable String receiver, PageDesc pageDesc, Date lastReadDate, HttpServletResponse response) {
        JSONArray listObjects = this.webImMessageManager.listAllChatMessage(receiver, lastReadDate, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)WebImController.messgeListToJson(listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/groupHistoryMessage/{receiver}"}, method={RequestMethod.GET})
    public void listGroupHistoryMessage(@PathVariable String receiver, PageDesc pageDesc, Date lastReadDate, HttpServletResponse response) {
        JSONArray listObjects = this.webImMessageManager.listGroupChatMessage(receiver, lastReadDate, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)WebImController.messgeListToJson(listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/groupHistoryMessage/{userCode}/{unitCode}"}, method={RequestMethod.GET})
    public void listUserGroupHistoryMessage(@PathVariable String userCode, @PathVariable String unitCode, PageDesc pageDesc, Date lastReadDate, HttpServletResponse response) {
        JSONArray listObjects = this.webImMessageManager.listGroupChatMessage(userCode, unitCode, lastReadDate, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)WebImController.messgeListToJson(listObjects));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/statUnread/{userCode}"}, method={RequestMethod.GET})
    public void statUnreadMessage(@PathVariable String userCode, HttpServletResponse response) {
        Map<String, Integer> unreadSum = this.webImMessageManager.statUnreadMessage(userCode);
        JsonResultUtils.writeSingleDataJson(unreadSum, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/statGroupUnread/{userCode}"}, method={RequestMethod.GET})
    public void statGroupUnreadMessage(@PathVariable String userCode, HttpServletResponse response) {
        Map<String, Integer> unreadSum = this.webImMessageManager.statGroupUnreadMessage(userCode);
        JsonResultUtils.writeSingleDataJson(unreadSum, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/getUnreadLastMsg/{userCode}"}, method={RequestMethod.GET})
    public void statUnreadWithLastMsg(@PathVariable String userCode, HttpServletResponse response) {
        JSONArray unreadSum = this.webImMessageManager.statUnreadWithLastMsg(userCode);
        JsonResultUtils.writeSingleDataJson((Object)WebImController.messgeListToJson(unreadSum), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/getGroupUnreadLastMsg/{userCode}"}, method={RequestMethod.GET})
    public void statGroupUnreadeWithLastMsg(@PathVariable String userCode, HttpServletResponse response) {
        JSONArray unreadSum = this.webImMessageManager.statGroupUnreadWithLastMsg(userCode);
        JsonResultUtils.writeSingleDataJson((Object)WebImController.messgeListToJson(unreadSum), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/setReadState/{receiver}/{sender}"}, method={RequestMethod.POST})
    public void setReadState(@PathVariable String receiver, @PathVariable String sender, HttpServletResponse response) {
        int ret = this.webImMessageManager.setReadState(receiver, sender);
        JsonResultUtils.writeSingleDataJson((Object)ret, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/setGroupReadState/{receiver}/{unitCode}"}, method={RequestMethod.POST})
    public void setGroupReadState(@PathVariable String receiver, @PathVariable String unitCode, HttpServletResponse response) {
        this.webImMessageManager.setGroupReadState(receiver, unitCode);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/sendMessage/{receiver}/{sender}"}, method={RequestMethod.POST})
    public void sendMessage(@PathVariable String receiver, @PathVariable String sender, @RequestBody ImMessage message, HttpServletResponse response) {
        message.setReceiver(receiver);
        message.setSender(sender);
        ImMessageUtils.checkMessage(message);
        this.webImSocket.sendMessage(receiver, message);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/sendUnitMessage/{receiver}/{sender}"}, method={RequestMethod.POST})
    public void sendGroupMessage(@PathVariable String receiver, @PathVariable String sender, @RequestBody ImMessage message, HttpServletResponse response) {
        message.setReceiver(receiver);
        message.setSender(sender);
        ImMessageUtils.checkMessage(message);
        this.webImSocket.sendGroupMessage(receiver, message);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/toall/{sender}"}, method={RequestMethod.POST})
    public void toallMessage(@PathVariable String sender, @RequestBody ImMessage message, HttpServletResponse response) {
        message.setSender(sender);
        ImMessageUtils.checkMessage(message);
        this.webImSocket.toallMessage(message);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/broadcast/{sender}"}, method={RequestMethod.POST})
    public void broadcastMessage(@PathVariable String sender, @RequestBody ImMessage message, HttpServletResponse response) {
        message.setSender(sender);
        ImMessageUtils.checkMessage(message);
        this.webImSocket.broadcastMessage(message);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }
}

