/*
 * Decompiled with CFR 0.152.
 */
package com.centit.im.client;

import com.centit.framework.appclient.AppSession;
import com.centit.framework.common.ObjectException;
import com.centit.framework.common.ResponseJSON;
import com.centit.im.client.IMClient;
import com.centit.im.client.MessageSenderIMImpl;
import com.centit.im.po.FriendMemo;
import com.centit.im.po.ImMessage;
import com.centit.im.po.WebImCustomer;
import com.centit.support.network.HttpExecutor;
import java.io.IOException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMClientImpl
implements IMClient {
    private static Logger log = LoggerFactory.getLogger(MessageSenderIMImpl.class);
    private AppSession appSession;

    public void initAppSession(String appServerUrl, String userCode, String password) {
        this.appSession = new AppSession(appServerUrl, false, userCode, password);
    }

    public CloseableHttpClient getHttpClient() throws Exception {
        return this.appSession.getHttpClient();
    }

    public void releaseHttpClient(CloseableHttpClient httpClient) {
        this.appSession.releaseHttpClient(httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFriendMemo(FriendMemo memo) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.getHttpClient();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.appSession.checkAccessToken(httpClient);
            String jsonStr = HttpExecutor.jsonPost((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/webimcust/friend"), (Object)memo);
            ResponseJSON resJson = ResponseJSON.valueOfJson((String)jsonStr);
            if (resJson.getCode() != 0) {
                throw new ObjectException((Object)memo, resJson.getMessage());
            }
        }
        catch (ClientProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseHttpClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUser(WebImCustomer user) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.getHttpClient();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.appSession.checkAccessToken(httpClient);
            String jsonStr = HttpExecutor.jsonPost((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/webimcust/register"), (Object)user);
            ResponseJSON resJson = ResponseJSON.valueOfJson((String)jsonStr);
            if (resJson.getCode() != 0) {
                throw new ObjectException((Object)user, resJson.getMessage());
            }
        }
        catch (ClientProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseHttpClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserConfig(WebImCustomer cust) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.getHttpClient();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.appSession.checkAccessToken(httpClient);
            String jsonStr = HttpExecutor.jsonPost((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/webimcust/config/" + cust.getUserCode()), (Object)cust);
            ResponseJSON resJson = ResponseJSON.valueOfJson((String)jsonStr);
            if (resJson.getCode() != 0) {
                throw new ObjectException((Object)cust, resJson.getMessage());
            }
        }
        catch (ClientProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseHttpClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(ImMessage message) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.getHttpClient();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.appSession.checkAccessToken(httpClient);
            String jsonStr = HttpExecutor.jsonPost((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/webim/sendMessage/" + message.getReceiver() + "/" + message.getSender()), (Object)message);
            ResponseJSON resJson = ResponseJSON.valueOfJson((String)jsonStr);
            if (resJson.getCode() != 0) {
                throw new ObjectException((Object)message, resJson.getMessage());
            }
        }
        catch (ClientProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.releaseHttpClient(httpClient);
        }
    }
}

