/*
 * Decompiled with CFR 0.152.
 */
package com.centit.task.service.impl;

import com.centit.support.database.utils.PageDesc;
import com.centit.task.dao.TaskLogDao;
import com.centit.task.po.TaskLog;
import com.centit.task.service.TaskInfoService;
import com.centit.task.service.TaskLogService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskLogServiceImpl
implements TaskLogService {
    private static final Logger log = LoggerFactory.getLogger(TaskLogServiceImpl.class);
    @Autowired
    private TaskLogDao TaskLogDao;
    @Autowired
    private TaskInfoService taskInfoService;

    @Override
    @Transactional
    public List<TaskLog> listTaskLogs(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.TaskLogDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public TaskLog getTaskLogByCode(String logId) {
        return (TaskLog)this.TaskLogDao.getObjectById(logId);
    }

    @Override
    @Transactional
    public void saveTaskLog(TaskLog TaskLog2) {
        this.TaskLogDao.mergeObject(TaskLog2);
        if (0L != TaskLog2.getWorkload() && !"M".equals(TaskLog2.getLogType())) {
            this.taskInfoService.incrementWorkload(TaskLog2.getWorkload(), TaskLog2.getTaskId());
        }
    }

    @Override
    @Transactional
    public void deleteTaskLogByCode(String logId) {
        this.TaskLogDao.deleteObjectById(logId);
    }
}

