/*
 * Decompiled with CFR 0.152.
 */
package com.centit.task.service.impl;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.task.dao.TaskInfoDao;
import com.centit.task.dao.TaskLogDao;
import com.centit.task.po.TaskInfo;
import com.centit.task.po.TaskLog;
import com.centit.task.service.TaskInfoService;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskInfoServiceImpl
implements TaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoServiceImpl.class);
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private TaskLogDao taskLogDao;
    private final String TASK_STATE_TEMPLATE = "%s\u66f4\u6539\u4efb\u52a1\u72b6\u6001\u4e3a%s";
    private final String TASK_TRANSFER_TEMPLATE = "%s\u628a\u4efb\u52a1\u5206\u914d\u7ed9%s";

    @Override
    @Transactional
    public List<TaskInfo> listTaskInfos(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.taskInfoDao.listObjects(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public TaskInfo getTaskInfoByCode(String taskId) {
        return (TaskInfo)this.taskInfoDao.getObjectById(taskId);
    }

    @Override
    @Transactional
    public void saveTaskInfo(TaskInfo taskInfo) {
        taskInfo.setWorkload(0L);
        this.taskInfoDao.mergeObject(taskInfo);
    }

    @Override
    @Transactional
    public void deleteTaskInfoByCode(String taskId) {
        TaskInfo dbTaskInfo = (TaskInfo)this.taskInfoDao.getObjectById(taskId);
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (!dbTaskInfo.getTaskReporter().equals(userCode)) {
            throw new ObjectException("\u53ea\u6709\u4efb\u52a1\u62a5\u544a\u4eba\u624d\u80fd\u5220\u9664\u4efb\u52a1");
        }
        this.taskInfoDao.deleteObjectById(taskId);
    }

    @Override
    @Transactional
    public void updateTaskInfo(TaskInfo taskInfo) {
        TaskInfo dbTaskInfo = (TaskInfo)this.taskInfoDao.getObjectById(taskInfo.getTaskId());
        if (null == dbTaskInfo) {
            throw new ObjectException("\u4efb\u52a1\u4e0d\u5b58\u5728!");
        }
        this.taskInfoDao.updateObject(taskInfo);
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String currentUserName = WebOptUtils.getCurrentUserName((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)currentUserName)) {
            throw new ObjectException("\u60a8\u672a\u767b\u5f55!");
        }
        if (this.isChange(taskInfo::getTaskState, dbTaskInfo.getTaskState())) {
            this.updateMemoTaskLog(taskInfo, String.format("%s\u66f4\u6539\u4efb\u52a1\u72b6\u6001\u4e3a%s", currentUserName, taskInfo.getTaskStateDes()));
        }
        if (this.isChange(taskInfo::getTaskOfficer, dbTaskInfo.getTaskOfficer())) {
            String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
            IUserInfo userInfo = CodeRepositoryUtil.getUserInfoByCode((String)topUnit, (String)taskInfo.getTaskOfficer());
            if (null == userInfo) {
                throw new ObjectException(taskInfo.getTaskOfficer() + " \u7528\u6237\u4e0d\u5b58\u5728!");
            }
            this.updateMemoTaskLog(taskInfo, String.format("%s\u628a\u4efb\u52a1\u5206\u914d\u7ed9%s", currentUserName, userInfo.getUserName()));
        }
    }

    @Override
    public void incrementWorkload(long increament, String taskId) {
        this.taskInfoDao.incrementWorkload(increament, taskId);
    }

    private boolean isChange(Supplier<String> supplier, String oldValue) {
        return StringUtils.isNotBlank((CharSequence)supplier.get()) && !supplier.get().equals(oldValue);
    }

    private void updateMemoTaskLog(TaskInfo taskInfo, String logContent) {
        TaskLog taskLog = new TaskLog();
        taskLog.setTaskId(taskInfo.getTaskId());
        taskLog.setLogType("M");
        taskLog.setUserCode(taskInfo.getUserCode());
        taskLog.setWorkload(0L);
        taskLog.setLogContent(logContent);
        this.taskLogDao.saveNewObject(taskLog);
    }
}

