/*
 * Decompiled with CFR 0.152.
 */
package com.centit.task.po;

import com.centit.framework.core.dao.DictionaryMap;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="F_TASK_INFO")
public class TaskInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="TASK_ID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u4efb\u52a1\u7f16\u53f7")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String taskId;
    @Column(name="TASK_TITLE")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u4efb\u52a1\u6807\u9898")
    private @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String taskTitle;
    @Column(name="TASK_CONTENT")
    @Length(max=2048, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u4efb\u52a1\u5185\u5bb9")
    private @Length(max=2048, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String taskContent;
    @Column(name="TASK_OFFICER")
    @DictionaryMap(value={"userCode"}, fieldName={"officerName"})
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u4efb\u52a1\u5206\u914d\u4eba")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String taskOfficer;
    @Column(name="TASK_REPORTER")
    @DictionaryMap(value={"userCode"}, fieldName={"reporterName"})
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u4efb\u52a1\u62a5\u544a\u4eba")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String taskReporter;
    @Column(name="ASSIGN_TIME")
    @ApiModelProperty(value="\u5206\u914d\u65f6\u95f4")
    private Date assignTime;
    @Column(name="WORKLOAD")
    @ApiModelProperty(value="\u5de5\u4f5c\u5b9e\u9645\u4f7f\u7528\u65f6\u95f4\uff0c\u5355\u4f4d\u5206\u949f")
    private Long workload;
    @Column(name="ESTIMATE_WORKLOAD")
    @ApiModelProperty(value="\u8bc4\u4f30 \u5de5\u4f5c\u91cf\uff0c\u5355\u4f4d\u5206\u949f")
    private Long estimateWorkload;
    @Column(name="DEADLINE_TIME")
    @ApiModelProperty(value="\u6700\u540e\u671f\u9650")
    private Date deadlineTime;
    @Column(name="UNIT_CODE")
    @DictionaryMap(value={"unitCode"}, fieldName={"unitName"})
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u64cd\u4f5c\u673a\u6784")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String unitCode;
    @Column(name="USER_CODE")
    @DictionaryMap(value={"userCode"}, fieldName={"userName"})
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u64cd\u4f5c\u7528\u6237")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String userCode;
    @Column(name="OS_ID")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u4e1a\u52a1\u7cfb\u7edfid:\u7b49\u540c\u4e8eAPPLICATION_ID,\u5bf9\u5e94\u5e94\u7528\u7cfb\u7edf\uff0c\u6bd4\u5982\u5de5\u4f5c\u6d41\u5f15\u64ceworkflow\u3001\u8003\u52e4\u7cfb\u7edfid")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String osId;
    @Column(name="OPT_ID")
    @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u529f\u80fd\u6a21\u5757:\u5bf9\u5e94\u5de5\u4f5c\u6d41\u4e2d\u7684\u6d41\u7a0b\u4ee3\u7801\uff0c\u8003\u52e4\u7cfb\u7edf\u4e2d\u7684\u529f\u80fd")
    private @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optId;
    @Column(name="OPT_METHOD")
    @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u64cd\u4f5c\u65b9\u6cd5:\u5bf9\u5e94\u5de5\u4f5c\u6d41\u4e2d\u7684\u8282\u70b9")
    private @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optMethod;
    @Column(name="TASK_STATE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u4efb\u52a1\u72b6\u6001 A:\u672a\u5f00\u59cb B:\u5904\u7406\u4e2d C:\u5df2\u5b8c\u6210 D:\u5df2\u5173\u95ed")
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String taskState;
    @Column(name="TASK_CLASS")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u4efb\u52a1\u7c7b\u522b A:\u4efb\u52a1 B:\u95ee\u9898")
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String taskClass;
    @Column(name="TASK_PRIORITY")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u4f18\u5148\u7ea7 A:\u7ec6\u5fae B:\u6b21\u8981 C:\u4e00\u822c D:\u4e25\u91cd E:\u81f4\u547d")
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String taskPriority;

    public String getTaskStateDes() {
        if (StringUtils.isBlank((CharSequence)this.taskState)) {
            return "";
        }
        String taskStateDesc = "";
        switch (this.taskState) {
            case "A": {
                taskStateDesc = "\u672a\u5f00\u59cb";
                break;
            }
            case "B": {
                taskStateDesc = "\u5904\u7406\u4e2d";
                break;
            }
            case "C": {
                taskStateDesc = "\u5df2\u5b8c\u6210";
                break;
            }
            case "D": {
                taskStateDesc = "\u5df2\u5173\u95ed";
            }
        }
        return taskStateDesc;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskTitle() {
        return this.taskTitle;
    }

    public String getTaskContent() {
        return this.taskContent;
    }

    public String getTaskOfficer() {
        return this.taskOfficer;
    }

    public String getTaskReporter() {
        return this.taskReporter;
    }

    public Date getAssignTime() {
        return this.assignTime;
    }

    public Long getWorkload() {
        return this.workload;
    }

    public Long getEstimateWorkload() {
        return this.estimateWorkload;
    }

    public Date getDeadlineTime() {
        return this.deadlineTime;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getOsId() {
        return this.osId;
    }

    public String getOptId() {
        return this.optId;
    }

    public String getOptMethod() {
        return this.optMethod;
    }

    public String getTaskState() {
        return this.taskState;
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public String getTaskPriority() {
        return this.taskPriority;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setTaskTitle(String taskTitle) {
        this.taskTitle = taskTitle;
    }

    public void setTaskContent(String taskContent) {
        this.taskContent = taskContent;
    }

    public void setTaskOfficer(String taskOfficer) {
        this.taskOfficer = taskOfficer;
    }

    public void setTaskReporter(String taskReporter) {
        this.taskReporter = taskReporter;
    }

    public void setAssignTime(Date assignTime) {
        this.assignTime = assignTime;
    }

    public void setWorkload(Long workload) {
        this.workload = workload;
    }

    public void setEstimateWorkload(Long estimateWorkload) {
        this.estimateWorkload = estimateWorkload;
    }

    public void setDeadlineTime(Date deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public void setOptId(String optId) {
        this.optId = optId;
    }

    public void setOptMethod(String optMethod) {
        this.optMethod = optMethod;
    }

    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }

    public void setTaskClass(String taskClass) {
        this.taskClass = taskClass;
    }

    public void setTaskPriority(String taskPriority) {
        this.taskPriority = taskPriority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskInfo)) {
            return false;
        }
        TaskInfo other = (TaskInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$taskTitle = this.getTaskTitle();
        String other$taskTitle = other.getTaskTitle();
        if (this$taskTitle == null ? other$taskTitle != null : !this$taskTitle.equals(other$taskTitle)) {
            return false;
        }
        String this$taskContent = this.getTaskContent();
        String other$taskContent = other.getTaskContent();
        if (this$taskContent == null ? other$taskContent != null : !this$taskContent.equals(other$taskContent)) {
            return false;
        }
        String this$taskOfficer = this.getTaskOfficer();
        String other$taskOfficer = other.getTaskOfficer();
        if (this$taskOfficer == null ? other$taskOfficer != null : !this$taskOfficer.equals(other$taskOfficer)) {
            return false;
        }
        String this$taskReporter = this.getTaskReporter();
        String other$taskReporter = other.getTaskReporter();
        if (this$taskReporter == null ? other$taskReporter != null : !this$taskReporter.equals(other$taskReporter)) {
            return false;
        }
        Date this$assignTime = this.getAssignTime();
        Date other$assignTime = other.getAssignTime();
        if (this$assignTime == null ? other$assignTime != null : !((Object)this$assignTime).equals(other$assignTime)) {
            return false;
        }
        Long this$workload = this.getWorkload();
        Long other$workload = other.getWorkload();
        if (this$workload == null ? other$workload != null : !((Object)this$workload).equals(other$workload)) {
            return false;
        }
        Long this$estimateWorkload = this.getEstimateWorkload();
        Long other$estimateWorkload = other.getEstimateWorkload();
        if (this$estimateWorkload == null ? other$estimateWorkload != null : !((Object)this$estimateWorkload).equals(other$estimateWorkload)) {
            return false;
        }
        Date this$deadlineTime = this.getDeadlineTime();
        Date other$deadlineTime = other.getDeadlineTime();
        if (this$deadlineTime == null ? other$deadlineTime != null : !((Object)this$deadlineTime).equals(other$deadlineTime)) {
            return false;
        }
        String this$unitCode = this.getUnitCode();
        String other$unitCode = other.getUnitCode();
        if (this$unitCode == null ? other$unitCode != null : !this$unitCode.equals(other$unitCode)) {
            return false;
        }
        String this$userCode = this.getUserCode();
        String other$userCode = other.getUserCode();
        if (this$userCode == null ? other$userCode != null : !this$userCode.equals(other$userCode)) {
            return false;
        }
        String this$osId = this.getOsId();
        String other$osId = other.getOsId();
        if (this$osId == null ? other$osId != null : !this$osId.equals(other$osId)) {
            return false;
        }
        String this$optId = this.getOptId();
        String other$optId = other.getOptId();
        if (this$optId == null ? other$optId != null : !this$optId.equals(other$optId)) {
            return false;
        }
        String this$optMethod = this.getOptMethod();
        String other$optMethod = other.getOptMethod();
        if (this$optMethod == null ? other$optMethod != null : !this$optMethod.equals(other$optMethod)) {
            return false;
        }
        String this$taskState = this.getTaskState();
        String other$taskState = other.getTaskState();
        if (this$taskState == null ? other$taskState != null : !this$taskState.equals(other$taskState)) {
            return false;
        }
        String this$taskClass = this.getTaskClass();
        String other$taskClass = other.getTaskClass();
        if (this$taskClass == null ? other$taskClass != null : !this$taskClass.equals(other$taskClass)) {
            return false;
        }
        String this$taskPriority = this.getTaskPriority();
        String other$taskPriority = other.getTaskPriority();
        return !(this$taskPriority == null ? other$taskPriority != null : !this$taskPriority.equals(other$taskPriority));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $taskTitle = this.getTaskTitle();
        result = result * 59 + ($taskTitle == null ? 43 : $taskTitle.hashCode());
        String $taskContent = this.getTaskContent();
        result = result * 59 + ($taskContent == null ? 43 : $taskContent.hashCode());
        String $taskOfficer = this.getTaskOfficer();
        result = result * 59 + ($taskOfficer == null ? 43 : $taskOfficer.hashCode());
        String $taskReporter = this.getTaskReporter();
        result = result * 59 + ($taskReporter == null ? 43 : $taskReporter.hashCode());
        Date $assignTime = this.getAssignTime();
        result = result * 59 + ($assignTime == null ? 43 : ((Object)$assignTime).hashCode());
        Long $workload = this.getWorkload();
        result = result * 59 + ($workload == null ? 43 : ((Object)$workload).hashCode());
        Long $estimateWorkload = this.getEstimateWorkload();
        result = result * 59 + ($estimateWorkload == null ? 43 : ((Object)$estimateWorkload).hashCode());
        Date $deadlineTime = this.getDeadlineTime();
        result = result * 59 + ($deadlineTime == null ? 43 : ((Object)$deadlineTime).hashCode());
        String $unitCode = this.getUnitCode();
        result = result * 59 + ($unitCode == null ? 43 : $unitCode.hashCode());
        String $userCode = this.getUserCode();
        result = result * 59 + ($userCode == null ? 43 : $userCode.hashCode());
        String $osId = this.getOsId();
        result = result * 59 + ($osId == null ? 43 : $osId.hashCode());
        String $optId = this.getOptId();
        result = result * 59 + ($optId == null ? 43 : $optId.hashCode());
        String $optMethod = this.getOptMethod();
        result = result * 59 + ($optMethod == null ? 43 : $optMethod.hashCode());
        String $taskState = this.getTaskState();
        result = result * 59 + ($taskState == null ? 43 : $taskState.hashCode());
        String $taskClass = this.getTaskClass();
        result = result * 59 + ($taskClass == null ? 43 : $taskClass.hashCode());
        String $taskPriority = this.getTaskPriority();
        result = result * 59 + ($taskPriority == null ? 43 : $taskPriority.hashCode());
        return result;
    }

    public String toString() {
        return "TaskInfo(taskId=" + this.getTaskId() + ", taskTitle=" + this.getTaskTitle() + ", taskContent=" + this.getTaskContent() + ", taskOfficer=" + this.getTaskOfficer() + ", taskReporter=" + this.getTaskReporter() + ", assignTime=" + this.getAssignTime() + ", workload=" + this.getWorkload() + ", estimateWorkload=" + this.getEstimateWorkload() + ", deadlineTime=" + this.getDeadlineTime() + ", unitCode=" + this.getUnitCode() + ", userCode=" + this.getUserCode() + ", osId=" + this.getOsId() + ", optId=" + this.getOptId() + ", optMethod=" + this.getOptMethod() + ", taskState=" + this.getTaskState() + ", taskClass=" + this.getTaskClass() + ", taskPriority=" + this.getTaskPriority() + ")";
    }
}

