/*
 * Decompiled with CFR 0.152.
 */
package com.centit.task.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.common.WorkTimeSpan;
import com.centit.support.database.utils.PageDesc;
import com.centit.task.po.TaskInfo;
import com.centit.task.service.TaskInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Api(value="\u4efb\u52a1\u4fe1\u606f", tags={"\u4efb\u52a1\u4fe1\u606f\u63a5\u53e3\u7c7b"})
@RequestMapping(value={"/general/task"})
public class TaskInfoController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoController.class);
    @Autowired
    private TaskInfoService taskInfoService;

    @ApiOperation(value="\u4efb\u52a1\u4fe1\u606f\u5217\u8868", notes="\u4efb\u52a1\u4fe1\u606f\u5217\u8868")
    @WrapUpResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public PageQueryResult listAllTaskInfo(PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        List<TaskInfo> listObjects = this.taskInfoService.listTaskInfos(filterMap, pageDesc);
        List maps = JSONArray.parseArray((String)JSON.toJSONString(listObjects), Map.class);
        for (Map map : maps) {
            WorkTimeSpan workTimeSpan = new WorkTimeSpan();
            workTimeSpan.fromNumberAsMinute(MapUtils.getLong((Map)map, (Object)"workload", (Long)0L).longValue());
            map.put("workloadMinute", workTimeSpan.toStringAsMinute());
            workTimeSpan.fromNumberAsMinute(MapUtils.getLong((Map)map, (Object)"estimateWorkload", (Long)0L).longValue());
            map.put("estimateWorkload", workTimeSpan.toStringAsMinute());
        }
        return PageQueryResult.createResultMapDict((Collection)maps, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u4efb\u52a1\u4fe1\u606f", notes="\u67e5\u8be2\u5355\u4e2a\u4efb\u52a1\u4fe1\u606f")
    @WrapUpResponseBody
    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.GET})
    public TaskInfo getTaskInfoByCode(@PathVariable String taskId) {
        return this.taskInfoService.getTaskInfoByCode(taskId);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4efb\u52a1\u4fe1\u606f", notes="\u4fdd\u5b58\u4efb\u52a1\u4fe1\u606f")
    @WrapUpResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public TaskInfo saveTaskInfo(@RequestBody TaskInfo taskInfo) {
        this.taskInfoService.saveTaskInfo(taskInfo);
        return taskInfo;
    }

    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u4fe1\u606f", notes="\u4fee\u6539\u4efb\u52a1\u4fe1\u606f,\u540c\u65f6\u4f1a\u6dfb\u52a0\u5907\u6ce8\u4fe1\u606f")
    @WrapUpResponseBody
    @RequestMapping(method={RequestMethod.PUT})
    public ResponseData updateTaskInfo(@RequestBody TaskInfo taskInfo) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{taskInfo.getTaskId()})) {
            return ResponseData.makeErrorMessage((String)"taskId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.taskInfoService.updateTaskInfo(taskInfo);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u4fe1\u606f", notes="\u5220\u9664\u4efb\u52a1\u4fe1\u606f")
    @WrapUpResponseBody
    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.DELETE})
    public void deleteFlowRoleByCode(@PathVariable String taskId) {
        this.taskInfoService.deleteTaskInfoByCode(taskId);
    }
}

