/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.dao.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.dde.adapter.dao.CallApiLogDao;
import com.centit.dde.adapter.po.CallApiLog;
import com.centit.dde.adapter.po.CallApiLogDetail;
import com.centit.dde.adapter.po.CallApiLogDetails;
import com.centit.search.document.ESDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="callApiLogDao")
public class CallApiLogDaoImpl
implements CallApiLogDao {
    private static final Logger logger = LoggerFactory.getLogger(CallApiLogDaoImpl.class);
    private final ESIndexer callApiLogIndexer;
    private final ESSearcher callApiLogSearcher;
    private final ESIndexer callApiLogDetailIndexer;
    private final ESSearcher callApiLogDetailSearcher;
    private final ESServerConfig esServerConfig;

    @Autowired
    public CallApiLogDaoImpl(@Autowired ESServerConfig esServerConfig) {
        this.esServerConfig = esServerConfig;
        this.callApiLogIndexer = IndexerSearcherFactory.obtainIndexer((ESServerConfig)esServerConfig, CallApiLog.class);
        this.callApiLogSearcher = IndexerSearcherFactory.obtainSearcher((ESServerConfig)esServerConfig, CallApiLog.class);
        this.callApiLogDetailIndexer = IndexerSearcherFactory.obtainIndexer((ESServerConfig)esServerConfig, CallApiLogDetails.class);
        this.callApiLogDetailSearcher = IndexerSearcherFactory.obtainSearcher((ESServerConfig)esServerConfig, CallApiLogDetails.class);
    }

    public void saveLog(CallApiLog callApiLog) {
        this.callApiLogIndexer.saveNewDocument((ESDocument)callApiLog);
    }

    public void saveLogDetails(CallApiLog callApiLog) {
        CallApiLogDetails details = new CallApiLogDetails();
        details.setLogId(callApiLog.getLogId());
        details.setTaskId(callApiLog.getTaskId());
        details.setRunBeginTime(callApiLog.getRunBeginTime());
        int logDetailCount = callApiLog.getDetailLogs().size();
        if (logDetailCount > 100) {
            int i;
            ArrayList detailLogs = new ArrayList();
            for (i = 0; i < 10; ++i) {
                detailLogs.add(callApiLog.getDetailLogs().get(i));
            }
            detailLogs.add(callApiLog.getDetailLogs().get(0));
            for (i = 90; i >= 1; --i) {
                detailLogs.add(callApiLog.getDetailLogs().get(logDetailCount - i));
            }
            details.setDetailLogs(detailLogs);
        } else {
            details.setDetailLogs(callApiLog.getDetailLogs());
        }
        this.callApiLogDetailIndexer.saveNewDocument((ESDocument)details);
    }

    public CallApiLog getLog(String logId) {
        JSONObject object = this.callApiLogSearcher.getDocumentById("logId", logId);
        if (object == null) {
            return null;
        }
        return (CallApiLog)object.toJavaObject(CallApiLog.class, new JSONReader.Feature[0]);
    }

    public List<CallApiLogDetail> listLogDetails(String logId) {
        JSONObject object = this.callApiLogDetailSearcher.getDocumentById("logId", logId);
        if (object == null) {
            return null;
        }
        return JSONArray.parseArray((String)object.getString("detailLogs"), CallApiLogDetail.class);
    }

    public CallApiLog getLogWithDetail(String logId) {
        CallApiLog callLog = this.getLog(logId);
        if (callLog == null) {
            return null;
        }
        callLog.setDetailLogs(this.listLogDetails(logId));
        return callLog;
    }

    public void deleteLogById(String logId) {
    }

    public List<Map<String, Object>> listLogsByProperties(Map<String, Object> param, PageDesc pageDesc) {
        Pair queryOut = this.callApiLogSearcher.search(param, null, pageDesc.getPageNo(), pageDesc.getPageSize());
        pageDesc.setTotalRows(Integer.valueOf(((Long)queryOut.getLeft()).intValue()));
        List objectList = (List)queryOut.getRight();
        if (objectList == null) {
            return null;
        }
        for (Map obj : objectList) {
            obj.put("runBeginTime", DatetimeOpt.smartPraseDate((String)((String)obj.get("runBeginTime"))));
            obj.put("runEndTime", DatetimeOpt.smartPraseDate((String)((String)obj.get("runEndTime"))));
        }
        return objectList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray statApiCallSum(String statType, String typeId, Date startDate, Date endDate) {
        String dateFormate;
        long intervals;
        SearchRequest searchRequest = new SearchRequest(new String[]{"callapilog"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if ("topUnit".equalsIgnoreCase(statType)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"topUnit", (String)typeId));
        } else if ("application".equalsIgnoreCase(statType)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"applicationId", (String)typeId));
        } else if ("opt".equalsIgnoreCase(statType)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"optId", (String)typeId));
        } else {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"taskId", (String)typeId));
        }
        RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"runBeginTime").gte((Object)startDate).lte((Object)endDate);
        boolQuery.must((QueryBuilder)rangeQuery);
        sourceBuilder.query((QueryBuilder)boolQuery);
        if (DatetimeOpt.calcSpanDays((Date)startDate, (Date)endDate) >= 5) {
            intervals = 86400000L;
            dateFormate = "yyyy-MM-dd";
        } else {
            intervals = 3600000L;
            dateFormate = "yyyy-MM-dd HH:mm:ss";
        }
        DateHistogramAggregationBuilder dateHistogramAggregation = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"hourly").field("runBeginTime")).interval(intervals).format(dateFormate)).timeZone(ZoneId.systemDefault());
        SumAggregationBuilder errorPiecesSum = (SumAggregationBuilder)AggregationBuilders.sum((String)"errorPiecesSum").field("errorPieces");
        SumAggregationBuilder successPiecesSum = (SumAggregationBuilder)AggregationBuilders.sum((String)"successPiecesSum").field("successPieces");
        dateHistogramAggregation.subAggregation((AggregationBuilder)errorPiecesSum);
        dateHistogramAggregation.subAggregation((AggregationBuilder)successPiecesSum);
        sourceBuilder.aggregation((AggregationBuilder)dateHistogramAggregation);
        searchRequest.source(sourceBuilder);
        JSONArray result = new JSONArray();
        RestHighLevelClient client = null;
        try {
            client = this.callApiLogSearcher.fetchClient();
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            Histogram hourlyHistogram = (Histogram)searchResponse.getAggregations().get("hourly");
            for (Histogram.Bucket hourlyBucket : hourlyHistogram.getBuckets()) {
                String keyAsString = hourlyBucket.getKeyAsString();
                ParsedSum errorPiecesValue = (ParsedSum)hourlyBucket.getAggregations().get("errorPiecesSum");
                ParsedSum successPiecesValue = (ParsedSum)hourlyBucket.getAggregations().get("successPiecesSum");
                JSONObject sums = new JSONObject();
                sums.put((Object)"runBeginTime", (Object)keyAsString);
                sums.put((Object)"errorPieces", (Object)errorPiecesValue.getValue());
                sums.put((Object)"successPieces", (Object)successPiecesValue.getValue());
                result.add((Object)sums);
            }
        }
        catch (IOException | ElasticsearchException e) {
            logger.error("Error occurred while processing statType: {} param: {}, start date: {}, end date: {}", new Object[]{statType, typeId, startDate, endDate, e});
        }
        finally {
            this.callApiLogSearcher.releaseClient(client);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray statCallSumByOs(String osId, Date startDate, Date endDate) {
        SearchRequest searchRequest = new SearchRequest(new String[]{"callapilog"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"applicationId", (String)osId));
        RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"runBeginTime").gte((Object)startDate).lte((Object)endDate);
        boolQuery.must((QueryBuilder)rangeQuery);
        sourceBuilder.query((QueryBuilder)boolQuery);
        DateHistogramAggregationBuilder dateHistogramAggregation = (DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"daily").field("runBeginTime")).interval(86400000L).format("yyyy-MM-dd")).timeZone(ZoneId.systemDefault());
        sourceBuilder.aggregation((AggregationBuilder)dateHistogramAggregation);
        searchRequest.source(sourceBuilder);
        JSONArray result = new JSONArray();
        RestHighLevelClient client = null;
        try {
            client = this.callApiLogSearcher.fetchClient();
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            Histogram dailyHistogram = (Histogram)searchResponse.getAggregations().get("daily");
            for (Histogram.Bucket dailyBucket : dailyHistogram.getBuckets()) {
                String keyAsString = dailyBucket.getKeyAsString();
                long docCount = dailyBucket.getDocCount();
                JSONObject sums = new JSONObject();
                sums.put((Object)"runBeginTime", (Object)keyAsString);
                sums.put((Object)"callSum", (Object)docCount);
                result.add((Object)sums);
            }
        }
        catch (IOException | ElasticsearchException e) {
            logger.error("Error occurred while processing application: {}, start date: {}, end date: {}", new Object[]{osId, startDate, endDate, e});
        }
        finally {
            this.callApiLogSearcher.releaseClient(client);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray statTopTask(String osId, String countType, int topSize, Date startDate, Date endDate) {
        SearchRequest searchRequest = new SearchRequest(new String[]{"callapilog"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"applicationId", (String)osId));
        if ("failed".equalsIgnoreCase(countType)) {
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"errorPieces").gt((Object)0));
        }
        RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"runBeginTime").gte((Object)startDate).lte((Object)endDate);
        boolQuery.must((QueryBuilder)rangeQuery);
        sourceBuilder.query((QueryBuilder)boolQuery);
        TermsAggregationBuilder termsAggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"top_task_ids").field("taskId")).size(topSize).order(BucketOrder.count((boolean)false));
        sourceBuilder.aggregation((AggregationBuilder)termsAggregation);
        JSONArray result = new JSONArray();
        searchRequest.source(sourceBuilder);
        RestHighLevelClient client = null;
        try {
            client = this.callApiLogSearcher.fetchClient();
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            ParsedTerms topTaskIds = (ParsedTerms)searchResponse.getAggregations().get("top_task_ids");
            for (Terms.Bucket bucket : topTaskIds.getBuckets()) {
                String keyAsString = bucket.getKeyAsString();
                long docCount = bucket.getDocCount();
                result.add((Object)CollectionsOpt.createHashMap((Object[])new Object[]{"taskId", keyAsString, "callSum", docCount}));
            }
        }
        catch (IOException | ElasticsearchException e) {
            logger.error("Error occurred while processing application: {}, countType: {}, start date: {}, end date: {}", new Object[]{osId, countType, startDate, endDate, e});
        }
        finally {
            this.callApiLogSearcher.releaseClient(client);
        }
        return result;
    }
}

