/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.dao.impl;

import com.alibaba.fastjson2.JSONArray;
import com.centit.dde.adapter.dao.TaskLogDao;
import com.centit.dde.adapter.po.TaskLog;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository(value="ddeTaskLogDao")
public class TaskLogDaoImpl
extends BaseDaoImpl<TaskLog, Long>
implements TaskLogDao {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>(10);
        filterField.put("logId", "EQUAL");
        filterField.put("taskId", "EQUAL");
        filterField.put("runBeginTime", "runBeginTime>=?");
        filterField.put("runBeginTime2", "runBeginTime<=?");
        filterField.put("runEndTime", "LIKE");
        filterField.put("runType", "EQUAL");
        filterField.put("runner", "LIKE");
        filterField.put("otherMessage", "LIKE");
        filterField.put("successPieces", "LIKE");
        filterField.put("errorPieces", "LIKE");
        return filterField;
    }

    public Map<String, Object> getLogStatisticsInfo(Map<String, Object> queryparameter) {
        String sql = "SELECT DATE_FORMAT(run_begin_time, '%H') AS time,  count(*) AS num  FROM  d_task_log dtl  WHERE to_days(run_begin_time) = to_days(now())  [:optId | AND OPT_ID=:optId]  [:packetId | AND task_id=:packetId]  GROUP BY time ";
        QueryAndNamedParams params = QueryUtils.translateQuery((String)sql, queryparameter);
        JSONArray dataList = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)params.getQuery(), (Map)params.getParams());
        String pieSql = " SELECT 'day' as time, other_message as message,count(*) as num FROM d_task_log  where to_days(run_begin_time) = to_days(now())  and other_message is not NULL  [:packetId | AND task_id=:packetId ]  [:optId | AND OPT_ID=:optId]  GROUP BY other_message  UNION ALL SELECT 'weeks' as time, other_message as message,count(*) as num FROM d_task_log  where DATE_SUB(CURDATE(), INTERVAL 7 DAY) <= date(run_begin_time)  and other_message is not NULL   [:packetId | AND task_id=:packetId ]  [:optId | AND OPT_ID=:optId]  GROUP BY other_message UNION ALL SELECT 'month' as time, other_message as message, count(*) as num FROM d_task_log  where DATE_SUB(CURDATE(), INTERVAL 30 DAY) <= date(run_begin_time)  and other_message is not NULL  [:packetId | AND task_id=:packetId ]  [:optId | AND OPT_ID=:optId]  GROUP BY other_message";
        QueryAndNamedParams pieData = QueryUtils.translateQuery((String)pieSql, queryparameter);
        JSONArray pieDataList = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)pieData.getQuery(), (Map)pieData.getParams());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("brokenLineData", dataList);
        hashMap.put("pieData", pieDataList);
        return hashMap;
    }

    public int deleteTaskLog(String packetId, Date runBeginTime, boolean isError) {
        StringBuilder sql = new StringBuilder("delete from d_task_log  where task_id = ? AND run_begin_time <= ? ");
        if (!isError) {
            sql.append(" AND (error_pieces is null or error_pieces = 0) ");
        }
        return DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)sql.toString(), (Object[])new Object[]{packetId, runBeginTime});
    }
}

