/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.dao.impl;

import com.alibaba.fastjson2.JSONArray;
import com.centit.dde.adapter.dao.DataPacketDraftDao;
import com.centit.dde.adapter.po.DataPacketDraft;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.stereotype.Repository;

@Repository(value="dataPacketDraftDao")
public class DataPacketDraftDaoImpl
extends BaseDaoImpl<DataPacketDraft, String>
implements DataPacketDraftDao {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("(like)packetName", "(packet_name like :packetName or packet_id like :packetName)");
        filterField.put("osId", "EQUAL");
        filterField.put("optId", "EQUAL");
        filterField.put("isDisable", "EQUAL");
        filterField.put("taskType", "EQUAL");
        filterField.put("(like)packetId", "LIKE");
        return filterField;
    }

    public JSONArray listDataPacketDraft(Map<String, Object> params, PageDesc pageDesc) {
        String sqlSen = "select a.packet_id, a.packet_name, a.packet_desc, a.owner_type, a.owner_code, a.recorder, a.record_date, a.update_date, a.os_id, a.opt_id, a.task_type, a.task_cron, a.is_valid, a.publish_date, a.opt_code,a.log_level, a.is_disable, b.last_run_time, b.next_run_time  from q_data_packet_draft a left join q_data_packet b on a.packet_id=b.packet_id where 1=1 [:(like)packetName | and (a.packet_name like :packetName or a.packet_id like :packetName) ] [:osId| and a.os_id=:osId] [:optId| and a.opt_id=:optId] [:isDisable| and a.is_disable=:isDisable] [:taskType| and a.task_type=:taskType] [:(like)packetId| and a.packet_id like :packetId] order by a.update_date desc";
        return DatabaseOptUtils.listObjectsByParamsDriverSqlAsJson((BaseDaoImpl)this, (String)sqlSen, params, (PageDesc)pageDesc);
    }

    public void publishDataPacket(String optCode, DataPacketDraft dataPacketCopy) {
        String sql = "update q_data_packet_draft SET publish_date=? ,opt_code=?  WHERE  PACKET_ID=? ";
        this.getJdbcTemplate().update(sql, new Object[]{dataPacketCopy.getPublishDate(), optCode, dataPacketCopy.getPacketId()});
    }

    public int[] batchUpdateOptIdByApiId(final String optId, final List<String> apiIds) {
        String sql = "UPDATE q_data_packet_draft SET OPT_ID=? ,IS_DISABLE='F' WHERE PACKET_ID = ? ";
        int[] dataPacket = this.getJdbcTemplate().batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setString(1, optId);
                ps.setString(2, (String)apiIds.get(i));
            }

            public int getBatchSize() {
                return apiIds.size();
            }
        });
        return dataPacket;
    }

    public void updateDisableStatus(String packetId, String disable) {
        String sql = "UPDATE q_data_packet_draft SET IS_DISABLE=? WHERE PACKET_ID = ? ";
        this.getJdbcTemplate().update(sql, new Object[]{disable, packetId});
    }

    public void batchDeleteByPacketIds(final String[] packetIds) {
        String delSql = "DELETE FROM q_data_packet_draft WHERE PACKET_ID = ? ";
        this.getJdbcTemplate().batchUpdate(delSql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setString(1, packetIds[i]);
            }

            public int getBatchSize() {
                return packetIds.length;
            }
        });
    }

    public int clearTrashStand(String osId) {
        String delSql = "DELETE FROM q_data_packet_draft WHERE IS_DISABLE = 'T' AND  OS_ID=? ";
        int delCount = DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)delSql, (Object[])new Object[]{osId});
        return delCount;
    }

    public void updateDataPacketOptJson(String packetId, String dataPacketOptJson) {
        DatabaseOptUtils.batchUpdateObject((BaseDaoImpl)this, DataPacketDraft.class, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"dataOptDescJson", dataPacketOptJson}), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"packetId", packetId}));
    }
}

