/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.utils;

import com.centit.dde.annotation.ClasssDescribe;
import com.centit.dde.annotation.MethodDescribe;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

@ClasssDescribe
public class RedisOperationUtils {
    private RedisTemplate<String, Object> redisTemplate;

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @MethodDescribe(describe="\u6307\u5b9a\u7f13\u5b58\u5931\u6548\u65f6\u95f4", parameter={"redisKey:String", "time:Long"})
    public boolean expireTime(String redisKey, Long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)redisKey, time.longValue(), TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u6839\u636ekey\u83b7\u53d6\u8fc7\u671f\u65f6\u95f4", parameter={"redisKey:String"})
    public Long getExpireTime(String redisKey) {
        return this.redisTemplate.getExpire((Object)redisKey, TimeUnit.SECONDS);
    }

    @MethodDescribe(describe="\u5224\u65adkey\u662f\u5426\u5b58\u5728", parameter={"redisKey:String"})
    public boolean isExistKey(String redisKey) {
        try {
            return this.redisTemplate.hasKey((Object)redisKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u5220\u9664\u7f13\u5b58", parameter={"redisKey:String"})
    public void deleteKey(String ... redisKey) {
        if (redisKey != null && redisKey.length > 0) {
            if (redisKey.length == 1) {
                this.redisTemplate.delete((Object)redisKey[0]);
            } else {
                List list = CollectionUtils.arrayToList((Object)redisKey);
                this.redisTemplate.delete((Collection)list);
            }
        }
    }

    @MethodDescribe(describe="\u83b7\u53d6String\u7c7b\u578b\u6570\u636e", parameter={"redisKey:String"})
    public Object getStringData(String redisKey) {
        return redisKey == null ? null : this.redisTemplate.opsForValue().get((Object)redisKey);
    }

    @MethodDescribe(describe="\u4fdd\u5b58String\u7c7b\u578b\u6570\u636e", parameter={"redisKey:String", "value:Object"})
    public boolean saveStringData(String redisKey, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)redisKey, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u4fdd\u5b58String\u7c7b\u578b\u6570\u636e\uff0c\u5e76\u8bbe\u7f6e\u8fc7\u53bb\u65f6\u95f4", parameter={"redisKey:String", "value:Object", "time:Long"})
    public boolean saveStringDataAndSetTime(String redisKey, Object value, Long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)redisKey, value, time.longValue(), TimeUnit.SECONDS);
            } else {
                this.saveStringData(redisKey, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u9012\u589e", parameter={"redisKey:String", "delta:long"})
    public Long incr(String redisKey, Long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)redisKey, delta.longValue());
    }

    @MethodDescribe(describe="\u9012\u51cf", parameter={"redisKey:String", "delta:Long"})
    public Long decr(String redisKey, Long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)redisKey, -delta.longValue());
    }

    @MethodDescribe(describe="\u6839\u636eredisKey\u548cmapKey\u83b7\u53d6\u503c", parameter={"redisKey:String", "mapKey:String"})
    public Object getValueByMapKey(String redisKey, String mapKey) {
        return this.redisTemplate.opsForHash().get((Object)redisKey, (Object)mapKey);
    }

    @MethodDescribe(describe="\u6839\u636eredisKey\u83b7\u53d6map\u503c", parameter={"redisKey:String"})
    public Map<Object, Object> getMapData(String redisKey) {
        return this.redisTemplate.opsForHash().entries((Object)redisKey);
    }

    @MethodDescribe(describe="\u4fdd\u5b58map\u6570\u636e", parameter={"redisKey:String", "map:Map"})
    public boolean saveMapData(String redisKey, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)redisKey, map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u4fdd\u5b58map\u6570\u636e \u5e76\u8bbe\u7f6e\u65f6\u95f4", parameter={"redisKey:String", "map:Map", "time:Long"})
    public boolean saveMapDataAndSetTime(String redisKey, Map<String, Object> map, Long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)redisKey, map);
            if (time > 0L) {
                this.expireTime(redisKey, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe=" \u6839\u636e2\u4e2akey\u66f4\u65b0\u503c ,\u5982\u679c\u4e0d\u5b58\u5728\u5c06\u521b\u5efa", parameter={"redisKey:String", "mapKey:String", "value:Object"})
    public boolean updateOrAddMapData(String redisKey, String mapKey, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)redisKey, (Object)mapKey, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe=" \u6839\u636e2\u4e2akey\u66f4\u65b0\u503c ,\u5982\u679c\u4e0d\u5b58\u5728\u5c06\u521b\u5efa,\u5e76\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4", parameter={"redisKey:String", "mapKey:String", "value:Object", "time:long"})
    public boolean updateOrAddMapDataAndSetTime(String redisKey, String mapKey, Object value, Long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)redisKey, (Object)mapKey, value);
            if (time > 0L) {
                this.expireTime(redisKey, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u5220\u9664map\u4e2d\u7684key", parameter={"redisKey:String", "mapKey:Object"})
    public Long removeMapData(String redisKey, Object ... mapKey) {
        return this.redisTemplate.opsForHash().delete((Object)redisKey, mapKey);
    }

    @MethodDescribe(describe="\u5224\u65admap\u4e2d\u662f\u5426\u5b58\u5728\u6307\u5b9a\u7684\u503c", parameter={"redisKey:String", "mapKey:String"})
    public boolean isExistByMapKey(String redisKey, String mapKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)redisKey, (Object)mapKey);
    }

    @MethodDescribe(describe="map\u9012\u589e\u5982\u679c\u4e0d\u5b58\u5728,\u5c31\u4f1a\u521b\u5efa\u4e00\u4e2a\u5e76\u628a\u65b0\u589e\u540e\u7684\u503c\u8fd4\u56de", parameter={"redisKey:String", "mapKey:String", "delta:double"})
    public double mapIncr(String redisKey, String mapKey, double delta) {
        return this.redisTemplate.opsForHash().increment((Object)redisKey, (Object)mapKey, delta);
    }

    @MethodDescribe(describe="map\u9012\u51cf", parameter={"redisKey:String", "mapKey:String", "delta:double"})
    public double mapDecr(String redisKey, String mapKey, double delta) {
        return this.redisTemplate.opsForHash().increment((Object)redisKey, (Object)mapKey, -delta);
    }

    @MethodDescribe(describe="\u6839\u636ekey\u83b7\u53d6Set\u96c6\u5408\u4e2d\u7684\u6240\u6709\u503c", parameter={"redisKey:String"})
    public Set<Object> getAllSetData(String redisKey) {
        try {
            return this.redisTemplate.opsForSet().members((Object)redisKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @MethodDescribe(describe="\u6839\u636evalue\u5224\u65adset\u96c6\u5408\u4e2d\u662f\u5426\u5b58\u5728", parameter={"redisKey:String", "value:Object"})
    public boolean isExistByValue(String redisKey, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)redisKey, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u5c06set\u96c6\u5408\u6570\u636e\u653e\u5165\u7f13\u5b58", parameter={"redisKey:String", "values:Object"})
    public Long saveSetData(String redisKey, Object values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)redisKey, new Object[]{values});
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @MethodDescribe(describe="\u5c06set\u96c6\u5408\u6570\u636e\u653e\u5165\u7f13\u5b58,\u5e76\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4", parameter={"redisKey:String", "time:Long", "values:Object"})
    public Long saveSetDataAndSetTime(String redisKey, Object values, Long time) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)redisKey, new Object[]{values});
            if (time > 0L) {
                this.expireTime(redisKey, time);
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @MethodDescribe(describe="\u83b7\u53d6set\u96c6\u5408\u5927\u5c0f", parameter={"redisKey:String"})
    public Long getSetListSize(String redisKey) {
        try {
            return this.redisTemplate.opsForSet().size((Object)redisKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @MethodDescribe(describe="\u6839\u636evalue\u5220\u9664set\u96c6\u5408\u6570\u636e", parameter={"redisKey:String", "values:Object"})
    public Long removeDataByValue(String redisKey, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)redisKey, values);
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @MethodDescribe(describe="\u83b7\u53d6List\u96c6\u5408\u6570\u636e,\u5e76\u6307\u5b9a\u8fd4\u56de\u6761\u6570,0\u5230-1\u4ee3\u8868\u6240\u6709\u503c", parameter={"redisKey:String", "start:Long", "end:Long"})
    public List<Object> getListData(String redisKey, Long start, Long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)redisKey, start.longValue(), end.longValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @MethodDescribe(describe="\u83b7\u53d6list\u96c6\u5408\u5927\u5c0f", parameter={"redisKey:String"})
    public Long getListSize(String redisKey) {
        try {
            return this.redisTemplate.opsForList().size((Object)redisKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @MethodDescribe(describe="\u901a\u8fc7\u7d22\u5f15 \u83b7\u53d6list\u4e2d\u7684\u503c", parameter={"redisKey:String", "index:Long"})
    public Object getListDataByIndex(String redisKey, Long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)redisKey, index.longValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @MethodDescribe(describe="\u5c06list\u96c6\u5408\u653e\u5165\u7f13\u5b58", parameter={"redisKey:String", "value:Object"})
    public boolean saveObjectListData(String redisKey, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)redisKey, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u5c06list\u96c6\u5408\u653e\u5165\u7f13\u5b58,\u5e76\u6307\u5b9a\u8fc7\u671f\u65f6\u95f4", parameter={"redisKey:String", "value:Object", "time:Long"})
    public boolean saveObjectListDataAndSetTime(String redisKey, Object value, Long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)redisKey, value);
            if (time > 0L) {
                this.expireTime(redisKey, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u5c06list\u96c6\u5408\u653e\u5165\u7f13\u5b58", parameter={"redisKey:String", "values:List<Object>"})
    public boolean saveListData(String redisKey, List<Object> values) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)redisKey, values);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u5c06list\u653e\u5165\u7f13\u5b58,\u5e76\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4", parameter={"redisKey:String", "values:List<Object>", "time:Long"})
    public boolean saveListDataAndSetTime(String redisKey, List<Object> value, Long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)redisKey, value);
            if (time > 0L) {
                this.expireTime(redisKey, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u6839\u636e\u7d22\u5f15\u4fee\u6539list\u4e2d\u7684\u67d0\u6761\u6570\u636e", parameter={"redisKey:String", "index:Long", "value:Object"})
    public boolean updateListDataByIndex(String redisKey, Long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)redisKey, index.longValue(), value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @MethodDescribe(describe="\u6839\u636evalue\u5220\u9664\u6570\u636e\uff0c\u5e76\u4e14\u6307\u5b9a\u5220\u9664\u6570\u636e\u7684\u6761\u6570", parameter={"redisKey:String", "count:Long", "value:Object"})
    public Long removeListData(String redisKey, Long count, Object value) {
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)redisKey, count.longValue(), value);
            return remove;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @MethodDescribe(describe="\u6a21\u7cca\u67e5\u8be2\u83b7\u53d6key\u503c", parameter={"pattern:String"})
    public Set keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    @MethodDescribe(describe="\u4f7f\u7528Redis\u7684\u6d88\u606f\u961f\u5217", parameter={"channel:String", "message:Object"})
    public void convertAndSend(String channel, Object message) {
        this.redisTemplate.convertAndSend(channel, message);
    }

    @MethodDescribe(describe="\u6839\u636e\u8d77\u59cb\u7ed3\u675f\u5e8f\u53f7\u904d\u5386Redis\u4e2d\u7684list", parameter={"listKey:String", "start:Long", "end:Long"})
    public List<Object> rangeList(String listKey, Long start, Long end) {
        BoundListOperations boundValueOperations = this.redisTemplate.boundListOps((Object)listKey);
        return boundValueOperations.range(start.longValue(), end.longValue());
    }

    @MethodDescribe(describe="\u5f39\u51fa\u53f3\u8fb9\u7684\u503c --- \u5e76\u4e14\u79fb\u9664\u8fd9\u4e2a\u503c", parameter={"listKey:String"})
    public Object rifhtPop(String listKey) {
        BoundListOperations boundValueOperations = this.redisTemplate.boundListOps((Object)listKey);
        return boundValueOperations.rightPop();
    }
}

