/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.config;

import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.config.RedisTypeEnum;
import com.centit.product.adapter.po.SourceInfo;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisConfig
extends CachingConfigurerSupport {
    private static ConcurrentHashMap<String, RedisTemplate> redisTemplateConcurrentHashMap = new ConcurrentHashMap(10);

    private GenericObjectPoolConfig genericObjectPoolConfig(JSONObject extProps) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setBlockWhenExhausted(extProps.getBoolean("blockWhenExhausted") == null ? true : extProps.getBoolean("blockWhenExhausted"));
        config.setEvictionPolicyClassName(StringUtils.isNotBlank((CharSequence)extProps.getString("evictionPolicyClassName")) ? extProps.getString("evictionPolicyClassName") : "org.apache.commons.pool2.impl.DefaultEvictionPolicy");
        config.setJmxEnabled(extProps.getBoolean("jmxEnabled") == null ? true : extProps.getBoolean("jmxEnabled"));
        config.setJmxNamePrefix(StringUtils.isNotBlank((CharSequence)extProps.getString("jmxNamePrefix")) ? extProps.getString("jmxNamePrefix") : "pool");
        config.setLifo(extProps.getBoolean("lifo") == null ? true : extProps.getBoolean("lifo"));
        config.setMaxIdle(extProps.getIntValue("maxIdle") > 0 ? extProps.getIntValue("maxIdle") : 10);
        config.setMaxTotal(extProps.getIntValue("maxTotal") > 0 ? extProps.getIntValue("maxTotal") : 20);
        config.setMaxWaitMillis(extProps.getIntValue("maxWaitMillis") > 0 ? (long)extProps.getIntValue("maxWaitMillis") : 30000L);
        config.setMinEvictableIdleTimeMillis(extProps.getIntValue("minEvictableIdleTimeMillis") > 0 ? (long)extProps.getIntValue("minEvictableIdleTimeMillis") : 60000L);
        config.setMinIdle(extProps.getIntValue("minIdle") > 0 ? extProps.getIntValue("minIdle") : 1);
        config.setNumTestsPerEvictionRun(extProps.getIntValue("numTestsPerEvictionRun") > 0 ? extProps.getIntValue("numTestsPerEvictionRun") : 3);
        config.setSoftMinEvictableIdleTimeMillis(extProps.getIntValue("softMinEvictableIdleTimeMillis") > 0 ? (long)extProps.getIntValue("softMinEvictableIdleTimeMillis") : 1800000L);
        config.setTestOnBorrow(extProps.getBoolean("testOnBorrow") == null ? false : extProps.getBoolean("testOnBorrow"));
        config.setTestWhileIdle(extProps.getBoolean("testWhileIdle") == null ? true : extProps.getBoolean("testWhileIdle"));
        config.setTimeBetweenEvictionRunsMillis(extProps.getIntValue("timeBetweenEvictionRunsMillis") > 0 ? (long)extProps.getIntValue("timeBetweenEvictionRunsMillis") : -1L);
        return config;
    }

    private LettuceConnectionFactory lettuceConnectionFactory(SourceInfo sourceInfo, RedisTypeEnum nodeType) {
        String[] ipAndPortArr;
        String databaseUrl = sourceInfo.getDatabaseUrl();
        if (StringUtils.isBlank((CharSequence)databaseUrl)) {
            return null;
        }
        JSONObject extProps = sourceInfo.getExtProps();
        String[] split = databaseUrl.split(",");
        ArrayList<RedisNode> redisNodeList = new ArrayList<RedisNode>();
        for (String ipAndPort : split) {
            ipAndPortArr = ipAndPort.split(":");
            redisNodeList.add(new RedisNode(ipAndPortArr[0], Integer.valueOf(ipAndPortArr[1]).intValue()));
        }
        int redisTimeout = extProps.getIntValue("redisTimeout") > 0 ? extProps.getIntValue("redisTimeout") : 20000;
        int shutdownTimeOut = extProps.getIntValue("shutdownTimeOut") > 0 ? extProps.getIntValue("shutdownTimeOut") : 1000;
        LettuceConnectionFactory lettuceConnectionFactory = null;
        String password = sourceInfo.getClearPassword();
        LettucePoolingClientConfiguration lettuceClientConfiguration = LettucePoolingClientConfiguration.builder().commandTimeout(Duration.ofMillis(redisTimeout)).shutdownTimeout(Duration.ofMillis(shutdownTimeOut)).poolConfig(this.genericObjectPoolConfig(extProps)).build();
        switch (nodeType) {
            case SINGLENODE: {
                RedisStandaloneConfiguration oneRedisConfig = new RedisStandaloneConfiguration();
                ipAndPortArr = split[0].split(":");
                oneRedisConfig.setPassword(password);
                oneRedisConfig.setDatabase(0);
                oneRedisConfig.setHostName(ipAndPortArr[0]);
                oneRedisConfig.setPort(Integer.valueOf(ipAndPortArr[1]).intValue());
                lettuceConnectionFactory = new LettuceConnectionFactory(oneRedisConfig, (LettuceClientConfiguration)lettuceClientConfiguration);
                break;
            }
            case CLUSTER: {
                RedisClusterConfiguration clusterRedisConfig = new RedisClusterConfiguration();
                clusterRedisConfig.setClusterNodes(redisNodeList);
                clusterRedisConfig.setPassword(password);
                lettuceConnectionFactory = new LettuceConnectionFactory(clusterRedisConfig, (LettuceClientConfiguration)lettuceClientConfiguration);
                break;
            }
            case SENTINEL: {
                RedisSentinelConfiguration sentinelRedisConfig = new RedisSentinelConfiguration();
                sentinelRedisConfig.setSentinels(redisNodeList);
                sentinelRedisConfig.setMaster(sourceInfo.getDatabaseName());
                sentinelRedisConfig.setPassword(password);
                lettuceConnectionFactory = new LettuceConnectionFactory(sentinelRedisConfig, (LettuceClientConfiguration)lettuceClientConfiguration);
            }
        }
        if (lettuceConnectionFactory != null) {
            lettuceConnectionFactory.afterPropertiesSet();
        }
        return lettuceConnectionFactory;
    }

    public RedisTemplate<String, Object> redisTemplate(SourceInfo sourceInfo, RedisTypeEnum nodeType) {
        sourceInfo.setLastModifyDate(null);
        if (redisTemplateConcurrentHashMap.containsKey(sourceInfo.toString())) {
            return redisTemplateConcurrentHashMap.get(sourceInfo.toString());
        }
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)this.lettuceConnectionFactory(sourceInfo, nodeType));
        Jackson2JsonRedisSerializer jacksonSeial = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jacksonSeial.setObjectMapper(om);
        template.setValueSerializer((RedisSerializer)jacksonSeial);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)jacksonSeial);
        template.afterPropertiesSet();
        if (!redisTemplateConcurrentHashMap.containsKey(sourceInfo.toString())) {
            redisTemplateConcurrentHashMap.put(sourceInfo.toString(), template);
        }
        return template;
    }
}

